<?php

$logo_settings = get_option( 'theodore_site_logo' );

$logo_default = isset( $logo_settings['logo_default'] ) ? $logo_settings['logo_default'] : '';
$logo_light = isset( $logo_settings['logo_light'] ) ? $logo_settings['logo_light'] : '';

if ( '' == esc_url( $logo_default ) && '' != esc_url( $logo_light ) ) {
	$logo_default = esc_url( $logo_light );
}

$social_media_link_anchors = array();
$social_icons = array(
	'twitter_url' => 'twitter',
	'instagram_url' => 'instagram',
	'google_url' => 'google-plus',
	'facebook_url' => 'facebook',
	'linkedin_url' => 'linkedin',
	'github_url' => 'github',
	'dribbble_url' => 'dribbble',
);
$social_media_settings = get_option( 'theodore_social_media' );
if ( is_array( $social_media_settings ) ) {
	foreach ( $social_media_settings as $k => $v ) {
		if ( esc_url( $v ) != '' && isset( $social_icons[$k] ) ) {
			$social_media_link_anchors[] = '<a href="' . esc_url( $v ) . '" target="_blank" rel="noopener noreferrer"><i class="fa fa-' . esc_attr( $social_icons[$k] ) . '"></i></a>';
		}
	}
}

?><!DOCTYPE html>
<!--[if IE 9]> <html class="lt-ie10" lang="<?php esc_attr( language_attributes() ); ?>"> <![endif]-->
<!--[if gt IE 9]><!--> <html <?php esc_attr( language_attributes() ); ?>> <!--<![endif]-->
<head>
	<meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
	
	<?php wp_head(); ?>
	
</head>
<body <?php body_class(); ?>>
<header>
	<div class="handle"></div>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="branding <?php echo esc_url( $logo_default ) == '' ? 'text' : ''; ?>">
		<?php
		
		if ( esc_url( $logo_default ) != '' ) {
			echo '<img src="' . esc_url( $logo_default ) . '" data-light-logo="' . esc_url( $logo_light ) . '" alt="' . esc_attr( get_bloginfo( 'site_name' ) ) . '"/>';
		}
		else {
			echo esc_html( get_bloginfo( 'site_name' ) );
		}
		?>
	</a>
	<div class="label">
		<div class="tabulated">
			<div class="cell">
				<div class="wrapper"></div>
			</div>
		</div>
	</div>
	<?php if ( count( $social_media_link_anchors ) > 0 ) : ?>
	<div class="social">
		<div class="tabulated">
			<div class="cell">
				<?php foreach ( $social_media_link_anchors as $tag ) : echo $tag; endforeach; ?>
			</div>
		</div>
	</div>
	<?php endif; ?>
	<div class="toggle"><span></span><span></span><span></span></div>
</header>

<?php

/* Sidebar settings */
$sidebar_settings = get_option( 'theodore_menu_container' );
$sidebar_background_color = isset( $sidebar_settings['sidebar_background_color'] ) && $sidebar_settings['sidebar_background_color'] != '' ? $sidebar_settings['sidebar_background_color'] : '#181818';
$menu_background_image = isset( $sidebar_settings['menu_background_image'] ) ? $sidebar_settings['menu_background_image'] : '';
$menu_cover_opacity = isset( $sidebar_settings['menu_cover_opacity'] ) ? $sidebar_settings['menu_cover_opacity'] : '';
$menu_cover_opacity_class = $menu_cover_opacity != '' ? 'opacity-' . str_replace( '.', '-', $menu_cover_opacity ) : '';

?>
<nav class="main has-handler-data <?php echo esc_attr( $menu_cover_opacity_class ); ?>"
	data-bg-color="<?php echo esc_attr( $sidebar_background_color ); ?>"
	data-background-image="<?php echo esc_url( $menu_background_image ); ?>"
	>
	<div class="container">
		<div class="tabulated">
			<div class="cell">
				<div class="primary">
					<?php wp_nav_menu( array(
						'container' => 'ul',
						'menu_class' => 'plain-list',
						'link_before' => '<span>',
						'link_after' => '</span>',
						'theme_location' => 'primary',
						'menu_id' => 'primary-menu',
						'items_wrap' => '<ul class="plain-list">%3$s</ul>'
					) ); ?>
				</div>
				<div class="social">
					<?php if ( count( $social_media_link_anchors ) > 0 ) : ?>
						<?php foreach ( $social_media_link_anchors as $tag ) : echo $tag; endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</nav>

<?php

global $post;

$label = '';
$intro = '';
if ( is_singular() && $post && property_exists( $post, 'post_title' ) ) {
	
	if ( 'post' == get_post_type() ) {
		/* TRANSLATORS: Text before post title on sidebar. (Front end) */
		$intro = esc_html__( 'Article', 'theodore' );
	}
	$label = ( $intro == '' ? '' : $intro . ' / ' ) . $post->post_title;
	
}

?>

<main class="has-handler-data clearfix"
	data-label="<?php echo $label; ?>"
	>