<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package theodore
 */

global $theodore_tags;

function theodore_custom_comment_list ( $comment, $args, $depth ) {
	/* Important! : Don't close the <li> tag or the HTML won't validate. It's weird! */
	?>
    <li <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
		
		<div class="container clearfix">
			<?php /* TRANSLATORS: Default placeholder for comment author's name. (Front end) */ ?>
			<div class="avatar-container" data-name="<?php echo esc_attr( $comment->comment_author ) ? esc_attr( $comment->comment_author ) : esc_html__( 'Anonymous', 'theodore' ); ?>">
				<?php echo get_avatar( $comment, 130 ); ?>
			</div>
			<div class="byline">
				<span class="author"><?php echo get_comment_author_link(); ?></span>
				<span class="datetime"><?php printf( '%1$s &middot; %2$s', esc_html( get_comment_date() ),  esc_html( get_comment_time() ) ); ?></span>
				<div class="reply">
					<?php
					comment_reply_link(
						array('depth' => $depth, 'max_depth' => $args['max_depth'])
					);
					?>
				</div>
			</div>
			<div class="comment-body">
				<?php comment_text(); ?>
			</div>
		</div>
	
    <?php
}

?>

<?php if ( have_comments() ) : ?>
	<h3 id="comments">
		<span>
			<?php
				printf( /* WPCS: XSS OK. */
					/* TRANSLATORS: Title for comments section when there is at least one comment. (Front end) */
					esc_html( _nx( 'One comment so far', '%1$s comments so far', esc_html( get_comments_number() ), 'Title for comments section', 'theodore' ) ),
					number_format_i18n( get_comments_number() )
				);
			?>
		</span>
	</h3>
	
	<ol class="commentlist">
		<?php
			wp_list_comments( array(
				'callback'	 => 'theodore_custom_comment_list',
				'style'      => 'ol',
				'short_ping' => true,
			) );
		?>
	</ol>
	
	<?php
	
	/* Comment Pagination */
	
	if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {
		/* TRANSLATORS: Label for the link to older comments. (Front end) */
		$prev_link = get_previous_comments_link( esc_html__( 'Older comments', 'theodore' ) );
		/* TRANSLATORS: Label for the link to newer comments. (Front end) */
		$next_link = get_next_comments_link( esc_html__( 'Newer comments', 'theodore' ) );
		
		echo '<div class="pagination align-center">' . $prev_link . $next_link . '</div>';
	}
	
	?>
	
	<?php
	/* If comments are closed and there are comments, let's leave a little note, shall we? */
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<?php /* TRANSLATORS: Text to show on when comments are closed. (Front end) */ ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed', 'theodore' ); ?></p>
	<?php
	endif;
	?>
	
<?php endif; ?>

<?php

$commenter = wp_get_current_commenter();
$req = get_option( 'require_name_email' );
$aria_req = ( $req ? ' required' : '' );

comment_form( array(
	/* TRANSLATORS: Title for comments section when there is no comment yet. (Front end) */
	'title_reply'	=> '<span>' . esc_html__( 'Share your thought', 'theodore' ) . '</span>',
	'class_submit'	=> 'styled-button',
	/* TRANSLATORS: Label for message field on comment section. (Front end) */
	'comment_field'	=> '<p class="comment-text">
							<label for="comment" class="border-box">' . esc_html__( 'Let us know what your have to say', 'theodore' ) . ( $req ? '<span class="required">*</span>' : '' ) . '</label>
							<textarea name="comment" id="comment" class=" border-box" cols="30" rows="10" required></textarea>
						</p>',
	'fields'		=> array (
		/* TRANSLATORS: Label for name field on comment section. (Front end) */
		'author'	=> '<p class="comment-name">
							<label for="author" class="border-box">' . esc_html__( 'Your name', 'theodore' ) . ( $req ? '<span class="required">*</span>' : '' ) . '</label>
							<input type="text" class="widefat border-box" id="author" name="author" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . ' />
						</p>',
		/* TRANSLATORS: Label for email field on comment section. (Front end) */
		'email'		=> '<p class="comment-email">
							<label for="email" class="border-box">' . esc_html__( 'Your email', 'theodore' ) . ( $req ? '<span class="required">*</span>' : '' ) . '</label>
							<input type="email" class="widefat border-box" id="email" name="email" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" ' . $aria_req . ' />
						</p>',
		/* TRANSLATORS: Label for website url field on comment section. (Front end) */
		'url'		=> '<p class="comment-url">
							<label for="url" class="border-box">' . esc_html__( 'Your website URL', 'theodore' ) . '</label>
							<input type="url" class="widefat border-box" id="url" name="url" value="' . esc_url( $commenter['comment_author_url'] ) . '" />
						</p>'
	)
) );

?>