jQuery(function($) {
	
	'use strict';
	
	/**
	 * jQuery Tiny Pub/Sub
	 * https://github.com/cowboy/jquery-tiny-pubsub
	 *
	 * Copyright (c) 2013 "Cowboy" Ben Alman
	 * Licensed under the MIT license.
	 **********************************************************************/
	var o = $({});
	$.subscribe = function() {o.on.apply(o, arguments);};
	$.unsubscribe = function() {o.off.apply(o, arguments);};
	$.publish = function() {o.trigger.apply(o, arguments);};
	
	/**
	 * Extending library: jQuery Color plugin
	 **********************************************************************/
	if (jQuery.Color) {
		
		/* Get a darker or lighter of a colour. */
		jQuery.Color.fn.shade = function (percent) {
			var t = percent < 0 ? 0 : 255
				, p = percent < 0 ? percent * -1 : percent
				, R = Math.round((t - this._rgba[0]) * p) + this._rgba[0]
				, G = Math.round((t - this._rgba[1]) * p) + this._rgba[1]
				, B = Math.round((t - this._rgba[2]) * p) + this._rgba[2]
				;
			
			return $.Color(R, G, B, this._rgba[3]);
		};
		
		/* 	Get contrast from a colour 
			Source: http://24ways.org/2010/calculating-color-contrast
			*/
		jQuery.Color.fn.contrastColor = function() {
			var r = this._rgba[0], g = this._rgba[1], b = this._rgba[2];
			return (((r * 299) + (g * 587) + (b * 114)) / 1000) >= 128 ? 'black' : 'white';
		};
	}
	
	/**
	 * Save the main building block of DOM elements; for the 
	 * sake of succinctness
	 **********************************************************************/
	var DOM = (function (dom) {
		
		var dom = dom || {};
		
		dom.body = $('body:eq(0)');
		dom.header = dom.body.find('header');
		dom.main = dom.body.find('main');
		dom.footer = dom.body.find('footer');
		dom.winHeight = $(window).height();
		dom.winWidth = $(window).width();
		dom.isMobile = $(window).width() < 768 ? true : false;
		dom.isSmallScreen = $(window).width() < 480 ? true : false;
		
		return dom;
		
	}(DOM));
	
	/**
	* Some elements may need to have a full-screen height. Set it as soon
	* as possible because we will check elements in particular positions
	* to style the header.
	**********************************************************************/
	(function () {
		
		if (DOM.isMobile) {
			return;
		}
		
		DOM.body.find('.full-height, .half-height, .one-third-height, .two-thirds-height, .quarter-height').each(function () {
			var el = $(this)
				, division
				, maxHeight = 0
				;
			
			el.imagesLoaded().always(function (instance) {
				if (el.is('.full-height')) { maxHeight = DOM.winHeight; }
				if (el.is('.half-height')) { maxHeight = DOM.winHeight / 2; }
				if (el.is('.one-third-height')) { maxHeight = DOM.winHeight / 3; }
				if (el.is('.two-thirds-height')) { maxHeight = (DOM.winHeight / 3) * 2; }
				if (el.is('.quarter-height')) { maxHeight = DOM.winHeight / 4; }
				
				if (el.is('.module-portfolio.rectangular .item')) {
					maxHeight = 0;
				}
				
				if (el.outerHeight() < maxHeight) {
					el.css({
						height: maxHeight
					});
				}
				
				if ((el.offset().top - $(window).scrollTop()) <= 150) {
					$.publish('check-header-state', 'up');
				}
				
			});
			
		});
		
	}());
	
	/**
	* Subscriptions: Check if we need to reset the header style and text
	**********************************************************************/
	(function () {
		
		var labelContainer = DOM.header.find('.label .cell')
			, defaultLabel = labelContainer.find('span').text()
			, handle = DOM.header.find('.handle')
			, defaultBGColor = handle.css('background-color')
			, defaultFGColor = DOM.header.css('color')
			, resetHeader = function (data) {
				
				var direction = data.hasOwnProperty('direction') ? data.direction.toLowerCase() : false
					, label = data.hasOwnProperty('label') ? data.label : false
					, bgColor = data.hasOwnProperty('bgColor') ? data.bgColor : false
					, fgColor = data.hasOwnProperty('fgColor') ? data.fgColor : false
					, theBGColor = bgColor ? $.Color(bgColor).toHexString() : defaultBGColor
					, theFGColor = $.Color(theBGColor).contrastColor()
					;
				
				/* Change handle background and border colour */
				handle.css({
					backgroundColor: theBGColor
					, borderRightColor: $.Color(theBGColor).shade(-0.03)
				});
				
				/* Change text and hamburger colour */
				DOM.header.css({
					color: theFGColor
				});
				
				DOM.header.find('.toggle span').css({
					backgroundColor: theFGColor
				});
				
				/* 	Add the appropriate class name just in case there's a logo for 
					dark or light background */
				if (theFGColor.toLowerCase() == 'black') {
					DOM.header.removeClass('light-logo').addClass('dark-logo');
				}
				else {
					DOM.header.removeClass('dark-logo').addClass('light-logo');
				}
				
				/* Change label text if the screen is wide enough */
				
				if (!DOM.isSmallScreen) {
					var newText = label ? label : defaultLabel
						, activeLabel = labelContainer.find('.active')
						, currentLabel = activeLabel.text()
						, spanClass = direction == 'up' ? 'to-top' : ''
						;
					
					if (currentLabel == newText) {
						activeLabel.find('span').text(newText);
					}
					else {
						var newElement = $('<div class="wrapper ' + spanClass + '"><span>' + newText + '</span></div>')
							, fromLeft
							;
						
						labelContainer.append(newElement);
						
						if (DOM.isMobile) {
							fromLeft = '50%';
						}
						else {
							
							var centerPoint = handle.outerWidth() / 2
								, centerElement = newElement.outerWidth() / 2
								, fromLeft = centerPoint >= centerElement
									? centerPoint - centerElement
									: -(centerElement - centerPoint)
								;
						}
						
						newElement.css({
							left: fromLeft
						}).removeClass('to-top').addClass('active');
						
						
						activeLabel.removeClass('active');
						if (direction == 'down') {
							activeLabel.addClass('to-top');
						}
						setTimeout(function () {
							activeLabel.remove();
						}, 300);
					}
				}
				
			}
		
		var currentTarget
			, target
			, suspect
			, candidate
			, currentFalseRow
			, middleGrid = (DOM.main.outerWidth() / 3) / 2
			, distanceFromTop = DOM.isMobile 
				? DOM.header.outerHeight() /* Handler is a header. */
				: (DOM.winHeight / 2) - 1 /* Handler is a sidebar. Should we pull 100px up? */
			, distanceFromLeft = DOM.isMobile 
				? 10 /* Handler is a header */
				: DOM.header.position().left + DOM.header.outerWidth() + 10 /* Handler is a sidebar */ 
			, likelyParents = [
				'.row'
				, '.module-portfolio .item'
			].join(', ')
			, checkHeader = function (e, direction) {
				var suspectFound = false;
				
				candidate = $(document.elementFromPoint(distanceFromLeft, distanceFromTop));
				
				suspect = candidate.closest('.has-handler-data');
				if (suspect.length) {
					target = suspect;
					suspectFound = true;
					currentFalseRow = null;
					
					/* 	The following is experimental behaviour. When the target top edge
						is at least 100px from the top screen and is intended to have a full
						height, then it's assumed that the user wants to fit the target 
						position. We kinda help them do it.
						
						But if it's the first row inside <main>, then do nothing.
						*/
					
					if (!DOM.isMobile && candidate.closest('.full-height, .half-height, .two-thirds-height, .one-third-height, .quarter-height').length) {
						
						var page = $('html, body')
							, targetTopOffset = target.offset().top
							, latestPosition = targetTopOffset - $(window).scrollTop()
							, duration = (latestPosition / 2) * 10
							;
						
						if (latestPosition <= 150 /* <-- Distance from the screen's top edge */
							&& latestPosition > 0 /* <-- It's not attached to the screen's top edge. If target is the firs element, it's not likely to be scrolled. */
							&& targetTopOffset > 160 /* <-- Even if the target is not the first element, do nothing if the distance is not high enough. Just in case there's there's a 'marquee' element on top. ;) */
							) {
							
							/* Stop animation if user is scrolling the page. */
							page.on("scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove", function(){
								page.stop();
							});
							
							/* Scroll the page. It will be stopped (using the code above) if user scroll the page manually. */
							page.animate({
								scrollTop: targetTopOffset
							}, duration, function(){
								page.off("scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove");
							});
							
						}
					}
				}
				
				if (target && target.length && !target.is(currentTarget)) {
					currentTarget = target;
					resetHeader({
						direction: direction
						, bgColor: target.data('bgColor')
						, label: target.data('label')
						, isNavigation: target.data('isNavigation')
					});
					
				}
				
				if (!suspectFound && !candidate.closest(likelyParents).is(currentFalseRow)) {
					
					if (target != null) {
						resetHeader({});
					}
					
					currentTarget = null;
					target = null;
					currentFalseRow = candidate.closest(likelyParents);
					
				}
				
			}
			;
		
		$.subscribe('check-header-state', checkHeader);
		
		/* Check header on first load */
		$.publish('check-header-state', 'up');
		
	}());
	
	/**
	* Deal with WordPress #wpadminbar
	**********************************************************************/
	(function () {
		
		var wpab = DOM.body.find('#wpadminbar')
			;
		
		wpab.css({
			position: 'fixed'
		});
		
		if (!DOM.body.is('.admin-bar')) {
			return;
		}
		
		/* Handle when resizing */
		
		var resizing
			, timing = true
			, execute
			, restyle = function () {
				
				if (DOM.main.css('margin-left') === '0px') {
					DOM.header.css({
						height: 60,
						top: wpab.outerHeight(),
						bottom: 'auto'
					});
				}
				else {
					DOM.header.css({
						height: $(window).height() - wpab.outerHeight(),
						top: 'auto',
						bottom: 0
					});
				}
			}
			;
			
		restyle();
		
		$(window).on('resize', function(e) {
			clearTimeout(execute);				
			execute = setTimeout(function () {
				restyle();
				timing = true;
				resizing = false
			}, 500);
		});
		
	}());
	
	/**
	* Branding
	**********************************************************************/
	(function () {
		
		var branding = DOM.header.find('.branding')
			, social = DOM.header.find('.social')
			, handle = DOM.header.find('.handle')
			, negativeDistance = branding.outerHeight() / 2
			;
		
		if (branding.has('img').length) {
			
			var logo = branding.find('img')
				, lightLogo = logo.data('light-logo')
				, logoHeight = logo.outerHeight()
				, logoWidth = logo.outerWidth()
				, sideGap = (handle.outerWidth() - logoWidth) / 2
				;
			
			if (sideGap < 25) {
				branding.css({
					top: Math.floor(sideGap)
				});
			}
			
			if (lightLogo) {
				logo.after('<img src="' + lightLogo + '" alt=""/>');
			}
		}
		
		branding.on('click', function (e) {
			e.stopPropagation();
		});
		
		social.find('a').on('click', function (e) {
			e.stopPropagation();
		});
		
	}());
	
	/**
	* Navigation toggle
	**********************************************************************/
	(function () {
		
		var checking
			;
		
		DOM.header.on('click', function () {
			
			/* 	The default label will be flashed upon closing the 
				navigation. Change it to a white space. */
			DOM.body.find('nav.main').data('label', '&nbsp;');
			
			DOM.body.toggleClass('open-navigation');
			
			/* Check header after toggling the navigation */
			clearTimeout(checking);
			
			if (!DOM.body.is('.open-navigation')) {
				
				/* Make sure it only fire once. */
				DOM.body.find('nav.main').one('transitionend webkitTransitionEnd oTransitionEnd', function (e) {					
					if (e.originalEvent.propertyName == 'visibility') {
						$.publish('check-header-state', 'down');
					}
				});
			}
			else {
				checking = setTimeout(function () {
					$.publish('check-header-state', 'up');
				}, 50);
			}
			
		});
		
	}());
	
	/**
	* Scroll the page when a link to inner page is clicked
	**********************************************************************/
	(function () {
		
		$(document).on('click', 'a', function(e) {
			
			var el = $(this)
				, to = el.attr('href')
				, checking
				, fromTop = DOM.isMobile ? DOM.header.outerHeight() : 0
				;
			
			if (to.charAt(0) == '#' && $.trim(to) != '#' && DOM.body.find(to).length) {
				console.log('asd');
				e.preventDefault();
				e.stopPropagation();
				
				/* 	Chrome is blinking when we click the internal links.
					So we use preventDefault() and change the URL manually */
				window.history.pushState("", "", to);
				
				$('html, body').animate({
					scrollTop: DOM.body.find(to).offset().top - fromTop
				}, 500, function () {
					
					if (!DOM.body.is('.open-navigation')) {
						DOM.body.find('nav.main').one('transitionend webkitTransitionEnd oTransitionEnd', function (e) {
							if (e.originalEvent.propertyName == 'visibility') {
								$.publish('check-header-state', 'down');
							}
						});
					}
					else {
						DOM.body.removeClass('open-navigation');
						clearTimeout(checking);
						checking = setTimeout(function () {
							$.publish('check-header-state', 'down');
						}, 50);
					}
					
				});
			}
			
		});
		
	}());
	
	/**
	* Recheck the header state on scroll
	**********************************************************************/
	(function () {
		
		var lastScrollTop = $(window).scrollTop()
			, scrolling
			, timing = true
			;
		
		/* 	Accessing DOM on-scroll is a bad idea. Let's execute the function 
			every half a second during/post scroll instead */
		$(window).scroll(function(e) {
			
			var st = $(this).scrollTop()
				, scrollDown = (st > lastScrollTop)
				;
				
			lastScrollTop = st;
			scrolling = true;
			
			if (timing) {
				
				setTimeout(function () {
					$.publish('check-header-state', (scrollDown ? 'down' : 'up'));
					timing = true;
					scrolling = false
				}, 500);
				
				if (scrolling) {
					timing = false;
				}
			}
		});
		
	}());
	
	/**
	* Adjacent posts should have the same height
	**********************************************************************/
	(function () {
		
		if (DOM.isMobile) {
			return true;
		}
		
		DOM.body.find('.blog-list').each(function () {
			
			var blogList = $(this);
			
			/* Set adjacent items' height the same per every row */
			var minHeight = 0
				, i = 0
				, indexes = []
				, items = blogList.find('.item')
				, resetNumber
				;
			
			if (blogList.is('.two-cols')) {
				resetNumber = 2;
			}
			if (blogList.is('.three-cols')) {
				resetNumber = 3;
			}
			if (blogList.is('.four-cols')) {
				resetNumber = 4;
			}
			
			for (var i = 0, limit = items.length; i < limit; i++) {
				
				var item = blogList.find('.item').eq(i)
					, text = item.find('.text')
					, textHeight = text.outerHeight()
					;
				
				if (textHeight > minHeight) {
					minHeight = textHeight;
				}
				
				indexes.push(':eq(' + i + ')');
				if ((( i + 1 ) % resetNumber == 0) || i == items.length - 1) {
					blogList.find('.item').filter(indexes.join(', ')).find('.text').css({
						minHeight: minHeight
					});
					
					indexes = [];
					minHeight = 0;
				}
				
			}
			
		});
		
	}());
	
	/**
	* Fluid Video
	**********************************************************************/
	(function () {
		
		var videoIframe = DOM.body.find('p > iframe')
			, wpVideo = DOM.body.find('.wp-video')
			;
		
		videoIframe.parent('p')
			.children('iframe')
				.removeAttr('height')
				.removeAttr('width')
			.end()
			.wrap('<div class="video-iframe-container"></div>')
			;
		
		wpVideo.removeAttr('style').removeAttr('width');
		
	}());
	
	/**
	* Figure with caption should attach to the left edge of the sibling 
	* paragraph if the screen is wide enough.
	**********************************************************************/
	(function () {
		
		var resizing
			, timing = true
			, execute
			, restyle = function () {
				
				if (DOM.main.css('margin-left') === '0px') {
					DOM.body.find('figure.wp-caption.alignleft, figure.wp-caption.alignright').each(function () {
						var el = $(this)
							;
						
						el.css({
							marginLeft: 'auto'
							, marginRight: 'auto'
						});
						
					});
				}
				else {
					
					DOM.body.find('figure.wp-caption.alignleft').each(function () {
						var el = $(this)
							, elLeftEdge = el.offset().left
							, sibling = el.next()
							, siblingLeftEdge = sibling.offset().left
							;
												
						el.css({
							marginLeft: siblingLeftEdge - el.outerWidth()
							, marginRight: 20
						});
						
					});
					
					DOM.body.find('figure.wp-caption.alignright').each(function () {
						var el = $(this)
							, elRightEdge = el.offset().left + el.outerWidth()
							, sibling = el.next()
							, siblingRightEdge = sibling.offset().left + sibling.outerWidth()
							
							;
												
						el.css({
							marginRight: (DOM.main.innerWidth() - siblingRightEdge) + 30
							, marginLeft: 20
						});
						
					});
				}
			}
			;
			
		restyle();
		
		$(window).on('resize', function(e) {
			clearTimeout(execute);				
			execute = setTimeout(function () {
				restyle();
				timing = true;
				resizing = false
			}, 500);
		});
		
	}());
	
	/**
	* Footer
	**********************************************************************/
	(function () {
		
		if (DOM.isMobile) {
			return;
		}
		
		var footer = DOM.footer
			, customSection = footer.find('.custom-section')
			, widgetContainer = footer.find('.widget-container')
			, copyright = footer.find('.copyrighting')
			, minHeight = DOM.winHeight - copyright.outerHeight()
			;
		
		if (!widgetContainer.length) {
			/* Reset the height first */
			customSection.css({
				height: 'auto'
				, minHeight: 0
			});
			
			/* Then set the new one */
			if (customSection.length && customSection.outerHeight() < minHeight) {
				customSection.css({
					height: minHeight
					, minHeight: minHeight
				});
			}
		}
		
		if (!customSection.length) {
			if (widgetContainer.length && widgetContainer.outerHeight() < minHeight) {
				widgetContainer.css({
					height: minHeight
				});
			}
		}
		
	}());
	
	/**
	* Name initial when avatar returns 404
	**********************************************************************/
	(function () {
		
		var avatars = DOM.body.find('.avatar-container')
			, colors = ['69D2E7', 'A7DBD8', 'FA6900', 'FC9D9A', 'C8C8A9', '83AF9B', 'C02942', '542437',
						'53777A', 'E97F02', 'F8CA00', '8A9B0F', '3FB8AF', 'DAD8A7', 'FF3D7F', '73626E']
			, filled = {}
			, currentIndex = -1
			, totalColors = colors.length
			;
		
		avatars.each(function () {
			var el = $(this)
				, name = el.data('name')
				, url = el.find('img').attr('src')
				;
			
			if (!name) {
				return true;
			}
			
			$.ajax({
				url: url + '&d=404',
				type: 'HEAD',
				statusCode: {
					404: function() {
						
						var initials = name.match(/\b\w/g) || [];
							initials = ((initials.shift() || '') + (initials.pop() || '')).toUpperCase();
						
						var joinedName = name.split(' ').join('')
							, avatarColor
							, indexToShow
							;
						
						if (filled[joinedName]) {
							avatarColor = filled[joinedName];
						}
						else {
							indexToShow = (currentIndex + 1) % totalColors;
							filled[joinedName] = colors[indexToShow];
							avatarColor = filled[joinedName];
							currentIndex = indexToShow;
						}
						
						el.append('<div class="initial" style="background-color: #' + avatarColor + ';"><div class="tabulated"><div class="cell">' + initials + '</div></div></div>');
					}
				}
			});
			
		});
		
	}());
	
	/**
	* 
	**********************************************************************/
	(function () {
		
		
		
	}());
	
	/**
	* 
	**********************************************************************/
	(function () {
		
		
		
	}());
	
});