jQuery(document).ready(function ($) {

	'use strict';
	
	var bodyEl = $('body:eq(0)')
		, wpBody = bodyEl.find('#wpbody')
		;
	
	/**
	* Header style preview
	**********************************************************************/
	(function () {
		
		var mhs = wpBody.find('#theodore_header_style')
			, container = mhs.find('#mhs-container')
			, hideHeader = mhs.find('#theodore_hide_header')
			, preview = mhs.find('#theodore-header-preview')
			, coverEl = preview.find('.cover')
			, coverOpacity = mhs.find('#theodore_cover_opacity')
			, textColor = mhs.find('#theodore_text_color')
			, fullScreen = mhs.find('#theodore_full_screen')
			, backgroundRepeat = mhs.find('#theodore_background_repeat')
			, refresh = preview.find('.refresh')
			;
		
		
		
		var screenAuthorName = wpBody.find('#post_author_override')
			, setAuthorName = function () {
				if (screenAuthorName.length < 1) {
					return;
				}
				
				var name = '';
				
				screenAuthorName.find('option').each(function () {
					var el = $(this);
					
					if (el.attr('value') == screenAuthorName.val()) {
						name = el.text().replace(/ *\([^)]*\) */g, "");
						mhs.find('#theodore-author-name').text(name);
						return false;
					}
				});
				
			}
			;
			
		setAuthorName();
		
		screenAuthorName.on('change', function () {
			setAuthorName();
		});
		
		/* Set todays date as dummy */
		var today = new Date()
			, todaysDate = today.toString().substr(3, 12)
			, todaysTag = mhs.find('#theodore-todays-date').text(todaysDate.slice(0, 7) + ',' + todaysDate.slice(7))
			;
		
		
		/* check if header should be hidden. */
		var setHeaderVisibility = function () {
			if (hideHeader.is(':checked')) {
				container.addClass('hide');
			}
			else {
				container.removeClass('hide');
			}
		};
		setHeaderVisibility();
		hideHeader.on('change', function () {
			setHeaderVisibility();
		});
		
		/* Cover opacity */
		var setOpacity = function () {
			var bgColor = 'rgba(0, 0, 0, ' + coverOpacity.val() + ')';
				
			if (textColor.val() == 'dark') {
				bgColor = 'rgba(255, 255, 255, ' + coverOpacity.val() + ')';
			}
			coverEl.css({
				backgroundColor: bgColor
			});
		};
		setOpacity();
		coverOpacity.on('change', function () {
			setOpacity();
		});
		
		/* Background repeat */
		var setBGRepeat = function () {
			if (backgroundRepeat.val() == 'yes') {
				preview.css({
					backgroundSize: 'initial',
					backgroundRepeat: 'repeat'
				});
			}
			else {
				preview.css({
					backgroundSize: 'cover',
					backgroundRepeat: 'no-repeat'
				});
			}
		}
		setBGRepeat();
		backgroundRepeat.on('change', function () {
			setBGRepeat();
		});
		
		/* Text color */
		var setTextColor = function () {
			var bgColor = 'rgba(0, 0, 0, ' + coverOpacity.val() + ')'
				, color = 'white'
				;
				
			if (textColor.val() == 'dark') {
				bgColor = 'rgba(255, 255, 255, ' + coverOpacity.val() + ')';
				color = 'black'
			}
			coverEl.css({
				backgroundColor: bgColor
			});
			preview.css({
				color: color,
				backgroundColor: color == 'black' ? '#f9f9f9' : '#181818'
			});
		};
		setTextColor();
		textColor.on('change', function () {
			setTextColor();
		});
		
		/* Fetch image on refresh */
		var refreshPreview = function () {
			/* Set background image */
			var url = wpBody.find('#set-post-thumbnail img').attr('src');
			
			if (url) {
				preview.css({
					backgroundImage: 'url(' + url + ')'
				});
			}
			
			/* Set title */
			var title = wpBody.find('#poststuff input#title').val();
			preview.find('.title').text(title);
			
			var categories = wpBody.find('#categorydiv input[type="checkbox"]:checked').parent('label').text();
			
		};
		
		refreshPreview();
		refresh.on('click', function () {
			refreshPreview();
		});
		
		
	}());
	
	/**
	* Buttons with class 'uploader_button' is used to open 
	* the native media uploader. It should return the url of the selected 
	* item and put it to the target.
	**********************************************************************/
	(function () {
		
		if (window.theodorePluginExists) {
			return;
		}
		
		var mediaButton = wpBody.find('.uploader_button')
			;
		
		mediaButton.each(function () {
			var el = $(this)
				, clearText = el.data('clear-text')
				, target = el.data('target')
				;
			if (clearText) {
				el.after(' <button class="button clear-image">' + clearText + '</button>');
			}
			wpBody.find('input#' + target).attr('readonly', true)
		});
		
		wpBody.on('click', '.clear-image', function (e) {
			var el = $(this);
			el.siblings('input[type="url"]').val('').trigger('change');
			el.siblings('.image-preview').empty();
			e.preventDefault();
			e.stopPropagation();
			return false;
		});
		
		wpBody.on('click', '.uploader_button', function (e) {
			e.preventDefault();
			
			var button = $(this)
				, target = $(this).data('target')
				, preview = $(this).data('preview')
				, previewContainer = wpBody.find('#'+preview)
				;
			
			if (target == '') {
				return false;
			}			
			
			/*
			create a new Library, base on defaults
			you can put your attributes in
			*/
			var insertImage = wp.media.controller.Library.extend({
				defaults :  _.defaults({
						id: 'insert-image',
						title: 'Insert Image Url',
						allowLocalEdits: true,
						displaySettings: true,
						displayUserSettings: true,
						multiple : true,
						type : 'image' /* audio, video, application/pdf, ... etc */
				  }, wp.media.controller.Library.prototype.defaults)
			});
			
			
			/* Setup media frame */
			var frame = wp.media({
				button : { text : 'Select' },
				state : 'insert-image',
				states : [
					new insertImage()
				]
			});
			
			frame.on('select',function() {
				
				var state = frame.state('insert-image')
					, selection = state.get('selection')
					;
				
				if (!selection) {
					return;
				}
				var imgSrc = ''
					, attachmentIds = []
					;
				selection.each(function(attachment) {
					var display = state.display(attachment).toJSON()
						, obj_attachment = attachment.toJSON()
						;
					
					display = wp.media.string.props(display, obj_attachment);
					imgSrc = display['src'];
					
					/* What is being returned? */
					attachmentIds.push(attachment.id);
				});
				
				/* This button is meant to print the value to wp_editor. */
				if (button.is('.to_editor')) {
					tinyMCE.activeEditor.execCommand('mceInsertContent', false, attachmentIds.join(', '));
				}
				/* This button is meant to print the value to a text field and show the image. */
				else {
					if (target != '') {
						wpBody.find('#' + target).val(imgSrc).trigger('change');
					}
					if (previewContainer.length) {
						previewContainer.html('<img src="' + imgSrc + '" />');
					}
				}
				
			});

			/* reset selection in popup, when open the popup */
			frame.on('open',function() {
				var selection = frame.state('insert-image').get('selection');

				/* remove all the selection first */
				selection.each(function(image) {
					var attachment = wp.media.attachment( image.attributes.id );
					attachment.fetch();
					selection.remove(attachment ? [attachment] : []);
				});				
			});

			/* now open the popup */
			frame.open();
		});
		
	}());
	
	/**
	 * Ace editor for custom css in settings page
	 **********************************************************************/
	(function (global) {
		var customCss = wpBody.find('textarea[name="theodore_general_settings[custom_css]"]')
			, targetId = customCss.data('target')
			;
		
		if (!customCss.length || typeof ace == "undefined") {
			return false;
		}
		
		customCss.hide().after('<div id="' + targetId + '" class="widefat" style="height: 150px; width: 470px;"></div>');
		
		var editor = ace.edit(targetId)
			, session = editor.session
			;
		
		var value = customCss.val()
			, beautifulValue = cssbeautify(value, {
				indent: '\t',
				autosemicolon: true
			})
			;
		
		global.safecss_editor = editor;
		editor.getSession().setUseWrapMode( true );
		editor.setShowPrintMargin( false );
		editor.getSession().setValue(beautifulValue);
		editor.getSession().setMode( "ace/mode/css" );
		
		customCss.parents('form').on('submit', function () {
			customCss.val(editor.getSession().getValue());
		});
	}(this));
	
	/**
	* 
	**********************************************************************/
	(function () {		
		
		
		
	}());

});