<?php

global $theodore_portfolio_increment, $theodore_portfolio_column, $theodore_portfolio_height, $theodore_portfolio_item_bg_image_data;

/* TRANSLATORS: Portfolio label on the sidebar handle. Ex: Work / Title of the Portfolio (Front end) */
$article_label = esc_html__('Work', 'theodore');
$title = get_the_title();
$sidebar_handle_label = $article_label . ' / ' . $title;

/* Sidebar background color */
$sidebar_bg = get_post_meta( $post->ID, 'theodore_sidebar_background_color', true );

/* Text color */
$text_color = get_post_meta( $post->ID, 'theodore_text_color', true );
$text_color = $text_color != '' ? $text_color . '-text' : 'light-text';

switch( $theodore_portfolio_column ) {
	case 'one-col':
		$size = has_image_size( 'theodore-full-layout-width' ) ? 'theodore-full-layout-width' : 'post-thumbnail';
		break;
	case 'two-cols':
		$size = 'large';
		break;
	default:
		$size = 'medium_large';
		break;
}

$has_handler_data = $theodore_portfolio_column == '' ? ' has-handler-data ' : '';

$height_class = in_array( $theodore_portfolio_height, array( 'full', 'two-thirds', 'half', 'one-third' ) ) 
	? $theodore_portfolio_height . '-height'
	: ''
	;

?>
<section id="portfolio-item-<?php echo esc_attr( $theodore_portfolio_increment ); ?>" class="item <?php echo esc_attr( $height_class ); ?> <?php echo esc_attr( $text_color ); ?> <?php echo esc_attr( $has_handler_data ); ?>"
	data-label="<?php echo esc_attr( $sidebar_handle_label ); ?>"
	data-bg-color="<?php echo esc_attr( $sidebar_bg ); ?>"
	data-background-image="<?php echo esc_url( $theodore_portfolio_item_bg_image_data ); ?>"
	>
	<div class="wrapper">
		<a href="<?php echo esc_url( get_permalink() ); ?>">
			<div class="content">
				<img src="<?php echo esc_url( $theodore_portfolio_item_bg_image_data ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>"/>
				
				<h1><?php the_title(); ?></h1>
				
				<?php if ( has_excerpt() ) : ?>
					
					<div class="subtitle"><?php echo wpautop( esc_html( get_the_excerpt() ) ); ?></div>
					
				<?php endif; ?>
				
			</div>
		</a>
	</div>
	<a href="#portfolio-item-<?php echo ( int ) esc_attr( $theodore_portfolio_increment ) + 1; ?>" class="arrow tabulated"><span class="cell"><i class="fa fa-arrow-down"></i></span></a>
</section>