<?php

class TheodorePluginShortcode {
	
	private $blockLevelShortcodes;
	private $utils;
	
	public static $newRowID = 0;
	public static $newColumnID = 0;
	public static $newBigTextID = 0;
	public static $newSocialIconLinksID = 0;
	public static $newContentSliderItemID = 0;
	public static $newPostContentSliderID = 0;
	public static $newButtonID = 0;
	
	public function __construct () {
		
		$this->utils = new TheodorePluginUtils();
		
		$this->blockLevelShortcodes = array(
			'row',
			'column',
			'big_text',
			'blog_list',
			'vertical_separator',
			'portfolio',
			'testimonials',
			'testimonial_item',
			'gallery_slider',
			'content_slider',
			'content_slider_item',
			'fading_background_images',
			'fading_background_image_item',
			'social_icon_links'
		);
		
		add_shortcode( 'row', array( $this, 'shortcodeRow' ) );
		add_shortcode( 'column', array( $this, 'shortcodeColumn' ) );
		add_shortcode( 'big_text', array( $this, 'shortcodeBigText' ) );
		add_shortcode( 'button', array( $this, 'shortcodeButton' ) );
		add_shortcode( 'blog_list', array( $this, 'shortcodeBlogList' ) );
		add_shortcode( 'vertical_separator', array( $this, 'shortcodeVerticalSeparator' ) );
		add_shortcode( 'portfolio', array( $this, 'shortcodePortfolio' ) );
		add_shortcode( 'testimonials', array( $this, 'shortcodeTestimonials' ) );
		add_shortcode( 'testimonial_item', array( $this, 'shortcodeTestimonialItem' ) );
		add_shortcode( 'gallery_slider', array( $this, 'shortcodeGallerySlider' ) );
		add_shortcode( 'content_slider', array( $this, 'shortcodeContentSlider' ) );
		add_shortcode( 'content_slider_item', array( $this, 'shortcodeContentSliderItem' ) );
		add_shortcode( 'fading_background_images', array( $this, 'shortcodeFadingBackgroundImages' ) );
		add_shortcode( 'fading_background_image_item', array( $this, 'shortcodeFadingBackgroundImageItem' ) );
		add_shortcode( 'social_icon_links', array( $this, 'shortcodeSocialIconLinks' ) );
		
		add_shortcode( 'copyright_symbol', array( $this, 'shortcodeCopyrightSymbol' ) );
		add_shortcode( 'current_year', array( $this, 'shortcodeCurrentYear' ) );
		add_shortcode( 'middot', array( $this, 'shortcodeMiddot' ) );
		add_shortcode( 'link', array( $this, 'shortcodeLink' ) );
		add_shortcode( 'br', array( $this, 'shortcodeBr' ) );
		
		add_filter( 'the_content', array( $this, 'theContentFilter' ) );
		add_filter( 'widget_text', array( $this, 'theContentFilter' ) );
		
		add_action( 'media_buttons_context',  array( $this, 'mediaButtonsContext' ) );
	}
	
	/**
	 * Remove unwanted p tags on shortcodes which names is in $this->blockLevelShortcodes.
	 * Other shortcodes will not affected.
	 *
	 * @param string $content
	 */
	public function theContentFilter ( $content ) {
		
		if ( count( $this->blockLevelShortcodes ) === 0 ) {
			return $content;
		}
		
		$block = join( '|', $this->blockLevelShortcodes );
		
		/* opening tag */
		$rep = preg_replace( '/(<p>)?\[(' . $block . ')(\s[^\]]+)?\](<\/p>|<br \/>)?/', '[$2$3]', $content );
		
		/* closing tags */
		$rep = preg_replace( '/(<p>)?\[\/(' . $block . ')](<\/p>|<br \/>)?/', '[/$2]', $rep );
		
		return do_shortcode($rep);
	}
	
	/**
	 * Add a button next to default Wordpress add media 
	 */
	public function mediaButtonsContext () {
		
		/* TRANSLATORS: Text on the button to fetch media ID from the WordPress Media Management. 
		The button is laid next to the "Add Media" button above text editor. (Back end) */
		return '<span class="button uploader_button to_editor add_media"><span class="wp-media-buttons-icon"></span>' . esc_html__( 'Get Media ID', 'theodore' ) . '</span>';
	}
	
	private function getVideoBackground ( $video_sources, $background_video_muted = '' ) {
		
		$i = 0;
		$muted = trim( strtolower( $background_video_muted ) ) == 'yes' ? 'muted' : '';
		$video_background = '<div class="video-background"><video ' . esc_attr( $muted ) . ' loop>';
		foreach ( $video_sources as $k => $v ) {
			if ( trim( $v ) == '' ) {
				continue;
			}
			
			if ( esc_url( wp_get_attachment_url( ( int ) $v ) ) != '' ) {
				$video_background.= '<source src="' . esc_url( wp_get_attachment_url( ( int ) $v ) ) . '" type="video/' . esc_attr( $k ) . '">';
				$i++;
			}
		}
		$video_background.= '</video></div>';
		
		return $i > 0 ? $video_background : '';
		
	}
	
	private function getFadingImages ( $background_image_id, $grid ) {
		
		$bg_ids = explode( ',', $background_image_id );
		
		/* 	If $background_image_id is more than 1, then it's a fading 
			background with multiple images. */
		$fading_images = '';
		if ( count( $bg_ids ) > 1 ) {
			
			$size = 'medium_large';
			if ( ( int ) $grid > 5 && ( int ) $grid < 9 ) {
				$size = 'large';
			}
			if ( ( int ) $grid > 8 ) {
				$size =  has_image_size( 'theodore-full-layout-width' ) ? 'theodore-full-layout-width' : 'post-thumbnail';
			}
			
			$legit_ids = array();
			$fading_images = '<div class="module-fading-images">';
			foreach ( $bg_ids as $bg_id ) {
				if ( ( int ) $bg_id > 0 ) {
					$image_info = wp_get_attachment_image_src( $bg_id, $size );
					if ( isset( $image_info[0] ) ) {
						$fading_images.= '<div class="item" data-src="' . esc_url( $image_info[0] ) . '"></div>';
						$legit_ids[] = $bg_id;
					}
				}
			}
			$fading_images.= '</div>';
			if ( count( $legit_ids ) < 2 && isset( $legit_ids[0] ) ) {
				$bg_ids = array( $bg_ids[0] );
				$fading_images = '';
			}
		}
		
		return $fading_images;
		
	}
	
	private function getBackgroundImageData ( $background_image_id, $background_image_url, $grid ) {
		
		$bg_ids = explode( ',', $background_image_id );
		
		$background_data = '';
		if ( count( $bg_ids ) < 2 ) {
			$bg_id = isset( $bg_ids[0] ) ? ( int ) $bg_ids[0] : 0;
			if ( ( int ) $bg_id > 0 ) {
				
				$size = 'medium_large';
				if ( ( int ) $grid > 5 && ( int ) $grid < 9 ) {
					$size = 'large';
				}
				if ( ( int ) $grid > 8 ) {
					$size =  has_image_size( 'theodore-full-layout-width' ) ? 'theodore-full-layout-width' : 'post-thumbnail';
				}
				
				$image_info = wp_get_attachment_image_src( $bg_id, $size );
				
				if ( isset( $image_info[0] ) ) {
					$background_data = esc_url( $image_info[0] );
				}
				
			}
		}
		
		/* 	User can use image from remote URL, but only when there's no 
			reference to local image. */
		if ( $background_data == '' && esc_url( $background_image_url ) != '' ) {
			$background_data = esc_url( $background_image_url );
		}
		
		return $background_data;
		
	}
	
	/**
	 * Shortcode for [row]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeRow ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'id' => '',
			'height' => '',
			'sidebar_text' => '',
			'background_image_id' => '',
			'background_image_url' => '',
			'sidebar_bg_color' => '',
			'background_video_mp4' => '',
			'background_video_webm' => '',
			'background_video_ogg' => '',
			'background_video_muted' => ''
		), $atts ) );
		
		$classes = array();
		$classes['height'] = in_array( $height, array( 'quarter', 'half', 'two-thirds', 'full' ) ) ? $height . '-height' : '';
		$classes['handler'] = ( trim( $sidebar_text ) != '' || trim( $sidebar_bg_color ) != '' ) ? 'has-handler-data' : '';
		
		$sidebar_data_label = trim( $sidebar_text ) != '' ? $sidebar_text : '';
		$sidebar_data_bg_color = trim( $sidebar_bg_color ) != '' ? $sidebar_bg_color : '';
		
		/* Video Background */
		$video_sources = array();
		$video_sources['mp4'] = trim( $background_video_mp4 ) != '' ? trim( $background_video_mp4 ) : '';
		$video_sources['webm'] = trim( $background_video_webm ) != '' ? trim( $background_video_webm ) : '';
		$video_sources['ogg'] = trim( $background_video_ogg ) != '' ? trim( $background_video_ogg ) : '';
		
		$video_background = $this->getVideoBackground( $video_sources, $background_video_muted );
		$fading_images = $this->getFadingImages( $background_image_id, 12 );
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$element_id = $id != '' ? str_replace( ' ', '', $id ) : 'custom-row-' . self::$newRowID++;
		$background_image_data = $this->getBackgroundImageData( $background_image_id, $background_image_url, 12 );
		
		return '<div class="row-container"><div id="' . esc_attr( $element_id ) . '" class="row custom-row ' . esc_attr( $class_names ) . '" data-label="' . esc_attr( $sidebar_data_label ) . '" data-bg-color="' . esc_attr( $sidebar_data_bg_color ) . '" data-background-image="' . esc_url( $background_image_data ) . '">' . $fading_images . do_shortcode( $content ) . $video_background . '</div></div>';
		
	}
	
	/**
	 * Shortcode for [column]
	 * 
	 * Attributes:
	 * - ''
	 *
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeColumn ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'id' => '',
			'grid' => '',
			'vertical_align' => '',
			'text_align' => '',
			'horizontal_attachment' => '',
			'background_image_id' => '',
			'background_image_url' => '',
			
			'top_padding' => '',
			'bottom_padding' => '',
			'left_padding' => '',
			'right_padding' => '',
			
			'top_padding_on_mobile' => '',
			'bottom_padding_on_mobile' => '',
			'remove_on_mobile' => '',
			
			'background_video_mp4' => '',
			'background_video_webm' => '',
			'background_video_ogg' => '',
			'background_video_muted' => ''
		), $atts ) );
		
		$grid = $grid == '' ? 12 : ( int ) $grid;
		
		$classes = array();
		$classes['grid'] = $grid <= 12 && $grid >= 1 ? 'grid-' . $grid : 'grid-12';
		$classes['vertical_align'] = in_array( $vertical_align, array( 'top', 'middle', 'bottom' ) ) ? 'valign-' . $vertical_align : 'valign-top';
		$classes['text_align'] = in_array( $text_align, array( 'left', 'center', 'right', 'justify' ) ) ? 'align-' . $text_align : '';
		$classes['horizontal_attachment'] = in_array( $horizontal_attachment, array( 'left', 'right' ) ) ? 'attach-' . $horizontal_attachment : '';
		
		$classes['top_padding'] = in_array( $top_padding, array( 'thin', 'thick', 'no' ) ) ? $top_padding . '-top-padding' : '';
		$classes['bottom_padding'] = in_array( $bottom_padding, array( 'thin', 'thick', 'no' ) ) ? $bottom_padding . '-bottom-padding' : '';
		$classes['left_padding'] = in_array( $left_padding, array( 'thin', 'thick', 'no' ) ) ? $left_padding . '-left-padding' : '';
		$classes['right_padding'] = in_array( $right_padding, array( 'thin', 'thick', 'no' ) ) ? $right_padding . '-right-padding' : '';
		
		$classes['top_padding_on_mobile'] = $top_padding_on_mobile == 'no' ? 'no-top-padding-on-mobile' : '';
		$classes['bottom_padding_on_mobile'] = $bottom_padding_on_mobile == 'no' ? 'no-bottom-padding-on-mobile' : '';
		$classes['remove_on_mobile'] = $remove_on_mobile == 'yes' ? 'remove-on-mobile' : '';
		
		/* Video Background */
		$video_sources = array();
		$video_sources['mp4'] = trim( $background_video_mp4 ) != '' ? trim( $background_video_mp4 ) : '';
		$video_sources['webm'] = trim( $background_video_webm ) != '' ? trim( $background_video_webm ) : '';
		$video_sources['ogg'] = trim( $background_video_ogg ) != '' ? trim( $background_video_ogg ) : '';
		
		$video_background = $this->getVideoBackground( $video_sources, $background_video_muted );
		$fading_images = $this->getFadingImages( $background_image_id, $grid );
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$element_id = $id != '' ? str_replace( ' ', '', $id ) : 'custom-column-' . self::$newColumnID++;
		$background_image_data = $this->getBackgroundImageData( $background_image_id, $background_image_url, $grid );
		
		return '<div id="' . esc_attr( $element_id ) . '" class="column custom-column ' . esc_attr( $class_names ) . '" data-background-image="' . esc_url( $background_image_data ) . '">' . $fading_images . do_shortcode( $content ) . $video_background . '</div>';
		
	}
	
	/**
	 * Shortcode for [big_text]
	 * 
	 * Attributes:
	 * - ''
	 *
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeBigText ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'id' => '',
			'width' => '',
			'size' => '',
			'margin' => ''
		), $atts ) );
		
		$classes = array();
		$classes['width'] = in_array( $width, array( 'full', 'large' ) ) ? $width . '-width' : '';
		$classes['size'] = in_array( $size, array( '2', '3', '4' ) ) ? 'size-' . $size : '';
		$classes['margin'] = trim( $margin ) == 'no' ? 'no-margin' : '';
		
		$element_id = $id != '' ? str_replace( ' ', '', $id ) : 'module-big-text-' . self::$newBigTextID++;
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		return '<div id="' . esc_attr( $element_id ) . '" class="module-big-text ' . esc_attr( $class_names ) . '">' . do_shortcode( wpautop( $content ) ) . '</div>';
		
	}
	
	/**
	 * Shortcode for [button]
	 * 
	 * Attributes:
	 * - ''
	 *
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeButton ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'url' => '',
			'text' => '',
			'theme' => '',
			'opaque' => ''
		), $atts ) );
		
		$text = $text != '' ? $text : esc_url( $url );
		
		if ( $text == '' ) {
			return '';
		}
		
		$classes = array();
		$classes['theme'] = in_array( $theme, array( 'dark', 'light' ) ) ? $theme : 'dark';
		$classes['opaque'] = $opaque == 'yes' ? 'opaque' : '';
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$element_id = 'module-button-' . self::$newButtonID++;
		
		return '<a id="' . esc_attr( $element_id ) . '" href="' . esc_url( $url ) . '" class="module-button ' . esc_attr( $class_names ) . '"><span class="animate-underline">' . esc_html( $text ) . '</span></a>';
		
	}
	
	/**
	 * Shortcode for [vertical_separator]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeVerticalSeparator ($atts, $content = null) {
		extract(shortcode_atts( array(
			'gap_size' => '',
			'width' => '',
			'thickness' => '',
			'border_color' => ''
		), $atts));
		
		$classes = array();
		$classes['gap_size'] = in_array( $gap_size, array( '2', '3' ) ) ? 'gap-size-' . $gap_size : '';
		$classes['width'] = in_array( $width, array( 'full', 'wide' ) ) ? $width : '';
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$border_width = ( int ) $thickness > 0 ? ( int ) $thickness : 1;
		$style = 'style="border-top-width:' . $border_width . 'px; border-top-color: ' . $border_color . ';"';
		
		return '<div ' . $style . ' class="module-vertical-separator ' . $class_names . '"></div>';
		
	}
	
	/**
	 * Shortcode for [blog_list]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeBlogList ($atts, $content = null) {
		extract(shortcode_atts( array(
			'columns' => '3',
			'limit' => '',
			'pagination' => 'no'
		), $atts));
		
		switch ( esc_html( $columns ) ) {
			case '2':
				$cols = ' two-cols ';
				break;
			case '4':
				$cols = ' four-cols ';
				break;
			default:
				$cols = ' three-cols ';
				break;
		}
		
		$limit = ( int ) $limit < 1 ? 0 : ( int ) $limit;
		
		$html = '';
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		
		$the_query = new WP_Query( array (
			'post_type' => 'post',
			'posts_per_page' => $limit,
			'paged' => $paged
		) );
		
		if ( $the_query->have_posts() ) {
			$current_theme = wp_get_theme();
			$container_tag = strtolower( $current_theme ) == 'theodore' ? 'div' : 'ul';
			
			$html.= '<' . $container_tag . ' class="blog-list ' . $cols  . ' clearfix">';
			
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				if ( strtolower( $current_theme ) == 'theodore' ) {
					$html.= $this->utils->loadTemplatePart( 'templates/part', 'blog-grid-item' );
				}
				else {
					$html.='<li><a href="' . esc_url( get_the_permalink() ) . '">' . esc_html( get_the_title() ) . '</a></li>';
				}
			}
			
			$html.= '</' . $container_tag . '>';
			
			if ($the_query->max_num_pages > 1 && strtolower( $pagination ) == 'yes' ) {
				/* TRANSLATORS: Pagination text for the previous page. (Back end) */
				$html.= '<div class="pagination align-center">' . get_previous_posts_link( esc_html__( 'Previous', 'theodore' ) ) 
				/* TRANSLATORS: Pagination text for the previous page. (Back end) */
				. get_next_posts_link( esc_html__( 'Next', 'theodore' ), $the_query->max_num_pages ) . '</div>';
			}
			
			wp_reset_postdata();
			
		}
		
		return $html;
		
	}
	
	/**
	 * Shortcode for [shortcode]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodePortfolio ( $atts, $content = null ) {
		
		global $theodore_portfolio_increment, $theodore_portfolio_column, $theodore_portfolio_height, $theodore_portfolio_item_bg_image_data;
		
		extract( shortcode_atts( array(
			'columns' => '',
			'limit' => 0,
			'height' => '',
			'hide_text_first' => 'no'
		), $atts ) );
		
		$classes = array();
		
		switch ( ( int ) $columns ) {
			case '2':
				$column = ' two-cols ';
				break;
			case '3':
				$column = ' three-cols ';
				break;
			case '4':
				$column = ' four-cols ';
				break;
			default:
				$column = '';
				break;
		}
		
		$theodore_portfolio_column = $column;
		$theodore_portfolio_height = $height;
		
		$classes['column'] = $column;
		$classes['rectangular'] = trim( $column ) != '' ? 'rectangular' : '';
		$classes['hide_text_first'] = trim( $hide_text_first ) == 'yes' ? 'hide-text-first' : '';
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$portfolio = new WP_Query( array(
			'post_type' => 'theodore_portfolio',
			'posts_per_page' => -1,
			'update_post_term_cache' => false, 
			'update_post_meta_cache' => false, 
			'nopaging' => true
		) );
		$html = '';
		if ($portfolio->have_posts()) {
			
			$i = 1;
			
			$html.= '<div class="module-portfolio clearfix ' . $class_names . '">';
			
			while ( $portfolio->have_posts() ) {
				
				if ( $limit > 0 && $i > $limit ) {
					break;
				}
				
				$portfolio->the_post();
				
				switch( ( int ) $columns ) {
					case '3':
					case '4':
						$size = 'medium_large';
						break;
					case '2':
						$size = 'large';
						break;
					default:
						$size = 'post-thumbnail';
						break;
				}
				
				$featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $size );
				$featured_image_url = isset( $featured_image_url[0] ) ? $featured_image_url[0] : '';
				$theodore_portfolio_item_bg_image_data = $featured_image_url;
				
				$theodore_portfolio_increment = $i;
				
				$html.= $this->utils->loadPluginTemplatePart( 'part-portfolio-item' );
				
				$i++;
				
			}
			
			$html.= '</div>';
			
			wp_reset_postdata();
			
		}
		
		return $html;
	}
	
	/**
	 * Shortcode for [testimonials] which is the parent of [testimonial_item]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeTestimonials ($atts, $content = null) {
		extract(shortcode_atts( array(
			
		), $atts));
		
		return '<div class="module-slider module-testimonials">' . do_shortcode( $content ) . '</div>';
		
	}
	
	/**
	 * Shortcode for [testimonial_item]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeTestimonialItem ($atts, $content = null) {
		extract(shortcode_atts( array(
			'name' => '',
			'link_url' => '',
			'link_text' => '',
			'avatar_image_id' => ''
		), $atts));
		
		$avatar_image_id = explode( ',', $avatar_image_id );
		$avatar_image_id = isset( $avatar_image_id[0] ) ? ( int ) $avatar_image_id[0] : 0;
		
		$avatar_container = '';
		if ( ( int ) $avatar_image_id > 0 ) {
			
			$image_info = wp_get_attachment_image_src( $avatar_image_id, 'medium' );
			
			if ( isset( $image_info[0] ) ) {
				$avatar_container = '<div class="avatar-container"><img src="' . esc_url( $image_info[0] ) . '" alt=""/></div>';
			}
			
		}
		
		return '<div class="item">
					<div class="tabulated">
						<div class="cell">
							<div class="comment">
								' . do_shortcode( wpautop( $content ) ) . '
							</div>
							' . $avatar_container . '
							<div class="author"><span class="name">' . esc_html( $name ) . '</span>
							<a href="' . esc_url( $link_url ) . '">' . esc_html( $link_text ) . '</a></div>
						</div>
					</div>
				</div>';
		
	}
	
	/**
	 * Shortcode for [gallery_slider]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeGallerySlider ($atts, $content = null) {
		extract(shortcode_atts( array(
			
		), $atts));
		
		return '<div class="module-gallery-slider">' . $content  . '</div><!-- End of .module-gallery-slider -->';
		
	}
	
	/**
	 * Shortcode for [content_slider]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeContentSlider ($atts, $content = null) {
		extract(shortcode_atts( array(
			'get_from_posts' => '',
			'limit' => '',
			'height' => ''
		), $atts));
		
		if ( $get_from_posts == 'yes' ) {
			$html = $this->getPostsForSlider( $limit, $height );
		}
		else {
			$height = in_array( $height, array( 'half', 'full', 'two-thirds' ) ) ? $height . '-height' : 'two-thirds-height';
			$html = '<div class="module-slider ' . esc_attr( $height ) . ' content-slider auto-slide">' . do_shortcode( $content ) . '</div>';
		}
		
		return $html;
		
	}
	
	private function getPostsForSlider ( $limit, $height ) {
		
		$limit = ( int ) $limit < 1 ? 3 : ( int ) $limit;
		
		$height = in_array( $height, array( 'full', 'half', 'two-thirds' ) ) ? $height . '-height' : 'two-thirds-height';
		
		$html = '';
		
		$the_query = new WP_Query( array (
			'post_type' => 'post',
			'posts_per_page' => $limit
		) );
		
		if ( $the_query->have_posts() ) {
			
			$html.= '<div class="module-slider ' . esc_attr( $height ) . ' content-slider auto-slide">';
			
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				
				/* TRANSLATORS: Article label on the sidebar handle. Ex: Article / Title of the Post (Front end) */
				$article_label = esc_html__('Article', 'theodore');
				$title = get_the_title();
				$sidebar_handle_label = $article_label . ' / ' . $title;
				
				/* Sidebar background color: 963F0B */
				$sidebar_bg = get_post_meta( get_the_ID(), 'theodore_sidebar_background_color', true );
				$sidebar_bg = $sidebar_bg == '' ? '#f9f9f9' : $sidebar_bg;
				
				/* Cover opacity from meta boxes */
				$cover_opacity = get_post_meta( get_the_ID(), 'theodore_cover_opacity', true );
				$opacity_class = '';
				if ( '' !== $cover_opacity ) {
					$opacity_class = ' opacity-' . str_replace( '.', '-', $cover_opacity ) . ' ';
				}

				/* Background repeat from meta boxes */
				$background_repeat = get_post_meta( get_the_ID(), 'theodore_background_repeat', true );
				$background_repeat = 'yes' == $background_repeat ? ' background-repeat ' : '';
				
				/* Excerpt */
				$the_excerpt = '<div class="module-vertical-slider"></div>';
				if ( has_excerpt() ) {
					$the_excerpt = '<div class="subtitle">' . wpautop( esc_html( get_the_excerpt() ) ) . '</div>';
				}
				
				/* Text color from meta boxes */
				$text_color_class = ' dark-text ';
				$button_color_class = ' dark ';
				if ( 'light' == get_post_meta( get_the_ID(), 'theodore_text_color', true ) ) {
					$text_color_class = ' light-text ';
					$button_color_class = ' light ';
				}
				
				/* TRANSLATORS: The 'Read more' link text for a post. (Front end) */
				$read_more_text = esc_html__( 'Read more', 'theodore' );
				
				$featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'post-thumbnail' );
				$featured_image_url = isset( $featured_image_url[0] ) ? $featured_image_url[0] : '';
				
				$element_id = 'content-slider-item-' . get_the_ID();
				
				$html.= '<div id="' . $element_id . '" class="item has-handler-data ' . $text_color_class . $background_repeat . $opacity_class . '"
							data-label="' . esc_attr( $sidebar_handle_label ) . '"
							data-bg-color="' . esc_attr( $sidebar_bg ) . '"
							data-background-image="' . esc_url( $featured_image_url ) . '"
							>
							<div class="tabulated">
								<div class="cell">
									<h1>' . esc_html( get_the_title() ) . '</h1>
									' . $the_excerpt . '
									<p><a href="' . esc_url( get_the_permalink() ) . '" class="module-button ' . $button_color_class . '"><span class="animate-underline">' . $read_more_text . '</span></a></p>
								</div>
							</div>
						</div>
					';
			}
			
			$html.= '</div>';
			
			wp_reset_postdata();
			
		}
		
		return $html;
		
	}
	
	/**
	 * Shortcode for [content_slider_item]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeContentSliderItem ($atts, $content = null) {
		
		extract(shortcode_atts( array(
			'title' => '',
			'description' => '',
			'link_url' => '',
			'link_text' => '',
			'text_color' => '',
			'cover_opacity' => '',
			'background_image_id' => '',
			'sidebar_bg_color' => ''
		), $atts));
		
		$classes = array();
		$classes['text_color'] = in_array( $text_color, array( 'light', 'dark' ) ) ? $text_color . '-text' : 'light-text';
		$classes['button_color'] = in_array( $text_color, array( 'light', 'dark' ) ) ? $text_color : 'light';
		$classes['cover_opacity'] = 'opacity-' . str_replace( '.', '-', floatval( $cover_opacity ) );
		
		$class_names = '';
		foreach ( $classes as $class_name ) {
			if ( trim( $class_name ) == '' ) {
				continue;
			}
			$class_names.= ' ' . esc_attr( $class_name ) . ' ';
		}
		
		$description = trim( $description != '' ) ? '<div class="subtitle">' . wpautop( esc_html( $description ) ) . '</div>' : '';
		$link = esc_url( $link_url ) != '' && esc_html( $link_text ) != '' 
			? '<p><a href="' . esc_url( $link_url ) . '" class="module-button ' . esc_attr( $classes['button_color'] ) . '"><span class="animate-underline">' . esc_html( $link_text ) . '</span></a></p>'
			: ''
			;
		
		/* Background image */
		$background_image_id = explode( ',', $background_image_id );
		$background_image_id = isset( $background_image_id[0] ) ? ( int ) $background_image_id[0] : 0;
		$background_image_data = '';
		if ( ( int ) $background_image_id > 0 ) {
			$image_info = wp_get_attachment_image_src( $background_image_id, 'post-thumbnail' );
			$background_image_data = isset( $image_info[0] ) ? $image_info[0] : '';
		}
		
		/* [end] Background image */
		
		$element_id = 'content-slider-item-' . self::$newContentSliderItemID++;
		
		$html = '<div id="' . esc_attr( $element_id ) . '" class="item has-handler-data ' . $class_names . '"
							data-label="' . esc_attr( $title ) . '"
							data-bg-color="' . esc_attr( $sidebar_bg_color ) . '"
							data-background-image="' . esc_url( $background_image_data ) . '"
							>
							<div class="tabulated">
								<div class="cell">
									<h1>' . esc_html( $title ) . '</h1>
									' . $description . '
									' . $link . '
								</div>
							</div>
						</div>
					';
		
		return $html;
	}
	
	/**
	 * Shortcode for [fading_background_images]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeFadingBackgroundImages ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			
		), $atts ) );
		
		return '<div class="module-fading-images">' . do_shortcode( $content ) . '</div>';
		
	}
	
	/**
	 * Shortcode for [fading_background_image_item]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeFadingBackgroundImageItem ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'sidebar_text' => '',
			'sidebar_bg_color' => '',
			'background_image_id' => ''
		), $atts ) );
		
		$bg_ids = explode( ',', $background_image_id );
		$bg_id = isset( $bg_ids[0] ) ? ( int ) $bg_ids[0] : false;
		
		if ( ! $bg_id ) {
			return;
		}
		
		$image_info = wp_get_attachment_image_src( $bg_id, 'post-thumbnail' );
		
		if ( ! isset( $image_info[0] ) || esc_url( $image_info[0] ) == '' ) {
			return;
		}
		
		$default_image = $image_info[0];
		$retina_image = '';
		
		$sidebar_data_label = trim( $sidebar_text ) != '' ? $sidebar_text : '';
		$sidebar_data_bg_color = trim( $sidebar_bg_color ) != '' ? $sidebar_bg_color : '';
		
		
		$exploded_url = explode( '.' , $default_image );
		if ( isset( $exploded_url[count( $exploded_url ) - 2] ) ) {
			$exploded_url[count( $exploded_url ) - 2] = $exploded_url[count( $exploded_url ) - 2] . '@2x';
			$retina_url = implode( '.', $exploded_url );
		}
		
		return '<div class="item" data-src="' . esc_url( $default_image ) . '" data-src-retina="' . esc_url( $retina_image ) . '" data-label="' . esc_attr( $sidebar_data_label ) . '" data-bg-color="' . esc_attr( $sidebar_data_bg_color ) . '"></div>';
		
	}
	
	/**
	 * Shortcode for [social_icon_links]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeSocialIconLinks ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'size' => '',
			'twitter' => '',
			'instagram' => '',
			'facebook' => '',
			'google_plus' => '',
			'dribbble' => '',
			'github' => '',
			'linkedin' => ''
		), $atts ) );
		
		$links = array();
		$links['twitter'] = esc_url( $twitter ) != '' ? esc_url( $twitter ) : '';
		$links['instagram'] = esc_url( $instagram ) != '' ? esc_url( $instagram ) : '';
		$links['facebook'] = esc_url( $facebook ) != '' ? esc_url( $facebook ) : '';
		$links['google_plus'] = esc_url( $google_plus ) != '' ? esc_url( $google_plus ) : '';
		$links['dribbble'] = esc_url( $dribbble ) != '' ? esc_url( $dribbble ) : '';
		$links['github'] = esc_url( $github ) != '' ? esc_url( $github ) : '';
		$links['linkedin'] = esc_url( $linkedin ) != '' ? esc_url( $linkedin ) : '';
		
		$size_class = '';
		switch ( $size ) {
			case '2':
				$size_class = 'size-2';
				break;
			case '3':
				$size_class = 'size-3';
				break;
		}
		
		$joined_links = '';
		foreach ( $links as $k => $v ) {
			if ( esc_url( $v ) != '' ) {
				$icon = str_replace( '_', '-', $k );
				$joined_links.= '<a href="' . esc_url( $v ) . '"><i class="fa fa-' . esc_attr( $icon ) . '"></i></a>';
			}
		}
		
		$element_id = 'social-icon-links-' . self::$newSocialIconLinksID++;
		
		return '<div id="' . esc_attr( $element_id ) . '" class="module-social-links ' . $size_class . '">' . $joined_links . '</div>';
		
	}
	
	/**
	 * Shortcode for [copyright_symbol]
	 *
	 * Mainly used in footer
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeCopyrightSymbol ($atts, $content = null) {
		return '&copy;';
	}
	
	/**
	 * Shortcode for [current_year]
	 *
	 * Mainly used in footer
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeCurrentYear ($atts, $content = null) {
		return date( 'Y' );
	}
	
	/**
	 * Shortcode for [middot]
	 *
	 * Mainly used in footer
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeMiddot ($atts, $content = null) {
		return '&nbsp;&middot;&nbsp;';
	}
	
	/**
	 * Shortcode for [link]
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeLink ( $atts, $content = null ) {
		
		extract( shortcode_atts( array(
			'url' => '',
			'text' => ''
		), $atts ) );
		
		return '<a href="' . esc_url( $url ) . '">' . esc_html( $text ) . '</a>';
		
	}
	
	/**
	 * Shortcode for [br]
	 *
	 * Mainly used in footer
	 * 
	 * @param mixed[] $atts Array of the shortcode attributes
	 * @param string $content
	 */
	public function shortcodeBr ($atts, $content = null) {
		return '<br/>';
	}
}

?>