<?php

/**
 * Portfolio Post Type
 *
 * This class register the Portfolio post type. This type of posts
 * can be shown on the front end using 'portfolio' shortcode.
 */

class TheodorePluginPortfolio {
	
	private $typeName = 'theodore_portfolio';
	
	/* Register post type and its taxonomy on object creation */
	public function __construct () {
		
		$portfolio_settings = get_option( 'theodore_portfolio_settings' );
		$this->slug = isset( $portfolio_settings['portfolio_slug'] ) ? esc_attr( $portfolio_settings['portfolio_slug'] ) : '';
		
		if ( $this->slug == '' ) {
			$this->slug = 'portfolio';
		}
		
		add_action( 'init', array( $this, 'init' ) );
	}
	
	public function init () {
		$this->registerPostType();
	}
	
	public function adminInit () {
		$this->settingsAPI->setSections( $this->getSettingsSections() );
        $this->settingsAPI->setFields( $this->getSettingsFields() );

        /* initialize settings */
        $this->settingsAPI->adminInit();
	}
	
	/* Register the post type */
	public function registerPostType () {
		
		$settings = get_option( 'theodore_general_settings' );
		$slug = isset( $settings['portfolio_slug'] ) && trim( $settings['portfolio_slug'] ) != '' ? sanitize_title( $settings['portfolio_slug'], 'portfolio' ) : 'portfolio';
		
		$args = array(
			'labels' => array(
				/* TRANSLATORS: Name for portfolio custom type. (Back end) */
				'name' => esc_html__( 'Portfolio', 'theodore' ),
				/* TRANSLATORS: Label for the "All Portfolios" text in the portfolio post type. (Back end) */
				'all_items' => esc_html__( 'All Portfolios', 'theodore' ),
				'singular_name' => esc_html__( 'Portfolio', 'theodore' ),
				/* TRANSLATORS: Label for "Add new portfolio" link. (Back end) */
				'add_new' => esc_html__( 'Add new portfolio', 'theodore' ),
				'add_new_item' => esc_html__( 'Add new portfolio', 'theodore' ),
				/* TRANSLATORS: Label for searching portfolios. (Back end) */
				'search_items' => esc_html__( 'Search Portfolios', 'theodore' ),
				/* TRANSLATORS: Label for viewing a portfolio. (Back end) */
				'view_item' => esc_html__( 'View Portfolio', 'theodore' ),
				/* TRANSLATORS: Label shown when searching portfolio returns no result. (Back end) */
				'not_found' => esc_html__( 'No Portfolio found', 'theodore' ),
				/* TRANSLATORS: Label shown when searching portfolio in trash returns no result. (Back end) */
				'not_found_in_trash' => esc_html__( 'No portfolio found in trash', 'theodore' )
			),
			'query_var' => $this->typeName,
			'rewrite' => array(
				'slug' => $slug
			),
			'public' => true,
			'has_archive' => false,
			'supports' => array(
				'title',
				'thumbnail',
				'editor',
				'excerpt',
				'comments'
			),
			'show_in_nav_menus' => false
		);
		
		register_post_type( $this->typeName, $args );
		
	}
	
}

?>