<?php

class TheodorePluginInit {
	
	
	public function __construct () {
		
		if ( ! is_admin() ) {
			$this->getCSS();
		}
		
		if ( is_admin() ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
		}
		else {
			add_action( 'wp_enqueue_scripts', array( $this, 'wpEnqueueScripts' ) );
		}
		
		add_action( 'plugins_loaded', array( $this, 'pluginsLoaded' ) );
		
	}
	
	public function adminEnqueueScripts () {
		wp_enqueue_script( 'theodore-plugin-admin', THEODORE_PLUGIN_URL . 'assets/js/admin.js', array( 'jquery' ) );
	}
	
	public function wpEnqueueScripts () {
		
		wp_enqueue_style( 'font-awesome', THEODORE_PLUGIN_URL . '/assets/css/font-awesome.min.css' );
		wp_enqueue_style( 'theodore-plugin-style', THEODORE_PLUGIN_URL . 'assets/css/main.css' );
		
		wp_enqueue_script( 'jquery-imagesloaded', THEODORE_PLUGIN_URL . 'assets/js/vendor/imagesloaded.pkgd.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-touchswipe', THEODORE_PLUGIN_URL . 'assets/js/vendor/jquery.touchSwipe.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-masonry', THEODORE_PLUGIN_URL . 'assets/js/vendor/masonry.pkgd.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'theodore-plugin-main', THEODORE_PLUGIN_URL . 'assets/js/main.js', array( 'jquery' ), false, true );
	
		if ( is_single() || is_page() ) {
			
			global $post;
			$id = $post->ID;
			wp_enqueue_style( 'theodore-shortcode-style', esc_url( home_url( '/' ) ) . '?theodore_get_file=shortcode_style&amp;id=' . $id );
			
		}
	}
	
	public function pluginsLoaded () {
		load_plugin_textdomain( 'theodore', false, plugin_basename( THEODORE_PLUGIN_DIR ) . '/languages' );
	}
	
	public function getCSS () {
		if ( isset( $_GET['theodore_get_file'] ) && $_GET['theodore_get_file'] == 'shortcode_style' ) {
			header('Content-Type: text/css');
			echo get_post_meta( $_GET['id'], 'theodore_shortcode_style', true );
			die();
		}
	}
	
}

?>