jQuery(function($) {
	
	'use strict';
	
	/**
	 * jQuery Tiny Pub/Sub
	 * https://github.com/cowboy/jquery-tiny-pubsub
	 *
	 * Copyright (c) 2013 "Cowboy" Ben Alman
	 * Licensed under the MIT license.
	 **********************************************************************/
	var o = $({});
	$.subscribe = function() {o.on.apply(o, arguments);};
	$.unsubscribe = function() {o.off.apply(o, arguments);};
	$.publish = function() {o.trigger.apply(o, arguments);};
	
	/**
	 * Save the main building block of DOM elements; for the 
	 * sake of succinctness
	 **********************************************************************/
	var DOM = (function (dom) {
		
		var dom = dom || {};
		
		dom.html = $('html:eq(0)');
		dom.body = $('body:eq(0)');
		dom.header = dom.body.find('header');
		dom.main = dom.body.find('main');
		dom.footer = dom.body.find('footer');
		dom.winHeight = $(window).height();
		dom.winWidth = $(window).width();
		dom.isMobile = $(window).width() < 768 ? true : false;
		dom.isSmallScreen = $(window).width() < 480 ? true : false;
		
		return dom;
		
	}(DOM));
	
	/**
	* Deal with elements that have data-background-image attribute
	**********************************************************************/
	(function () {
		
		DOM.body.find('[data-background-image!=""][data-background-image]').each(function () {
			var el = $(this)
				, originalURL = el.data('background-image')
				;
			
			if (window.devicePixelRatio < 1.5 || DOM.isSmallScreen || DOM.html.is('.lt-ie10')) {
				el.css({
					backgroundImage: 'url(\'' + originalURL + '\')'
				});
			}
			else {
				
				var arr = originalURL.split('.')
					, retinaURL
					;
				
				if (arr.length < 2) {
					return true;
				}
				
				arr[arr.length - 2] = arr[arr.length - 2] + '@2x';
				retinaURL = arr.join('.');
				
				$.ajax({
					url: retinaURL,
					type: 'HEAD',
					error: function () {
						el.css({
							backgroundImage: 'url(\'' + originalURL + '\')'
						});
					},
					success: function () {
						el.css({
							backgroundImage: 'url(\'' + retinaURL + '\')'
						});
					}
				});
				
			}
		});
		
	}());
	
	/**
	* Module Slider
	**********************************************************************/
	(function () {
		
		/* 	A slider can be created by WordPress's native shortcode which
			will be contained within a .module-gallery-slider. If this is the 
			case, then we need to quarantine it from WordPress JavaScript
			behaviour by removing class names and attributes and to set it
			to our standard of a gallery:
			- Each item should have a .item class name.
			- Captions should be laid outside the items so we can set its
			  own styles.
			- 
			*/
		
		DOM.body.find('.module-gallery-slider').each(function () {
			
			var el = $(this)
				, gallery = el.find('.gallery, .module-slider')
				, items = el.find('.gallery-item')
				, captions = $('<div class="captions"></div>')
				, minHeight = 0
				, autoSlide = el.is('.auto-slide') ? ' auto-slide ' : ''
				;
				
			/* Remove the empty <p> tags produced by WordPress */
			el.children('p').filter(function(){
				return $.trim($(this).text()).length == 0;
			}).remove();
			
			el.append(captions);
			
			gallery.removeAttr('class style').addClass('module-slider' + autoSlide);
			items.removeClass('gallery-item').removeAttr('style').addClass('item').wrapInner('<div class="tabulated"><div class="cell"></div></div>');
			el.find('img').removeAttr('width height');
			
			items.each(function () {
				var item = $(this)
					, imageSource = item.find('img').attr('src')
					, figCaption = item.find('figcaption')
					, caption = figCaption.length ? figCaption.text() : ''
					, empty = caption == '' ? ' empty ' : ''
					;
				
				item.css({
					backgroundImage: 'url(\'' + imageSource + '\')'
				});
				captions.append('<div class="item ' + empty + '">' + caption + '</div>');
			});
			
			captions.find('.item').each(function () {
				var el = $(this)
					, height = el.outerHeight()
					;
					
				if (minHeight < height) {
					minHeight = height;
				}
			});
			
			captions.css({
				minHeight: minHeight
			});
			
		});
		
		DOM.body.find('.module-slider').each(function () {
			var el = $(this)
				, parentHeight = el.outerHeight()
				;
			
			var items = el.find('.item')
				, isGallery = items.parents('.module-gallery-slider').length ? true : false
				, totalItem = items.length
				, minHeight = 0
				, currentIndex = 0
				, autoSlide
				;
			
			el.imagesLoaded().always(function (instance) {
				items.each(function () {
					var item = $(this)
						, itemHeight = item.find('.cell')[0].scrollHeight
						;
					
					/* The height should depends on the item if it's a mobile device. */
					if (!DOM.isMobile) {
						if (el.is('.full-height')) { minHeight = DOM.winHeight; }
						if (el.is('.half-height')) { minHeight = DOM.winHeight / 2; }
						if (el.is('.one-third-height')) { minHeight = DOM.winHeight / 3; }
						if (el.is('.two-thirds-height')) { minHeight = (DOM.winHeight / 3) * 2; }
						if (el.is('.quarter-height')) { minHeight = DOM.winHeight / 4; }
					}
					
					if (itemHeight > minHeight) {
						minHeight = itemHeight;
					}
					
				});
				
				if (parentHeight > minHeight) {
					minHeight = parentHeight;
				}
				
				el.css({
					minHeight: minHeight
				});
				
				items.css({
					minHeight: minHeight
				});
				
				if (isGallery) {
					items.find('img').css({
						opacity: 0
					});
				}
				
			});
			
			if (totalItem > 1) {
				var html = '';
				for (var i = 0; i < totalItem; i++) {
					html+= '<span></span>';
				}
				
				el.append('<div class="bottom-nav tabulated"><div class="cell">' + html + '</div></div>');
			}
			
			var checking;
			var showItem = function (indexToShow, direction) {
				
				var slideTo
					, slideFrom
					, classNames = ['from-left', 'from-right', 'to-left', 'to-right']
					;
				if (direction == 'left') {
					slideTo = 'to-right';
					slideFrom = 'from-left';
				}
				else {
					slideTo = 'to-left';
					slideFrom = 'from-right';
				}
				
				items.eq(currentIndex).removeClass(classNames.join(' ')).addClass(slideTo);
				items.eq(indexToShow).removeClass(classNames.join(' ')).addClass(slideFrom);
				
				el.find('.bottom-nav span').removeClass('active');
				el.find('.bottom-nav span:eq(' + indexToShow + ')').addClass('active');
				
				/* 	If it's a gallery slider, then there likely to be captions we appended
					earlier above. Deal with it. */
				if (isGallery) {
					var gallerySlider = el.parents('.module-gallery-slider');
					gallerySlider.find('.captions .item').removeClass('active').eq(indexToShow).addClass('active');
				}
				
				if (items.eq(indexToShow).is('.has-handler-data')) {
					clearTimeout(checking);
					checking = setTimeout(function () {
						$.publish('check-header-state', (direction == 'left' ? 'down' : 'up'));
					}, 350);
					
					/*
					items.eq(indexToShow).one('transitionend oTransitionEnd', function (e) {
						if (e.originalEvent.propertyName == 'visibility') {
							$.publish('check-header-state', (direction == 'left' ? 'down' : 'up'));
						}
					});
					*/
				}
				
				currentIndex = indexToShow;
				
			};
			
			showItem(currentIndex);
							
			el.swipe({
				swipeLeft: function (event, direction, distance, duration, fingerCount, fingerData, currentDirection) {
					var indexToShow = (currentIndex + 1) % totalItem;
					showItem(indexToShow, 'right');
					clearInterval(autoSlide);
				}
				,
				swipeRight: function (event, direction, distance, duration, fingerCount, fingerData, currentDirection) {
					var indexToShow = (currentIndex - 1) % totalItem;
					showItem(indexToShow, 'left');
					clearInterval(autoSlide);
				}
			});
			
			/* Next and Prev links */
			if (totalItem > 1) {
				el.append('<span class="prev tabulated"><span class="cell">&larr;</span></span><span class="next tabulated"><div class="cell">&rarr;</div></span>');
			}
			
			el.find('.prev, .next').on('click', function (e) {
				
				e.stopPropagation();
				
				var el = $(this)
					, indexToShow
					, direction
					;
				
				if (el.is('.prev')) {
					indexToShow = (currentIndex - 1) % totalItem;
					direction = 'left';
				}
				else {
					indexToShow = (currentIndex + 1) % totalItem;
					direction = 'right';
				}
				
				showItem(indexToShow, direction);
				clearInterval(autoSlide);
			});
			
			/* Dot navigation */
			el.find('.bottom-nav span').on('click', function () {
				var el = $(this)
					, direction = currentIndex > el.index() ? 'left' : 'right';
					;
				
				showItem(el.index(), direction);
				clearInterval(autoSlide);
			});
			
			/* Auto slide */
			
			if (el.is('.auto-slide')) {
				autoSlide = setInterval(function () {
					showItem(((currentIndex + 1) % totalItem), 'right');
				}, 10000);
			}
			
		});
		
	}());
	
	/**
	* Video background
	**********************************************************************/
	(function () {
		
		DOM.body.find('.video-background').each(function () {
			
			var container = $(this)
				, video = container.find('video')
				;
			
			
			if (DOM.isMobile) {
				container.remove();
				return true;
			}
			
			video.on('loadedmetadata', function () {
				
				var column = container.parents('.column')
					, theVideo = video.get(0)
					;
				
				setTimeout(function () {
					
					theVideo.play();
					
					column.append('<span class="toggle-video-background tabulated"><span class="cell"><i class="fa fa-pause"></i></span></span>');
					
					var containerWidth = container.outerWidth()
						, containerHeight = container.outerHeight()
						, idealWidth = 0
						, videoHeight = video.get(0).videoHeight
						, videoWidth = video.get(0).videoWidth
						, minWidth = (containerHeight * videoWidth) / videoHeight
						;
					
					if (minWidth > containerWidth) {
						video.css({
							minWidth: minWidth
						});
					}
				}, 10);
				
				column.on('click', '.toggle-video-background', function () {
					var el = $(this)
						, icon = el.find('.fa')
						;
						
					if (!theVideo.paused && !theVideo.ended && theVideo.currentTime > 0) {
						theVideo.pause();
						icon.removeClass('fa-pause').addClass('fa-play');
					}
					else {
						theVideo.play();
						icon.removeClass('fa-play').addClass('fa-pause');
					}
				});
				
			});
			
		});
		
	}());
	
	/**
	* Module fading images
	**********************************************************************/
	(function () {
		
		DOM.body.find('.module-fading-images').each(function () {
			
			var container = $(this)
				, items = container.find('.item')
				, totalItem = items.length
				, currentIndex = 0
				, autoSlide
				, duration = 10000
				, iList = []
				;
			
			items.each(function () {
				var el = $(this);
				
				if (window.devicePixelRatio < 1.5 || DOM.isSmallScreen || DOM.html.is('.lt-ie10') || el.attr('data-src-retina') == '') {
					el.css('background-image', 'url(' + el.attr('data-src') + ')');
				}
				else {
					var retURL = el.attr('data-src-retina');
					
					$.ajax({
						url: retURL,
						type: 'HEAD',
						error: function () {
							el.css('background-image', 'url(' + el.attr('data-src') + ')');
						},
						success: function () {
							el.css('background-image', 'url(' + retURL + ')');
						}
					});
				}
				
			});
			
			var showItem = function (indexToShow) {
				
				var currentTarget = items.eq(indexToShow);
				currentTarget.removeClass('active bring-to-front').addClass('active bring-to-front');
				currentIndex = indexToShow;
				
				iList[indexToShow] = setTimeout(function () {
					items.eq(indexToShow).removeClass('active');
				}, (duration * 2) - (duration / 4));
				
				/* we need to bring back the previous shown item to z-index 2 */
				items.eq((indexToShow + totalItem - 1) % totalItem).removeClass('bring-to-front');
				
				var label = currentTarget.data('label')
					, bgColor = currentTarget.data('bg-color')
					;
				
				if ( !currentTarget.is('.has-handler-data') ) {
					currentTarget.addClass('has-handler-data');
				}
				
				if (label || bgColor) {
					setTimeout(function () {
						$.publish('check-header-state', 'down');
					}, 1000);
				}
				
			};
			
			showItem(currentIndex);
			
			autoSlide = setInterval(function () {
				var indexToShow = (currentIndex + 1) % totalItem;
				showItem(indexToShow);
			}, duration);
			
		});
		
	}());
	
	/**
	* Module button should have the same width if have at least one sibling
	**********************************************************************/
	(function () {
		
		DOM.body.find('p .module-button:eq(0)').each(function () {
			
			if (!$(this).next('.module-button').length) {
				return true;
			}
			
			var parent = $(this).parent()
				, maxWidth = 0
				;
			
			parent.find('.module-button').each(function () {
				var currentWidth = $(this).outerWidth();
				if (currentWidth > maxWidth) {
					maxWidth = currentWidth;
				}
			});
			
			parent.find('.module-button').css({
				width: maxWidth
			});
			
		});
		
	}());
	
	/**
	* 
	**********************************************************************/
	(function () {
		
		
		
	}());
	
});