jQuery(document).ready(function ($) {

	'use strict';
	
	var bodyEl = $('body:eq(0)')
		, wpBody = bodyEl.find('#wpbody')
		;
	
	window.theodorePluginExists = true;
	
	/**
	* Buttons with class 'uploader_button' is used to open 
	* the native media uploader. It should return the url of the selected 
	* item and put it to the target.
	**********************************************************************/
	(function () {
		
		var mediaButton = wpBody.find('.uploader_button')
			;
		
		mediaButton.each(function () {
			var el = $(this)
				, clearText = el.data('clear-text')
				, target = el.data('target')
				;
			if (clearText) {
				el.after(' <button class="button clear-image">' + clearText + '</button>');
			}
			wpBody.find('input#' + target).attr('readonly', true)
		});
		
		wpBody.on('click', '.clear-image', function (e) {
			var el = $(this);
			el.siblings('input[type="url"]').val('').trigger('change');
			el.siblings('.image-preview').empty();
			e.preventDefault();
			e.stopPropagation();
			return false;
		});
		
		wpBody.on('click', '.uploader_button', function (e) {
			e.preventDefault();
			
			var button = $(this)
				, target = $(this).data('target')
				, preview = $(this).data('preview')
				, previewContainer = wpBody.find('#'+preview)
				;
			
			if (target == '') {
				return false;
			}			
			
			/*
			create a new Library, base on defaults
			you can put your attributes in
			*/
			var insertImage = wp.media.controller.Library.extend({
				defaults :  _.defaults({
						id: 'insert-image',
						title: 'Insert Image Url',
						allowLocalEdits: true,
						displaySettings: true,
						displayUserSettings: true,
						multiple : true,
						type : 'image' /* audio, video, application/pdf, ... etc */
				  }, wp.media.controller.Library.prototype.defaults)
			});
			
			
			/* Setup media frame */
			var frame = wp.media({
				button : { text : 'Select' },
				state : 'insert-image',
				states : [
					new insertImage()
				]
			});
			
			frame.on('select',function() {
				
				var state = frame.state('insert-image')
					, selection = state.get('selection')
					;
				
				if (!selection) {
					return;
				}
				var imgSrc = ''
					, attachmentIds = []
					;
				selection.each(function(attachment) {
					var display = state.display(attachment).toJSON()
						, obj_attachment = attachment.toJSON()
						;
					
					display = wp.media.string.props(display, obj_attachment);
					imgSrc = display['src'];
					
					/* What is being returned? */
					attachmentIds.push(attachment.id);
				});
				
				/* This button is meant to print the value to wp_editor. */
				if (button.is('.to_editor')) {
					tinyMCE.activeEditor.execCommand('mceInsertContent', false, attachmentIds.join(', '));
				}
				/* This button is meant to print the value to a text field and show the image. */
				else {
					if (target != '') {
						wpBody.find('#' + target).val(imgSrc).trigger('change');
					}
					if (previewContainer.length) {
						previewContainer.html('<img src="' + imgSrc + '" />');
					}
				}
				
			});

			/* reset selection in popup, when open the popup */
			frame.on('open',function() {
				var selection = frame.state('insert-image').get('selection');

				/* remove all the selection first */
				selection.each(function(image) {
					var attachment = wp.media.attachment( image.attributes.id );
					attachment.fetch();
					selection.remove(attachment ? [attachment] : []);
				});				
			});

			/* now open the popup */
			frame.open();
		});
		
	}());
	
	/**
	* 
	**********************************************************************/
	(function () {		
		
		
		
	}());

});