<?php

/**

 * Shortcode attributes

 * @var $atts

 * @var $el_class

 * @var $css

 * @var $el_id

 * @var $content - shortcode content

 * Shortcode class

 * @var $this WPBakeryShortCode_VC_Row_Inner

 * Overrides

 * @var equal_col_height

 * @var equal_col_valign

 * @var bg_color_preset

 * @var bg_pos

 * @var fixed_bg_img

 * @var use_overlay

 * @var overlay_opacity

 * @var overlay_color

 * @var overlay_custom_color

 */

$output = $after_output = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );

extract( $atts );



$el_class = $this->getExtraClass( $el_class );

$css_classes = array(

	'vc_row',

	'wpb_row', //deprecated

	'vc_inner',

	'vc_row-fluid',

	$el_class,

	vc_shortcode_custom_css_class( $css ),

);

$wrapper_attributes = array();

// build attributes for wrapper

if ( ! empty( $el_id ) ) {

	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';

}



// OVERRIDING BEGIN HERE

$sm_row_class = sm_shortcode_unique_id( 'sm-row' );

$css_gen = new Inline_CSS_Generator( $sm_row_class );

$scoped_css = '';



if ( 'yes' == $equal_col_height ) {

	$css_classes[] = 'sm-eq-col-height';

	$equal_col_valign = sm_validate_with_array( $equal_col_valign, sm_get_row_equal_column_valigns_array() );

	if ( !empty( $equal_col_valign ) ) {

		$css_classes[] = $equal_col_valign;

	}

	if ( 'yes' == $equal_col_mobile ) {

		$css_classes[] = 'sm-eq-mobile';

	}

}



$bg_color_preset = sm_validate_with_array( $bg_color_preset, sm_get_design_box_preset_bg_array() );

$css_classes[] = $bg_color_preset;



if( $bg_pos != '' ) {

	$scoped_css .= $css_gen->css( '', array( 'background-position' => $bg_pos . ' !important' ) );

	$scoped_css .= $css_gen->css( '.vc_parallax-inner', array( 'background-position' => 'inherit' ) );

}



if ( 'yes' == $fixed_bg_img ) {

	$scoped_css .= $css_gen->css( '', array( 'background-attachment' => 'fixed' ) );

}



if ( 'yes' == $use_overlay ) {

	$css_items = array();

	$overlay_color = sm_validate_with_array( $overlay_color, sm_get_row_overlay_colors_array() );

	$css_classes[] = $overlay_color . '-overlay';

	$overlay_opacity = intval( $overlay_opacity );

	if ( !empty( $overlay_opacity ) ) {

		$css_items['opacity'] = $overlay_opacity / 100;

	}

	if ( 'custom' == $overlay_color ) {

		$css_items['background-color'] = $overlay_custom_color;

	}

	if ( !empty( $css_items ) ) {

		$scoped_css = $css_gen->css_with_self_condition( ':before', '', $css_items );

	}

}



if ( $scoped_css != '' ) $css_classes[] = $sm_row_class;

// OVERRIDING END HERE



$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );

$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php

sm_the_scoped_css( $scoped_css );

echo wpb_js_remove_wpautop( $content );

?>

</div>

<?php 

echo ( $after_output );

echo ( $this->endBlockComment( $this->getShortcode() ) );

?>