<?php

/**

 * Shortcode attributes

 * @var $atts

 * @var $el_class

 * @var $full_width

 * @var $full_height

 * @var $content_placement

 * @var $parallax

 * @var $parallax_image

 * @var $css

 * @var $el_id

 * @var $video_bg

 * @var $video_bg_url

 * @var $video_bg_parallax

 * @var $content - shortcode content

 * Shortcode class

 * @var $this WPBakeryShortCode_VC_Row

 * Overrides

 * @var equal_col_height

 * @var equal_col_valign

 * @var bg_color_preset

 * @var bg_pos

 * @var fixed_bg_img

 * @var use_overlay

 * @var overlay_opacity

 * @var overlay_color

 * @var overlay_custom_color

 */

$output = $after_output = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );

extract( $atts );



wp_enqueue_script( 'wpb_composer_front_js' );



$el_class = $this->getExtraClass( $el_class );





$css_classes = array(

	'vc_row',

	'wpb_row', //deprecated

	'vc_row-fluid',

	$el_class,

	vc_shortcode_custom_css_class( $css ),

);

$wrapper_attributes = array();

// build attributes for wrapper

if ( ! empty( $el_id ) ) {

	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';

}

if ( ! empty( $full_width ) ) {

	$wrapper_attributes[] = 'data-vc-full-width="true"';

	$wrapper_attributes[] = 'data-vc-full-width-init="false"';

	if ( 'stretch_row_content' === $full_width ) {

		$wrapper_attributes[] = 'data-vc-stretch-content="true"';

	} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {

		$wrapper_attributes[] = 'data-vc-stretch-content="true"';

		$css_classes[] = 'vc_row-no-padding';

	}

	$after_output .= '<div class="vc_row-full-width"></div>';

}



if ( ! empty( $full_height ) ) {

	$css_classes[] = ' vc_row-o-full-height';

	if ( ! empty( $content_placement ) ) {

		$css_classes[] = ' vc_row-o-content-' . $content_placement;

	}

}



// use default video if user checked video, but didn't chose url

if ( ! empty( $video_bg ) && empty( $video_bg_url ) ) {

	$video_bg_url = 'https://www.youtube.com/watch?v=lMJXxhRFO1k';

}



$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );



if ( $has_video_bg ) {

	$parallax = $video_bg_parallax;

	$parallax_image = $video_bg_url;

	$css_classes[] = ' vc_video-bg-container';

	wp_enqueue_script( 'vc_youtube_iframe_api_js' );

}

/*

if ( ! empty( $parallax ) ) {

	wp_enqueue_script( 'vc_jquery_skrollr_js' );

	$wrapper_attributes[] = 'data-vc-parallax="1.5"'; // parallax speed

	$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;

	if ( strpos( $parallax, 'fade' ) !== false ) {

		$css_classes[] = 'js-vc_parallax-o-fade';

		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';

	} elseif ( strpos( $parallax, 'fixed' ) !== false ) {

		$css_classes[] = 'js-vc_parallax-o-fixed';

	}

}



if ( ! empty ( $parallax_image ) ) {

	if ( $has_video_bg ) {

		$parallax_image_src = $parallax_image;

	} else {

		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );

		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );

		if ( ! empty( $parallax_image_src[0] ) ) {

			$parallax_image_src = $parallax_image_src[0];

		}

	}

	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_url( $parallax_image_src ) . '"';

}

if ( ! $parallax && $has_video_bg ) {

	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_url( $video_bg_url ) . '"';

}

*/



// OVERRIDING BEGIN HERE

$sm_row_class = sm_shortcode_unique_id( 'sm-row' );

$css_gen = new Inline_CSS_Generator( $sm_row_class );

$scoped_css = '';



if ( ! empty( $parallax ) ) {

	$css_classes[] = 'vc_parallax';

	if ( strpos( $parallax, 'fade' ) !== false ) {

		$css_classes[] = 'sm-parallax-fade';

	}

}



if ( ! empty ( $parallax_image ) ) {

	if ( $has_video_bg ) {

		$wrapper_attributes[] = 'data-sm-video-bg="' . esc_url( $video_bg_url ) . '"';

	} else {

		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );

		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );

		if ( ! empty( $parallax_image_src[0] ) ) {

			$parallax_image_src = $parallax_image_src[0];

		}

		$scoped_css .= $css_gen->css( '.sm-parallax-bg', 

			array( 'background-image' => 'url(' . $parallax_image_src . ')' ) );

	}

}



if ( 'yes' == $equal_col_height ) {

	$css_classes[] = 'sm-eq-col-height';

	$equal_col_valign = sm_validate_with_array( $equal_col_valign, sm_get_row_equal_column_valigns_array() );

	if ( !empty( $equal_col_valign ) ) {

		$css_classes[] = $equal_col_valign;

	}

	if ( 'yes' == $equal_col_mobile ) {

		$css_classes[] = 'sm-eq-mobile';

	}

}



$bg_color_preset = sm_validate_with_array( $bg_color_preset, sm_get_design_box_preset_bg_array() );

$css_classes[] = $bg_color_preset;



if( $bg_pos != '' ) {

	$scoped_css .= $css_gen->css( '', array( 'background-position' => $bg_pos . ' !important' ) );

	$scoped_css .= $css_gen->css( '.vc_parallax-inner', array( 'background-position' => 'inherit' ) );

}



if ( 'yes' == $fixed_bg_img ) {

	$scoped_css .= $css_gen->css( '', array( 'background-attachment' => 'fixed' ) );

	//$wrapper_attributes[] = 'style="background-attachment:fixed; transform:translateZ(0);"';

}



if ( 'yes' == $use_overlay ) {

	$css_items = array();

	$overlay_color = sm_validate_with_array( $overlay_color, sm_get_row_overlay_colors_array() );

	$css_classes[] = $overlay_color . '-overlay';

	$overlay_opacity = intval( $overlay_opacity );

	if ( !empty( $overlay_opacity ) ) {

		$css_items['opacity'] = $overlay_opacity / 100;

	}

	if ( 'custom' == $overlay_color ) {

		$css_items['background-color'] = $overlay_custom_color;

	}

	if ( !empty( $css_items ) ) {

		$scoped_css = $css_gen->css_with_self_condition( ':before', '', $css_items );

	}

}



if ( $scoped_css != '' ) $css_classes[] = $sm_row_class;

// OVERRIDING END HERE



$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );

$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php

sm_the_scoped_css( $scoped_css );

echo wpb_js_remove_wpautop( $content );

?>

</div>

<?php 

echo ( $after_output );

echo ( $this->endBlockComment( $this->getShortcode() ) );

?>