<?php

extract ( shortcode_atts ( array (

		'photo' => '',

		'name' => '',

		'title' => '',

		'link' => '',

		'css_animation' => '',

		'animation_delay' => '',

		'el_class' => ''

), $atts ) );



$id = sm_shortcode_unique_id( 'sm_team_slider_item' );

$css_class = array( 'sm-team-slider-item', 'sm_content_element' );



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$photo_url = wp_get_attachment_url( $photo );



$social_infos = sm_make_social_links_collection( $atts );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';



$style = $GLOBALS['sm-team-slider-style'];

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php if ( 'sm-style1' == $style || 'sm-style2' == $style ) : ?>

	<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

	<div class="member-info">

		<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

		<div class="member-name"><?php echo esc_html( $name ); ?></div>

		<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

		<div class="member-title"><?php echo esc_html( $title ); ?></div>

		<div class="member-dscr"><?php echo sm_js_remove_wpautop( $content, true ); ?></div>

		<div class="member-social-links">

		<?php

		foreach( $social_infos as $social_info ) {

			echo '<a class="member-social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

		}

		?>

		</div>

	</div>

<?php elseif ( 'sm-style3' == $style ) : ?>

	<div class="photo-wrap">

		<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

		<div class="social-overlay">

			<div class="member-social-links">

			<?php

			foreach( $social_infos as $social_info ) {

				echo '<a class="member-social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

			}

			?>

			</div>

		</div>

	</div>

	<div class="member-info">

		<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

		<div class="member-name"><?php echo esc_html( $name ); ?></div>

		<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

		<div class="member-title"><?php echo esc_html( $title ); ?></div>

		<div class="member-dscr"><?php echo sm_js_remove_wpautop( $content, true ); ?></div>

	</div>

<?php endif; ?>

</div>