<?php

extract ( shortcode_atts ( array (

		'style' => '',

		'photo' => '',

		'name' => '',

		'title' => '',

		'name_color' => '',

		'title_color' => '',

		'content_color' => '',

		'link' => '',

		'css_animation' => '',

		'animation_delay' => '',

		'el_class' => '', 

), $atts ) );



$css_class = array( 'sm-team-member', 'sm_content_element' );



$style = sm_validate_with_array( $style, sm_get_team_member_styles_array() );

$css_class[] = $style;



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$photo_url = wp_get_attachment_url( $photo );



$id = sm_shortcode_unique_id( 'sm_team_member' );

$css_gen = new Inline_CSS_Generator( "sm-team-member", $id );

$scoped_css = '';

if ( !empty( $name_color ) ) {

	$scoped_css .= $css_gen->css( '.member-name', array( 'color' => $name_color ) );

}

if ( !empty( $title_color ) ) {

	$scoped_css .= $css_gen->css( '.member-title', array( 'color' => $title_color ) );

}

if ( !empty( $content_color ) ) {

	$scoped_css .= $css_gen->css( '.member-dscr', array( 'color' => $content_color ) );

}



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}

$social_infos = sm_make_social_links_collection( $atts );

?>



<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

<?php if ( 'sm-style1' == $style ) : ?>

	<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

	<div class="member-info-wrap">

		<div class="member-bg"></div>

		<div class="member-info">

			<div class="member-title"><?php echo esc_html( $title ); ?></div>

			<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

			<div class="member-name"><?php echo esc_html( $name ); ?></div>

			<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

			<div class="member-social-links">

			<?php

			foreach( $social_infos as $social_info ) {

				echo '<a class="member-social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

			}

			?>

			</div>

		</div>

	</div>

<?php elseif ( 'sm-style2' == $style ) : ?>

	<div class="image-wrap">

		<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

		<div class="member-info-wrap">

			<div class="member-bg"></div>

			<div class="member-info">

				<div class="sm-social-links sm-style-outline">

				<?php

				$k = 1;

				foreach( $social_infos as $social_info ) {

					if ( $k > 0 ) echo '<span class="social-link-group">';

					echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

					if ( $k < 0 ) echo '</span>';

					$k = -$k;

				}

				?>

				</div>

			</div>

		</div>

	</div>

	<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

	<h6 class="member-name"><?php echo esc_html( $name ); ?></h6>

	<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

	<div class="member-title"><?php echo esc_html( $title ); ?></div>

<?php elseif ( 'sm-style3' == $style ) : ?>

	<div class="image-wrap">

		<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

		<div class="member-info-wrap">

			<div class="member-bg"></div>

			<div class="member-info">

				<div class="sm-social-links sm-style-outline">

				<?php

				foreach( $social_infos as $social_info ) {

					echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

				}

				?>

				</div>

			</div>

		</div>

	</div>

	<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

	<h5 class="member-name"><?php echo esc_html( $name ); ?></h5>

	<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

	<div class="member-title"><?php echo esc_html( $title ); ?></div>

	<div class="member-dscr"><?php echo sm_do_kses( $content ); ?></div>

<?php elseif ( 'sm-style4' == $style ) : ?>

	<div class="image-wrap"><img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" /></div>

	<div class="info-wrap">

		<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

		<h5 class="member-name"><?php echo esc_html( $name ); ?></h5><?php if ( !empty( $link ) ) : ?></a><?php endif; ?><div class="member-title"><?php echo esc_html( $title ); ?></div>

		<div class="member-dscr"><?php echo sm_do_kses( $content ); ?></div>

		<div class="sm-social-links sm-shape-rounded">

		<?php

		foreach( $social_infos as $social_info ) {

			echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

		}

		?>

		</div>

	</div>

<?php elseif ( 'sm-style5' == $style ) : ?>

	<div class="image-wrap">

		<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

		<div class="sm-social-links sm-shape-square sm-style-solid">

			<?php

			foreach( $social_infos as $social_info ) {

				echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

			}

			?>

		</div>

	</div>

	<div class="info-wrap">

		<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

		<h5 class="member-name"><?php echo esc_html( $name ); ?></h5><?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

		<div class="member-title"><?php echo esc_html( $title ); ?></div>

	</div>

<?php elseif ( 'sm-style6' == $style ) : ?>

	<img class="photo" src="<?php echo esc_url( $photo_url ); ?>" alt="<?php esc_attr( $name ); ?>" />

	<div class="info-wrap">

		<?php if ( !empty( $link ) ) : ?><a href="<?php echo esc_url( $link ); ?>"><?php endif; ?>

		<div class="member-name"><?php echo esc_html( $name ); ?></div>

		<?php if ( !empty( $link ) ) : ?></a><?php endif; ?>

		<div class="member-title"><?php echo esc_html( $title ); ?></div>

		<div class="member-dscr"><?php echo sm_js_remove_wpautop( $content, true ); ?></div>

		<div class="sm-social-links sm-shape-circle sm-style-outline">

		<?php

		foreach( $social_infos as $social_info ) {

			echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

		}

		?>

		</div>

	</div>

<?php endif; ?>

</div>