<?php
$output = $title = $interval = $el_class = '';
extract( shortcode_atts( array(
	'title' => '',
	'interval' => 0,
	'el_class' => '',
	'style' => '',
	'shape' => '',
	'header_color' => 'sm-grey',
	'custom_header_color' => '',
	'custom_header_text_color' => '',
	'active_header_color' => '',
	'custom_active_header_color' => '',
	'custom_active_header_text_color' => '',
	'content_bg' => '',
	'content_border' => 'yes',
	'header_style' => '',
	'header_border_color' => '',
	'custom_header_border_color' => '',
), $atts ) );

$id = sm_shortcode_unique_id( 'sm_tabs' );
$element = 'sm_tabs';

$css_class = array( 'sm_tabs', 'sm_content_element' );
$css_gen = new Inline_CSS_Generator( "sm_tabs", $id );
$scoped_css = '';

$shape = sm_validate_with_array( $shape, sm_get_accordion_tab_shapes_array() );
$css_class[] = $shape;

$style = sm_validate_with_array( $style, sm_get_tabs_styles_array() );
if ('sm-style-outline' == $style ) {
	$css_class[] = $style;
} else {
	$preset_bg_colors = sm_get_preset_bg_colors_array( true );
	// Add Header Color
	$header_color = sm_validate_with_array( $header_color, $preset_bg_colors );
	if ( 'custom' == $header_color ) {
		$scoped_css .= $css_gen->css( ".sm_tabs_nav li:not(.ui-state-active)", 
			array( 'background-color' => $custom_header_color ) );
		$scoped_css .= $css_gen->css( ".sm_tabs_nav li:not(.ui-state-active) a", 
			array( 'color' => $custom_header_text_color	) );
	} else {
		$css_class[] = $header_color;
	}
	// Add Active Header Color
	$active_header_color = sm_validate_with_array( $active_header_color, $preset_bg_colors );
	if ( 'custom' == $active_header_color ) {
		$scoped_css .= $css_gen->css( ".sm_tabs_nav li.ui-state-active", 
			array( 'background-color' => $custom_active_header_color) );
		$scoped_css .= $css_gen->css( ".sm_tabs_nav li.ui-state-active a", 
			array( 'color' => $custom_active_header_text_color ) );
		$scoped_css .= $css_gen->css( ".sm_tabs_nav li.ui-state-active:before", 
			array( 'border-top-color' => $custom_active_header_color ) 
		);
		if ( 'sm-same-bg' == $content_bg ) {
			$scoped_css .= $css_gen->css( "", 
				array( 
					'background-color' => $custom_active_header_color,
					'color' => $custom_active_header_text_color
				) 
			);
			$scoped_css .= $css_gen->css( ".sm_tabs_nav li", 
				array( 'border-color' => $custom_active_header_color ) 
			);
			$scoped_css .= $css_gen->css( ".sm-panel-wrap", array( 'border' => 'none' ) );
		}
	} else {
		$css_class[] = $active_header_color . '-active';
	}
	// Add Header style to class
	$header_style = sm_validate_with_array( $header_style, sm_get_tabs_header_styles_array() );
	if ( '' != $header_style ) $css_class[] = $header_style;

	//If header style is Border Style, it has custom color.
	if ( 'sm-header-border-top' == $header_style || 'sm-header-border-bottom' == $header_style ) {
		$header_border_color = sm_validate_with_array( $header_border_color, sm_get_preset_colors_array( true ) );
		if ( 'custom' == $header_border_color ) {
			$scoped_css .= $css_gen->css( ".sm_tabs_nav li.ui-state-active:after", 
				array( 'background-color' => $custom_header_border_color ) );
		} else if ( !empty( $header_border_color ) ) {
			$css_class[] = $header_border_color . '-border';
		}
	}

	if ( !empty( $content_bg ) ) {
		$css_class[] = $content_bg;
	}
	if ( 'yes' != $content_border ) {
		$scoped_css .= $css_gen->css( '.sm-panel-wrap', 
				array( 'border' => 'none !important' ) );
	}
}

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-interval="' . esc_attr( $interval ) . '"';

wp_enqueue_script( 'sm-jquery-ui-tabs' );
wp_enqueue_script( 'sm-jquery-ui-tabs-rotate' );
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="sm_wrapper sm_tabs_wrapper ui-tabs clearfix">
		<?php echo sm_widget_title( array( 'title' => $title, 'extraclass' => $element . '_heading' ) ); ?>
		<ul class="sm_tabs_nav ui-tabs-nav">
			<?php
			preg_match_all( '/sm_tab([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );
			$tab_titles = array();
			// Extract tab titles
			if ( isset( $matches[1] ) ) {
				$tab_titles = $matches[1];
			}
			foreach ( $tab_titles as $tab ) :
				$tab_atts = shortcode_parse_atts( $tab[0] );
				if ( isset( $tab_atts['title'] ) ) :
					$hash = '#tab-' . ( isset( $tab_atts['tab_id'] ) ? esc_attr( $tab_atts['tab_id'] ) : sanitize_title( $tab_atts['title'] ) );
					$icon = sm_get_icon_from_atts( $tab_atts, true );
					if ( !empty( $icon ) ) :
						$icon = '<i class="tab-icon ' . $icon . '"></i>';
					endif;
			?>
			<li><a href="<?php echo esc_url( $hash ); ?>" class="ui-tabs-anchor"><?php echo sm_do_kses( $icon ) . esc_html( $tab_atts['title'] ); ?></a></li>
			<?php
				endif;
			endforeach;
			?>
		</ul>
		<div class="sm-panel-wrap">
			<?php
			echo sm_js_remove_wpautop( $content );
			?>
		</div>
	</div>
</div>