<?php

extract( shortcode_atts ( array (

		'shape' => '',

		'style' => '',

		'color' => '',

		'align' => '',

		'open_new' => '',

		'css_animation' => '',

		'animation_delay' => '',

		'el_class' => '',

), $atts ) );



$css_class = array( 'sm-social-links', 'sm_content_element' );



$style = sm_validate_with_array( $style, sm_get_social_links_styles_array() );

if ( !empty( $style ) ) $css_class[] = $style;



$shape = sm_validate_with_array( $shape, sm_get_social_links_shapes_array() );

if ( !empty( $shape ) ) $css_class[] = $shape;



$align = sm_validate_with_array( $align, sm_get_default_aligns_array() );

if ( !empty( $align ) ) $css_class[] = $align;



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$id = sm_shortcode_unique_id( 'sm_social_links' );

$css_gen = new Inline_CSS_Generator( 'sm-social-links', $id );

$scoped_css = '';

if ( !empty( $color ) ) {

	if ( 'sm-style-outline' == $style ) {

		$scoped_css .= $css_gen->css( '.social-link:before', array( 'border-color' => $color ) );

		$scoped_css .= $css_gen->css( '.social-link', array( 'color' => $color ) );

		$scoped_css .= $css_gen->css( '.social-link:hover', array( 'color' => 'white' ) );

		if ( '#fff' != $color && '#ffffff' != $color )

			$scoped_css .= $css_gen->css( '.social-link:after', array( 'background-color' => $color ) );

	} else if ( 'sm-style-solid' == $style ) {

		$scoped_css .= $css_gen->css( '.social-link:before', array( 'background-color' => $color ) );

		$scoped_css .= $css_gen->css( '.social-link:hover', array( 'color' => 'white' ) );

	} else {

		$scoped_css .= $css_gen->css( '.social-link', array( 'color' => $color ) );

		$scoped_css .= $css_gen->css( '.social-link:hover', array( 'color' => 'white' ) );

		if ( '#fff' != $color && '#ffffff' != $color )

			$scoped_css .= $css_gen->css( '.social-link:after', array( 'background-color' => $color ) );

	}

}



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



$social_infos = sm_make_social_links_collection( $atts );



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

	<?php

	if ( 'true' == $open_new ) $open_new = ' target="_blank"';

	foreach( $social_infos as $social_info ) {

		echo '<a class="social-link" title="' . esc_attr( $social_info['name'] ) . '" href="' . esc_url( $social_info['url'] ) . '"' . $open_new . '><i class="' . esc_attr( $social_info['icon'] ) . '"></i></a>';

	}

	?>

</div>

