<?php

extract( shortcode_atts( array(

	'style' => '',

	'color' => '',

	'custom_color' => '',

	'align' => '',

	'margin_top' => '',

	'margin_bottom' => '',

	'border_width' => '',

	'el_width' => '',

	'el_class' => '',

	'css_animation' => '',

	'animation_delay' => '',

), $atts ) );



$css_class = array( 'sm-separator', 'sm_content_element' );

$scoped_css = '';

$id = sm_shortcode_unique_id( "sm-separator" );

$css_gen = new Inline_CSS_Generator( "sm-separator", $id );



$style = sm_validate_with_array( $style, sm_get_separator_styles_array() );

$color = sm_validate_with_array( $color, sm_get_preset_border_colors_array() );

$align = sm_validate_with_array( $align, sm_get_default_aligns_array() );

if ( !empty( $color ) ) {

	$css_class[] = $color;

}

if ( 'custom' == $color ) {

	$scoped_css .= $css_gen->css( 

		array( '.left-line', '.left-line:before', '.right-line', '.right-line:before', '.diamond' ), 

		array( 'background-color' => $custom_color )

	);

	$scoped_css .= $css_gen->css( 'hr', array( 'border-top-color' => $custom_color . ' !important' ) );

}

if ( !empty( $align ) ) $css_class[] = $align;

 if ( 'sm-style-diamond' == $style ) $css_class[] = $style;



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<?php if ( 'sm-style-diamond' == $style ) : ?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php 

	if ( 'custom' == $color ) :

		$scoped_css .= $css_gen->css( 

			array( '.left-line', '.left-line:before', '.right-line', '.right-line:before', '.diamond' ), 

			array( 'background-color' => $custom_color )

		);

		sm_the_scoped_css( $scoped_css );

	endif;

	?>

	<div class="left-line"></div>

	<div class="right-line"></div>

	<div class="diamond"></div>

</div>

<?php else : ?>

<?php

	$border_width = sm_validate_with_array( $border_width, sm_get_separator_border_widths_array() );

	$margin_top = intval( $margin_top );

	$margin_bottom = intval( $margin_bottom );



	$custom_widths = array();

	$custom_margin = array();

	if ( !empty( $border_width ) ) {

		$custom_widths['border-top-width'] = $border_width . 'px';

	}

	if ( !empty( $el_width ) ) {

		$custom_widths['width'] = sm_validate_length_unit( $el_width );

	}

	if ( $margin_top != 0 ) {

		$custom_margin['margin-top'] = $margin_top . 'px';

	}

	if ( $margin_bottom != 0 ) {

		$custom_margin['margin-bottom'] = $margin_bottom . 'px';

	}

	if ( !empty( $custom_widths ) ) {

		$scoped_css .= $css_gen->css( 'hr', $custom_widths );

	}

	if ( !empty( $custom_margin ) ) {

		$scoped_css .= $css_gen->css( '', $custom_margin );

	}

	if ( 'custom' == $color ) {

		$scoped_css .= $css_gen->css( 'hr', array( 'border-top-color' => $custom_color . ' !important' ) );

	}

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

	<hr />

</div>

<?php endif; ?>