<?php

extract( shortcode_atts( array(

	'wrapper_type' => '',

	'polygon_points' => '50,5 10,27 10,73 50,95 90,73 90,27',

	'show_vline' => 'yes',

	'bg_style' => '',

	'bg_color' => '',

	'border_color' => '',

	'scroll_to_row' => 'yes',

), $atts ) );



$css_class = array( 'sm_content_element', 'sm_section_icon' );

$wrapper_type = sm_validate_with_array( $wrapper_type, sm_get_section_icon_wrapper_types_array() );

$points = '';

if ( 'sm-wrap-circle' == $wrapper_type ) {

	$css_class[] = $wrapper_type;

} else {

	$css_class[] = 'sm-wrap-polygon';

	if ( 'sm-wrap-hexagon' == $wrapper_type ) {

		$points = '50,5 10,27 10,73 50,95 90,73 90,27';

	} elseif ( 'sm-wrap-triangle' == $wrapper_type ) {

		$points = '7,22 93,22 50,97';

	} elseif ( 'sm-wrap-pentagon' == $wrapper_type ) {

		$points = '50,95 8,64 23,14 77,14 92,64';

	} elseif ( 'custom' == $wrapper_type ) {

		$points = esc_attr( $polygon_points );

	}

}



$bg_style = sm_validate_with_array( $bg_style, sm_get_section_icon_color_styles_array() );

$border_color = sm_validate_with_array( $border_color, sm_get_section_icon_border_colors_array() );

if ( 'sm-style-solid' == $bg_style ) {

	$bg_color = sm_validate_with_array( $bg_color, sm_get_preset_colors_array( false, false, false ) );

	$css_class[] = $bg_color;

} else {

	$css_class[] = $bg_style;

}

if ( 'yes' == $scroll_to_row ) {

	$css_class[] = 'scroll-to-row';

}

$icon = sm_get_icon_from_atts( $atts );



$css_class = implode( ' ', $css_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';





?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php if ( 'sm-wrap-circle' == $wrapper_type ) : ?>

	<div class="section_icon_inner <?php echo esc_attr( $border_color ); ?>">

		<div class="icon-wrap"><i class="<?php echo esc_attr( $icon ); ?>"></i></div>

	</div>

<?php else : ?>

	<?php

	$polygon_attributes = array();

	$polygon_attributes[] = 'points="' . $points . '"'; 

	if ( 'sm-style-def-grad1' == $bg_style || 'sm-style-def-grad2' == $bg_style ) {

		$grad_id = sm_shortcode_unique_id( 'sm-polygon-grad' );

		$polygon_attributes[] = 'fill="url(#' . esc_attr( $grad_id ) . ')"';

	}

	?>

	<svg height="100" width="100" class="<?php echo esc_attr( $border_color ); ?>">

	<?php if ( 'sm-style-def-grad1' == $bg_style || 'sm-style-def-grad2' == $bg_style ) : ?>

		<defs>

			<linearGradient id="<?php echo esc_attr( $grad_id ); ?>" x1="20%" y1="20%" x2="80%" y2="80%">

				<stop offset="0%" class="stop_off0" />

				<stop offset="100%" class="stop_off100" />

			</linearGradient>

		</defs>

	<?php endif; ?>

		<polygon <?php echo implode( ' ', $polygon_attributes ); ?>></polygon>

		<?php echo esc_html__( 'Sorry, your browser does not support inline SVG.', 'semona-extension' ); ?>

	</svg>

	<div class="icon-wrap"><i class="<?php echo esc_attr( $icon ); ?>"></i></div>

<?php endif; ?>

<?php if ( 'yes' == $show_vline ) : ?>

	<div class="vline-circle"></div>

<?php endif; ?>

</div>