<?php

extract ( shortcode_atts ( array (

	'title' => 'Heading Title',

	'subtitle' => '',

	'style' => '',

	'align' => '',

	'letter_spacing' => '',

	'subtitle_color' => '',

	'text_color' => '',

	'show_underline' => 'yes',

	'put_period' => '',

	'underline_width' => '',

	'underline_color' => '',

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => '', 

), $atts ) );



$css_class = array( 'sm-section-header', 'sm_content_element', 'clearfix' );

if ( 'yes' == $show_underline ) {

	$style = sm_validate_with_array($style, sm_get_section_header_styles_array() );

	if ( !empty( $style) ) $css_class[] = $style;

}

$align = sm_validate_with_array( $align, sm_get_default_aligns_array() );

if ( !empty( $align ) ) $css_class[] = $align;



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$id = sm_shortcode_unique_id( 'sm-section-header' );

$css_gen = new Inline_CSS_Generator( "sm-section-header", $id );



$scoped_css = '';

$subtitle_class = array( 'subtitle' );



$subtitle_color = sm_validate_with_array( $subtitle_color, sm_get_preheader_colors_array() );

if ( !empty( $subtitle_color ) ) {

	$subtitle_class[] = $subtitle_color;

} else if( !empty( $text_color ) ) {

	$scoped_css .= $css_gen->css( '.subtitle', array( 'color' => $text_color ) );

}



$letter_spacing = sm_validate_with_array( $letter_spacing, sm_get_letter_spacings_array() );

if( !empty( $letter_spacing ) ) {

	$scoped_css .= $css_gen->css( array( '.title', '.subtitle' ), array( 'letter-spacing' => $letter_spacing ) );

}



if( !empty( $text_color ) ) {

	$scoped_css .= $css_gen->css( '.title', array( 'color' => $text_color ) );

}



if( !empty( $underline_color ) ) {

	$scoped_css .= $css_gen->css( '.underline:before', array( 'background-color' => $underline_color . ' !important' ) );

}



$underline_width = intval( $underline_width );

if ( $underline_width > 0 ) {

	$scoped_css .= $css_gen->css( '.underline:before', array( 'width' => $underline_width . 'px' ) );

}



if ( 'yes' == $put_period ) {

	$title .= '<span class="primary-color">.</span>';

}



$subtitle_class = implode( ' ', $subtitle_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

	<?php if ( !empty( $subtitle ) ): ?><h4 class="<?php echo esc_attr( $subtitle_class ); ?>"><?php echo esc_html( $subtitle ); ?></h4><?php endif; ?>

	<?php if ( !empty( $title ) ): ?><h2 class="title"><?php echo sm_do_kses( $title ); ?></h2><?php endif; ?>

	<?php if ( 'yes' == $show_underline ): ?>

		<?php if ( 'sm-style-diamond' == $style ): 

			$sep_atts = array();

			$sep_atts[] = 'style="sm-style-diamond"';

			$sep_atts[] = 'align="' . esc_attr( $align ) . '"';

			if ( !empty( $underline_color ) ) :

				$sep_atts[] = 'color="custom"';

				$sep_atts[] = 'custom_color="' . $underline_color . '"';

			else:

				$sep_atts[] = 'color="sm-heading-underline"';

			endif;

		?>

			<?php echo do_shortcode( '[sm_separator ' . implode( ' ', $sep_atts ) . ']'); ?>

		<?php else: ?>

			<div class="underline"></div>

		<?php endif; ?>

	<?php endif; ?>

</div>