<?php

extract ( shortcode_atts ( array (

	'title' => '',

	'price' => '',

	'currency' => '$',

	'period' => '/month',

	'button_caption' => '',

	'button_link' => '',

	'open_new' => '',

	'featured' => '',

	'featured_text' => 'hot',

	'raised' => '',

	'color' => '',

	'custom_color' => '',

	'badge_color' => '',

	'custom_badge_color' => '',

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => '', 

), $atts ) );



$color = sm_validate_with_array( $color, sm_get_preset_colors_array( true, false ) );

$badge_color = sm_validate_with_array( $badge_color, sm_get_preset_colors_array( true, false ) );



$wrapper_class = array( 'sm-pricing-column-wrapper' );

if( 'yes' == $featured ) {

	$wrapper_class[] = 'sm-featured';

	if ( 'yes' == $raised ) {

		$wrapper_class[] = 'sm-raised';

	}

}



if ( !empty( $color ) ) $wrapper_class[] = $color;



$wrapper_class = implode( ' ', $wrapper_class );



$css_class = array( "sm-pricing-column", "sm_content_element" );

$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$id = sm_shortcode_unique_id( 'sm-pricing-column' );

$css_gen = new Inline_CSS_Generator( "sm-pricing-column", $id );

$scoped_css = '';



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



$style = 'sm-style1';

if ( !empty( $GLOBALS['sm-pricing-table-style'] ) ) {

	$style = $GLOBALS['sm-pricing-table-style'];

}

$button_shape = '';

if ( !empty( $GLOBALS['sm-pricing-table-button-shape'] ) ) {

	$button_shape = $GLOBALS['sm-pricing-table-button-shape'];

}



$button_attributes = array();

$button_attributes[] = 'link="' . esc_url( $button_link ) . '"';

$button_attributes[] = 'style="sm-style-outline"';

$button_attributes[] = 'size="sm-size-md"';

$button_attributes[] = 'uppercase="yes"';

if ( !empty( $button_shape ) )  $button_attributes[] = 'shape="' . esc_attr( $button_shape ) . '"';



if ( 'sm-style1' == $style ) {

	$button_attributes[] = 'color="' . $color . '"';

	if ( 'custom' == $color ) {

		$button_attributes[] = 'custom_color="' . $custom_color . '"';

		$scoped_css .= $css_gen->css( '.header .title', array( 'background-color' => $custom_color ) );

		$scoped_css .= $css_gen->css( '.header .title', array( 

			'-webkit-box-shadow' => '0px 5px 0px ' . sm_change_hex_hsl( $custom_color, 0, 0, -15 ),

			'-moz-box-shadow' => '0px 5px 0px ' . sm_change_hex_hsl( $custom_color, 0, 0, -15 ),

			'box-shadow' => '0px 5px 0px ' . sm_change_hex_hsl( $custom_color, 0, 0, -15 ),

		) );

	}

} else if ( 'sm-style2' == $style ) {

	//$button_attributes[] = 'shape="sm-shape-square"';

	$button_attributes[] = 'border_width="sm-border-thick"';

	if ( 'custom' == $color ) {

		$scoped_css .= $css_gen->css( '.header .price', array( 'border-color' => $custom_color ) );

		$scoped_css .= $css_gen->css( '.header .price-inner', array( 'background-color' => $custom_color ) );

	}

} else if ( 'sm-style3' == $style ) {

	$button_attributes[] = 'border_width="sm-border-thick"';

	if ( 'custom' == $color ) {

		$scoped_css .= $css_gen->css( '.header .price', array( 'background-color' => $custom_color ) );

	}

}

if ( 'true' == $open_new ) {

	$button_attributes[] = 'open_new="true"';

}

if ( 'custom' == $badge_color ) {

	$scoped_css .= $css_gen->css( '.header .featured-text', array( 'background-color' => $custom_badge_color ) );

}



$items = ( !empty ( $content ) ) ? explode ( "\n", trim ( $content ) ) : array ();

?>

<div class="<?php echo esc_attr( $wrapper_class ); ?>">

<?php sm_the_scoped_css( $scoped_css ); ?>

	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>



		<div class="header">

			<div class="title">

				<?php 

				echo esc_html( $title ); 

				if ( 'yes' == $featured && !empty( $featured_text ) ) :

				?>

					<span class="featured-text<?php if ( !empty( $badge_color ) ) : echo ' ' . esc_attr( $badge_color ); endif; ?>"><?php echo esc_html( $featured_text ); ?></span>

				<?php

				endif;

				?>

			</div>

			<div class="price">

				<div class="price-inner">

					<span class="value"><sup><?php echo esc_html( $currency ); ?></sup><?php echo esc_html( $price ); ?></span>

					<?php if ( !empty( $period ) ) : ?><span class='period'><?php echo esc_html( $period ); ?><?php endif; ?></span>

				</div>

			</div>

		</div>



		<div class="features">

		<?php

		foreach ( $items as $item ) :

		?>

			<div class="feature"><?php echo sm_do_kses( $item ); ?></div>

		<?php

		endforeach;

		?>

		</div>



		<div class="footer">

			<?php echo do_shortcode( '[sm_button ' . implode( ' ', $button_attributes ) . ']' . esc_html( $button_caption ) . '[/sm_button]' ); ?>

		</div>



	</div>

</div>



