<?php



extract( shortcode_atts( array(

	'style' => 'masonry',

	'column_count' => '1',

	'per_page' => '',

	'show_filter' => '',

	'pagination_type' => 'none',

	'disable_padding' => '',

	'appear_animation' => true,

	'categories' => false,

	'el_class' => '',

), $atts ) );



$query_args = array();

$query_args['post_type'] = 'crf_portfolio';

if( $per_page ) {

	$query_args['posts_per_page'] = $per_page;

}

$query_args['post_status'] = array( 'publish', 'private' );

if( $categories ) {

	global $sm_pf_categories;

	$sm_pf_categories = array_map( 'trim', explode( ',', $categories ) );

	$query_args['tax_query'] = array(

		array(

			'taxonomy' 	=> 'portfolio_category',

			'terms' 	=> $sm_pf_categories,

		)

	);

}

$query_args['has_password'] = false;

$query_args['ignore_sticky_posts'] = true;

if( $pagination_type && $pagination_type == 'pagination' ) {

	if( is_front_page() || is_home() ) {

		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );

	} else {

		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

	}

	$query_args['paged'] = $paged;

}

$query = new WP_Query( $query_args );



echo '<div class="sm-sc-portfolio sm_content_element">';



if( $query->have_posts() ) {

	if( $show_filter == 'yes' ) {

		get_template_part( 'templates/portfolio/filter' );

	}

	

	if( $disable_padding != 'true' ) {

		echo "<div class='row'>";

	}

	

	$padding_class = ( $disable_padding ) ? ' disable-padding' : '';

	$appear_animation = ( $appear_animation ) ? 'true' : 'false';



	if( 'masonry' == $style || 'masonry2' == $style ) {

		echo '<div class="sm-portfolio-grid clearfix sm-isotope-container' . $padding_class . '" data-selector=".sm-portfolio" data-columns="' . esc_attr( $column_count ) . '" data-gutter="0" data-layout="masonry2" data-appear-animation="' . $appear_animation . '">';

	} else if( 'grid' == $style ) {

		echo '<div class="sm-portfolio-grid clearfix sm-isotope-container' . $padding_class . '" data-selector=".sm-portfolio" data-columns="' . esc_attr( $column_count ) . '" data-gutter="0" data-layout="masonry2" data-appear-animation="' . $appear_animation . '">';

	} else if( 'masonry3' == $style ) {

		echo '<div class="sm-portfolio-grid clearfix sm-isotope-container' . $padding_class . '" data-selector=".sm-portfolio" data-columns="' . esc_attr( $column_count ) . '" data-gutter="0" data-layout="masonry" data-appear-animation="' . $appear_animation . '">';

	} else {

		echo '<div class="sm-portfolio-grid clearfix sm-isotope-container' . $padding_class . '" data-selector=".sm-portfolio" data-columns="' . esc_attr( $column_count ) . '" data-gutter="0" data-layout="fitRows" data-appear-animation="' . $appear_animation . '">';

	}

	while( $query->have_posts() ): $query->the_post();

		get_template_part( 'templates/portfolio/' . $style . '/content' );

	endwhile;

	echo '</div>';

	

	if( $pagination_type == 'loadmore' ) {

		sm_ajax_pagination( $query, "templates/portfolio/{$style}/content", false, false );

	} else if( $pagination_type == 'infinitescroll' ) {

		sm_ajax_pagination( $query, "templates/portfolio/{$style}/content", false, true );

	} else if( $pagination_type == 'pagination' ) {

		crf_pagination( $query->max_num_pages );

	}



	if( $disable_padding != 'true' ) {

		echo '</div>';

	}

}

if( $categories ) {

	unset( $sm_pf_categories );

}

echo '</div>';