<?php

extract( shortcode_atts( array(

	'style' => '',

	'title' => '',

	'value' => '50',

	'units' => '',

	'color' => '',

	'custom_color' => '',

	'text_color' => '',

	'back_color' => '',

	'head_color' => '',

	'label_value' => '',

	'el_class' => '',

	'css_animation' => '',

	'animation_delay' => '',

), $atts ) );



wp_enqueue_script( 'sm_pie' );

$css_class = array( 'sm_pie_chart', 'sm_content_element' );



$id = sm_shortcode_unique_id( 'sm_pie_chart' );

$css_gen = new Inline_CSS_Generator( "sm_pie_chart", $id );



$style = sm_validate_with_array( $style, sm_get_pie_chart_styles_array() );

$css_class[] = $style;

if ( empty( $head_color ) ) {

	$head_color = sm_get_pie_chart_default_value( $style, 'head_color' );

}

$back_thickness = sm_get_pie_chart_default_value( $style, 'back_thickness' );



$color = sm_validate_with_array( $color, sm_get_preset_colors_array( false, false ) );



if ( 'custom' != $color ) {

	$color_code = sm_get_color_code_by_name( $color );

	$css_class[] = $color;

} else {

	$color_code = $custom_color;

}

$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$scoped_css = '';

if ( !empty( $back_color ) ) {

	$scoped_css .= $css_gen->css( '.sm_pie_chart_back', array( 'border-color' => $back_color ) );

}

if ( !empty( $text_color ) ) {

	$scoped_css .= $css_gen->css( array( '.sm_pie_chart_heading', '.sm_pie_chart_value' ), array( 'color' => $text_color ) );

}



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$wrapper_attributes[] = 'data-pie-value="' . esc_attr( $value ) . '"';

$wrapper_attributes[] = 'data-pie-label-value="' . esc_attr( $label_value ) . '"';

$wrapper_attributes[] = 'data-pie-units="' . esc_attr( $units ) . '"';

$wrapper_attributes[] = 'data-pie-color="' . esc_attr( $color_code ) . '"';

$wrapper_attributes[] = 'data-head-color="' . esc_attr( $head_color ) . '"';

$wrapper_attributes[] = 'data-back-thickness="' . esc_attr( $back_thickness ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

	<div class="sm_pie_wrapper">

		<span class="sm_pie_chart_back"></span>

		<span class="sm_pie_chart_value"></span>

		<canvas width="101" height="101"></canvas>

	</div>

	<?php if ( $title != '' ) : ?>

		<h4 class="sm_pie_chart_heading"><?php echo esc_html( $title ); ?></h4>

	<?php endif; ?>

</div>

