<?php

$output = $title = $interval = $el_class = '';

extract( shortcode_atts( array(

	'title' => '',

	'interval' => 0,

	'el_class' => '',

	'circle_text_color' => '',

	'circle_bg_color' => '',

	'section_title_color' => '',

	'section_bg_color' => '',

), $atts ) );



$id = sm_shortcode_unique_id( 'sm-pageable-container' );

$element = 'sm-pageable-container';



$css_class = array( $element, 'sm_content_element' );

$css_gen = new Inline_CSS_Generator( $element, $id );

$scoped_css = '';



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_extra_class( $el_class );



if ( !empty( $circle_text_color ) ) {

	$scoped_css .= $css_gen->css( '.pc-circle-wrap span', array( 'color' => $circle_text_color ) );

}

if ( !empty( $circle_bg_color ) ) {

	$scoped_css .= $css_gen->css( '.pc-circle-wrap span', array( 'background-color' => $circle_bg_color ) );

	$scoped_css .= $css_gen->css( 

		array( '.pc-circle-wrap', '.carousel-control', '.sm_tabs_nav li:before', '.sm_tabs_nav li:after' ), 

		array( 'border-color' => $circle_bg_color ) 

	);

}

if ( !empty( $section_title_color ) ) {

	$scoped_css .= $css_gen->css( '.pc-title', array( 'color' => $circle_text_color ) );

}

if ( !empty( $section_bg_color ) ) {

	$scoped_css .= $css_gen->css( 

		array( '.pc-nav-item-wrap:hover', '.sm-panel-wrap', '.ui-state-active .pc-nav-item-wrap' ), 

		array( 'background-color' => $section_bg_color ) 

	);

}



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

//$wrapper_attributes[] = 'data-interval="' . esc_attr( $interval ) . '"';



wp_enqueue_script( 'sm-jquery-ui-tabs' );

wp_enqueue_script( 'sm-jquery-ui-tabs-rotate' );

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

	<div class="sm_tabs_wrapper ui-tabs clearfix">

		<?php echo sm_widget_title( array( 'title' => $title, 'extraclass' => $element . '_heading' ) ); ?>

		<div class="sm-pc-nav-wrap">

			<ul class="sm_tabs_nav ui-tabs-nav">

			<?php

			preg_match_all( '/sm_tab([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );

			$tab_titles = array();

			// Extract tab titles

			if ( isset( $matches[1] ) ) {

				$tab_titles = $matches[1];

			}

			$idx = 0;

			$tab_count = count( $tab_titles );

			foreach ( $tab_titles as $tab ) :

				$tab_atts = shortcode_parse_atts( $tab[0] );

				if ( isset( $tab_atts['title'] ) ) :

					$hash = '#tab-' . ( isset( $tab_atts['tab_id'] ) ? esc_attr( $tab_atts['tab_id'] ) : sanitize_title( $tab_atts['title'] ) );

					$icon = sm_get_icon_from_atts( $tab_atts, true );

					++ $idx;

					if ( empty( $icon ) ) :

						$circle_content = $idx;

					else:

						$circle_content = '<i class="tab-icon ' . $icon . '"></i>';

					endif;

					$li_class = array();

					if ( 1 == $idx ) $li_class[] = 'first-nav';

					if ( $tab_count == $idx ) $li_class[] = 'last-nav';

			?>

				<li<?php if ( !empty( $li_class ) ) : echo ' class="' . implode( ' ', $li_class ) . '"'; endif; ?>>

					<div class="pc-nav-item-wrap">

						<a href="<?php echo esc_url( $hash ); ?>" class="ui-tabs-anchor">

							<div class="pc-circle-wrap"><span><?php echo sm_do_kses( $circle_content ); ?></span></div>

							<div class="pc-title"><?php echo esc_html( $tab_atts['title'] ); ?></div>

						</a>

					</div>

				</li>

			<?php

				endif;

			endforeach;

			?>

			</ul>

			<div class="arrow-controls">

				<a class="carousel-control prev" href="javascript:;"></a>

				<a class="carousel-control next" href="javascript:;"></a>

			</div>

		</div>

		<div class="sm-panel-wrap">

			<?php

			echo sm_js_remove_wpautop( $content );

			?>

		</div>

	</div>

</div>