<?php
add_filter( 'style_loader_tag', 'sm_filter_multiscroll_style', 10, 2 );
wp_enqueue_style( 'multiscroll' );
wp_enqueue_script( 'multiscroll' );

extract( shortcode_atts( array(
	'bullet_shape' => '',
	'bullet_color' => '',
	'left_section_width' => '',
	'el_class' => '',
), $atts ) );

$css_class = 'sm-multi-scroll';
$css_class .= sm_get_extra_class( $el_class );

$scoped_css = '';
$css_gen = new Inline_CSS_Generator( '', 'multiscroll-nav' );

$bullet_shape = sm_validate_with_array( $bullet_shape, sm_get_nav_bullet_shapes_array() );
if ( 'sm-bullet-shape-round' == $bullet_shape ) {
	$scoped_css .= $css_gen->css( 'li a span', 
		array( 
			'border-radius' => '50%',
			'-webkit-border-radius' => '50%',
			'-moz-border-radius' => '50%',
		) 
	);
}
if ( $bullet_color != '' ) {
	$scoped_css .= $css_gen->css( 'li a span', array( 'background-color' => $bullet_color ) );
}
if( !empty( $left_section_width ) && ( $left_section_width > 0 && $left_section_width < 100 ) ) {
	$css_gen_ms = new Inline_CSS_Generator( 'sm-multi-scroll', '' );
	$scoped_css .= $css_gen_ms->css( '.sm-multi-scroll-left-side',
		array(
			'width' => intval( $left_section_width ) . '% !important',
		)
	);
	$scoped_css .= $css_gen_ms -> css( '.sm-multi-scroll-right-side',
		array(
			//'width' => 'calc(' . ( 100 - floatval( $left_section_width ) ) . '% + 1px) !important',
			'width' => ( 100.0 - floatval( $left_section_width ) + 0.2 ) . '% !important',
		)
	);
}
?>
<div class="<?php echo esc_attr( $css_class ) ?>">
	<?php sm_the_scoped_css( $scoped_css ); ?>
	<?php echo sm_js_remove_wpautop( $content ); ?>
</div>