<?php

extract( shortcode_atts( array(

	'title' => 'Message Title',

	'style' => '',

	'type' => '',

	'size' => '',

	'color' => '',

	'el_class' => '',

), $atts ) );

$css_class = array( 'sm_content_element', 'sm_message_box' );

$style = sm_validate_with_array( $style, sm_get_message_styles_array() );

$css_class[] = $style;



$size = sm_validate_with_array( $size, sm_get_message_sizes_array() );

$css_class[] = $size;



$type = sm_validate_with_array( $type, sm_get_message_types_array() );

if ( 'custom' == $type ) {

	$color = sm_validate_with_array( $color, sm_get_message_colors_array() );

	$css_class[] = $color;

	$icon = sm_get_icon_from_atts( $atts, true );

} else {

	$css_class[] = $type;

	$icon = sm_get_message_icon_by_type( $type );

}



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_extra_class( $el_class );





if ( empty( $icon ) ) $icon = 'fa fa-bell';



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<div class="sm_message_box-icon"><i class="<?php echo esc_attr( $icon ); ?>"></i></div>

	<?php if ( !empty( $title ) ) : ?>

	<div class="sm_message_box-title">

		<?php echo esc_html( $title ); ?>

	</div>

	<?php endif; ?>

	<div class="sm_message_box-content">

		<?php echo sm_do_kses( $content ); ?>

	</div>

	<a href="javascript:;" class="sm_message_box-close"><i class="fa fa-close"></i></a>

</div>