<?php

/*

 * @var $id

 * @var $scoped_css

 * @var $classes

 * @var $images

 * @var $items

 * @var $autoplay

 * @var $show_nav

 * @var $show_bullets_nav

 * @var $lightbox

 */



$image_ids = explode( ',', $images );





$css_class = array( 'sm-image-carousel', 'sm_content_element', 'clearfix', $classes );

$css_class = implode( ' ', $css_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$wrapper_attributes[] = 'data-items="' . esc_attr( $items ) . '"';

if ( !empty( $autoplay ) )

	$wrapper_attributes[] = 'data-autoplay="' . esc_attr( $autoplay ) . '"';

if ( 'yes' == $show_nav ) {

	$wrapper_attributes[] = 'data-show-nav="true"';

}

if ( 'yes' == $show_bullets_nav ) {

	$wrapper_attributes[] = 'data-show-bullets="true"';

}

if ( 'yes' == $lightbox ) {

	$lightbox_id = sm_shortcode_unique_id( 'sm-image-carousel-lightbox' );

}

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

	<div class="container">

		<div class="sm-image-carousel-inner">

			<ul><?php

		

			foreach( $image_ids as $image_id ) :

				$image_url = wp_get_attachment_url( $image_id );

				$image_title = get_the_title( $image_id );

				$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

				if ( empty( $image_alt ) ) $image_alt = $image_title;

				$item_tag = '<img src="' . esc_url( $image_url ) . '" alt="' . esc_attr( $image_alt ) . '" title="' . esc_attr( $image_title ) .'" />';

				if ( 'yes' == $lightbox ) {

					$item_tag = '<a href="' . $image_url . '" class="sm-prettyphoto" data-rel="prettyPhoto[' . $lightbox_id . ']">' . $item_tag . '</a>';

				}

				$item_tag = '<li class="item">' . $item_tag . '</li>';

				echo ( $item_tag );

			endforeach;



			?></ul>

		</div>

		<?php if ( 'yes' == $show_nav ) : ?>

		<div class="arrow-controls">

			<a class="carousel-control prev" href="javascript:;"></a>

			<a class="carousel-control next" href="javascript:;"></a>

		</div>

		<?php endif; ?>

	</div>

	<?php if ( 'yes' == $show_bullets_nav ) : ?>

	<div class="bullet-controls"></div>

	<?php endif; ?>

</div>