<?php

extract( shortcode_atts( array(

	'type' => '',

	'height' => '',

	'zoom' => '14',

	'scrollwheel' => '',

	'scale_ctrl' => 'yes',

	'zoom_pan_ctrl' => 'yes',

	'pin_animation' => '',

	'popup' => 'yes',

	'overlay_color' => '',

	'marker' => '',

	'marker_anchor' => '',

	'infobox_style' => '',

	'infobox_position' => 'top',

	'infobox_bg_color' => '',

	'infobox_text_color' => '',

	'addresses' => '',

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => ''

), $atts ) );



$id = uniqid( 'sm_google_map_' ); // generate a unique ID for this map

$css_gen = new Inline_CSS_Generator( "sm-google-map", $id );



$css_class = array( 'sm-google-map', 'sm_content_element' );

$scoped_css = '';



$type = sm_validate_with_array( $type, sm_get_map_type_array() );

$zoom = sm_validate_with_array( $zoom, sm_get_map_zoom_levels_array() );

$infobox_style = sm_validate_with_array( $infobox_style, sm_get_map_infobox_styles_array() );

$infobox_position = sm_validate_with_array( $infobox_position, sm_get_map_infobox_positions_array() );



$addresses = sm_param_group_parse_atts( $addresses );

$cached_addresses = get_option( 'sm_map_addresses' );

if ( !empty( $marker ) ) 

	$marker = wp_get_attachment_thumb_url( $marker );



$map_style = ( !empty( $marker ) || !empty( $overlay_color ) || !empty( $marker ) || 'custom' == $infobox_style ) ? 'custom' : 'default';



foreach ( $addresses as $key => $addr ) {

	if ( empty( $addr['address'] ) ) continue;

	

	$addresses[$key]['coordinates'] = false;

	$addresses[$key]['cache'] = false;



	if ( !empty( $addr['marker'] ) ) {

		$addresses[$key]['marker'] = wp_get_attachment_thumb_url( $addr['marker'] );

		$map_style = 'custom';

	} else if ( !empty( $marker ) ) {

		$addresses[$key]['marker'] = $marker;

		$addresses[$key]['marker_anchor'] = $marker_anchor;

	}

	

	$infobox_content = !empty( $addr['infobox_content'] ) ? $addr['infobox_content'] : '';

	$addresses[$key]['infobox_content'] = nl2br( $infobox_content );

	if ( !empty( $addr['infobox_image'] ) ) {

		$addresses[$key]['infobox_image'] = wp_get_attachment_thumb_url( $addr['infobox_image'] );

	}

	if( strpos( $addr['address'], strtolower( 'latlng=' ) ) !== false ) {

		$addresses[$key]['address'] = str_replace( 'latlng=', '', $addr['address'] );

		$latLng = explode(',', $addresses[$key]['address']);

		$addresses[$key]['coordinates'] = true;

		$addresses[$key]['latitude'] = $latLng[0];

		$addresses[$key]['longitude'] = $latLng[1];

		$addresses[$key]['cache'] = false;



		if( isset( $cached_addresses[ trim( $addresses[$key]['latitude'] . ',' . $addresses[$key]['longitude'] ) ] ) ) {

			$addresses[$key]['geocoded_address'] = $cached_addresses[ trim( $addresses[$key]['latitude'] . ',' . $addresses[$key]['longitude'] ) ]['address'];

			$addresses[$key]['cache'] = true;

		}

	} else {

		$addresses[$key]['coordinates'] = false;

		$addresses[$key]['cache'] = false;



		if( isset( $cached_addresses[ trim( $addresses[$key]['address'] ) ] ) ) {

			$addresses[$key]['latitude'] = $cached_addresses[ trim( $addresses[$key]['address'] ) ]['latitude'];

			$addresses[$key]['longitude'] = $cached_addresses[ trim( $addresses[$key]['address'] ) ]['longitude'];

			$addresses[$key]['cache'] = true;					

		}

	}

}



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( !empty( $height ) ) {

	$height = sm_validate_length_unit( $height );

	$wrapper_attributes[] = 'style="padding-top:' . $height . '"';

}

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



if ( wp_script_is( 'google-maps-api', 'registered' ) ) {

	wp_print_scripts( 'google-maps-api' );

}

if ( wp_script_is( 'google-maps-infobox', 'registered' ) ) {

	wp_print_scripts( 'google-maps-infobox' );

}

if ( wp_script_is( 'sm-gmaps', 'registered' ) ) {

	wp_print_scripts( 'sm-gmaps' );

}



?>



<script type="text/javascript">

	function sm_init_map_<?php echo esc_attr( $id ); ?>() {

		jQuery('#<?php echo $id ; ?>').sm_gmaps({

			addresses: <?php echo json_encode( $addresses ); ?>,

			animations: <?php echo ( 'yes' == $pin_animation ) ? 'true' : 'false'; ?>,

			infobox_background_color: '<?php echo esc_attr( $infobox_bg_color ); ?>',

			infobox_styling: '<?php echo esc_attr( $infobox_style ); ?>',

			infobox_text_color: '<?php echo esc_attr( $infobox_text_color ); ?>',

			map_style: '<?php echo esc_attr( $map_style ); ?>',

			map_type: '<?php echo esc_attr( $type ); ?>',

			infobox_position: '<?php echo esc_attr( $infobox_position ); ?>',

			//marker_icon: '<?php // echo esc_attr( $marker ); ?>',

			overlay_color: '<?php echo esc_attr( $overlay_color ); ?>',

			overlay_color_hsl: <?php echo json_encode( sm_hex2hsl( $overlay_color ) ); ?>,

			pan_control: <?php echo ( 'yes' == $zoom_pan_ctrl ) ? 'true' : 'false'; ?>,

			show_address: <?php echo ( 'yes' == $popup ) ? 'true' : 'false'; ?>,

			scale_control: <?php echo ( 'yes' == $scale_ctrl ) ? 'true' : 'false'; ?>,

			scrollwheel: <?php echo ( 'yes' == $scrollwheel ) ? 'true' : 'false'; ?>,

			zoom: <?php echo esc_attr( $zoom ); ?>,

			zoom_control: <?php echo ( 'yes' == $zoom_pan_ctrl ) ? 'true' : 'false'; ?>,

		});

	}



	google.maps.event.addDomListener( window, 'load', sm_init_map_<?php echo esc_attr( $id ); ?> );

</script>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

</div>