<?php

extract( shortcode_atts( array(

	'title' => '',

	'title_tag' => '',

	'icon_source' => '',

	'icon_image' => '',

	'icon_pos' => '',

	'icon_size' => '',

	'icon_color_style' => '',

	'icon_wrap_style' => '',

	'icon_wrap_border_width' => '',

	'link' => '',

	'link_caption' => esc_html__( 'Learn More', 'semona-extension' ),

	'link_open_new' => '',

	'icon_color' => '',

	'icon_custom_color' => '',

	'icon_bg_color_style' => '',

	'icon_bg_color' => '',

	'icon_custom_bg_color' => '',

	'icon_outline_color' => '',

	'icon_custom_outline_color' => '',

	'icon_border_color' => 'sm-bg-color', // IMPORTANT ! Don't change.

	'icon_custom_border_color' => '',

	'heading_color' => '',

	'text_color' => '',

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => ''

), $atts ) );



$id = sm_shortcode_unique_id( 'sm_featurebox' );

$css_gen = new Inline_CSS_Generator( "sm-featurebox", $id );



$css_class = array( 'sm-featurebox', 'sm_content_element' );

$scoped_css = '';



$icon_source = sm_validate_with_array( $icon_source, sm_featurebox_icon_sources_array() );

$icon_class = array( 'icon-wrap' );

$icon_wrapper_class = array( 'featurebox-icon' );

$border_overlay_class = array( 'border-overlay' );



// Icon Color

$icon_color_style = sm_validate_with_array( $icon_color_style, sm_get_featurebox_color_styles_array() );

if ( 'sm-style-def-grad1' == $icon_color_style || 'sm-style-def-grad2' == $icon_color_style ) {

	$icon_class[] = $icon_color_style;

} else {

	$icon_color = sm_validate_with_array( $icon_color, sm_get_preset_colors_array() );

	if ( !empty( $icon_color ) ) $icon_class[] = $icon_color;

	if ( 'custom' == $icon_color ) {

		$scoped_css .= $css_gen->css( '.featurebox-icon .icon-wrap', array( 'color' => $icon_custom_color ) );

	}

}



$icon_wrap_style = sm_validate_with_array( $icon_wrap_style, sm_get_featurebox_icon_wrap_styles_array() );



if ( !empty( $icon_wrap_style ) ) $css_class[] = $icon_wrap_style;



if ( 'sm-wrap-solid-circle' == $icon_wrap_style ) {

	// Icon Background Color

	$icon_bg_color_style = sm_validate_with_array( $icon_bg_color_style, sm_get_featurebox_color_styles_array() );

	if ( 'sm-style-def-grad1' == $icon_bg_color_style || 'sm-style-def-grad2' == $icon_bg_color_style ) {

		$icon_wrapper_class[] = $icon_bg_color_style;

	} else {

		$icon_bg_color = sm_validate_with_array( $icon_bg_color, sm_get_preset_bg_colors_array( true ) );

		if ( !empty( $icon_bg_color ) ) $icon_wrapper_class[] = $icon_bg_color;

		if ( 'custom' == $icon_bg_color ) {

			$scoped_css .= $css_gen->css( '.featurebox-icon', array( 'background-color' => $icon_custom_bg_color ) );

			$scoped_css .= $css_gen->css( '.featurebox-icon .icon-wrap:after', 

				array( 

					'-moz-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

					'-webkit-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

					'box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

				) 

			);

		}

	}

} else if ( 'sm-wrap-outlined-circle' == $icon_wrap_style ) {

	$icon_wrap_border_width = sm_validate_with_array( $icon_wrap_border_width, sm_get_featurebox_border_width_array() );

	$css_class[] = $icon_wrap_border_width;

	$icon_outline_color = sm_validate_with_array( $icon_outline_color, sm_get_preset_border_colors_array() );

	if ( !empty( $icon_outline_color ) ) $icon_wrapper_class[] = $icon_outline_color;

	if ( 'custom' == $icon_outline_color ) {

		$scoped_css .= $css_gen->css( '.featurebox-icon', array( 'border-color' => $icon_custom_outline_color ) );

		$scoped_css .= $css_gen->css( '.featurebox-icon .icon-wrap:after', 

			array( 

				'-moz-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_outline_color,

				'-webkit-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_outline_color,

				'box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_outline_color,

			) 

		);

	}

} else if ( 'sm-wrap-double-circle' == $icon_wrap_style ) {



	$icon_border_color = sm_validate_with_array( $icon_border_color, sm_get_preset_bg_colors_array( true ) );

	if ( !empty( $icon_border_color ) ) $border_overlay_class[] = $icon_border_color;

	if ( 'custom' == $icon_border_color ) {

		$scoped_css .= $css_gen->css( '.border-overlay', array( 'border-color' => $icon_custom_border_color ) );

	}



	$icon_bg_color_style = sm_validate_with_array( $icon_bg_color_style, sm_get_featurebox_color_styles_array() );

	if ( 'sm-style-def-grad1' == $icon_bg_color_style || 'sm-style-def-grad2' == $icon_bg_color_style ) {

		$icon_wrapper_class[] = $icon_bg_color_style;

	} else {

		$icon_bg_color = sm_validate_with_array( $icon_bg_color, sm_get_preset_bg_colors_array( true ) );

		if ( !empty( $icon_bg_color ) ) $icon_wrapper_class[] = $icon_bg_color;

		if ( 'custom' == $icon_bg_color ) {

			$scoped_css .= $css_gen->css( '.featurebox-icon', array( 'background-color' => $icon_custom_bg_color ) );

			$scoped_css .= $css_gen->css( '.featurebox-icon .icon-wrap:after', 

				array( 

					'-moz-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

					'-webkit-box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

					'box-shadow' => '0 0 0 2px rgba(255,255,255,0), 0 0 0 4px ' . $icon_custom_bg_color,

				) 

			);

		}

	}

}





$icon_pos = sm_validate_with_array( $icon_pos, sm_get_featurebox_icon_pos_array() );

$css_class[] = $icon_pos;



$icon_size = sm_validate_with_array( $icon_size, sm_get_featurebox_icon_sizes_array() );

if ( $icon_size != '' ) {

	$scoped_css .= $css_gen->css( '.featurebox-icon', array( 'font-size' => $icon_size ) );

	if ( $icon_wrap_style != '' ) {

		$wrapper_size = $icon_size * 2.25;

		$scoped_css .= $css_gen->css( '.featurebox-icon .icon-wrap', array( 

			'width' => $wrapper_size . 'px',

			'height' => $wrapper_size . 'px',

			'line-height' => $wrapper_size . 'px'

		) );

		if ( 'sm-icon-left' == $icon_pos ) {

			$scoped_css .= $css_gen->css( 

				array( '.featurebox-title', '.featurebox-content', '.featurebox-link' ), 

				array( 'margin-left' => $icon_size * 2.5 + 20 . 'px' ) );

		} else if ( 'sm-icon-right' == $icon_pos ) {

			$scoped_css .= $css_gen->css( 

				array( '.featurebox-title', '.featurebox-content', '.featurebox-link' ), 

				array( 'margin-right' => $icon_size * 2.5 + 20 . 'px' ) );

		}

	} else {

		if ( 'sm-icon-left' == $icon_pos ) {

			$scoped_css .= $css_gen->css( 

				array( '.featurebox-title', '.featurebox-content', '.featurebox-link' ), 

				array( 'margin-left' => $icon_size + 20 . 'px' ) );

		} else if ( 'sm-icon-right' == $icon_pos ) {

			$scoped_css .= $css_gen->css( 

				array( '.featurebox-title', '.featurebox-content', '.featurebox-link' ), 

				array( 'margin-right' => $icon_size + 20 . 'px' ) );

		}

	}

}



if ( !empty( $heading_color ) ) {

	$scoped_css .= $css_gen->css( '.featurebox-title', array( 'color' => $heading_color ) );

}

if ( !empty( $text_color ) ) {

	$scoped_css .= $css_gen->css( '.featurebox-content', array( 'color' => $text_color ) );

}

$icon_html = '';

if ( 'font' == $icon_source ) {

	$icon = sm_get_icon_from_atts( $atts );

	$icon_html = '<i class="' . esc_attr( $icon ) . '"></i>';

} else {

	$icon_class[] = 'sm-icon-image';

	$icon_image = wp_get_attachment_url( $icon_image );

	if ( $icon_image )

		$icon_html = '<img src="' . $icon_image . '" alt="' . $title . '" />';

}



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$icon_wrapper_class = implode( ' ', $icon_wrapper_class );

$icon_class = implode( ' ', $icon_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

<?php if ( !empty( $icon_html ) ) : ?>

	<div class="<?php echo esc_attr( $icon_wrapper_class ); ?>"><div class="<?php echo esc_attr( $icon_class ); ?>"><?php echo ( $icon_html ); ?></div><?php 

		if ( 'sm-wrap-double-circle' == $icon_wrap_style ):

		?><div class="<?php echo implode( ' ', $border_overlay_class ); ?>"></div><?php

		endif;

	?></div>

<?php endif; ?>

<?php if ( !empty( $title ) ) : ?>

	<?php if ( empty( $title_tag ) ): ?>

	<h3 class="featurebox-title default"><?php echo esc_html( $title ); ?></h3>

	<?php else : ?>

	<<?php echo esc_attr( $title_tag ); ?> class="featurebox-title"><?php echo esc_html( $title ); ?></<?php echo esc_attr( $title_tag ); ?>>

	<?php endif; ?>

<?php endif; ?>

<?php if ( !empty( $content ) ): ?><div class="featurebox-content"><?php echo wpautop( $content ); ?></div><?php endif; ?>

<?php if ( !empty( $link ) ): ?><div class="featurebox-link"><a href="<?php echo esc_url( $link ); ?>"<?php if ( 'true' == $link_open_new ) : ?> target="_blank"<?php endif; ?>><?php echo esc_html( $link_caption ); ?><i class="fa fa-caret-right"></i></a></div><?php endif; ?>

</div>