<?php



extract ( shortcode_atts ( array (

	'heading_tag' => 'h2',

	'align' => '',

	'font_style' => '',

	'font_size' => '',

	'uppercase' => '',

	'italic' => '',

	'text_color' => '',

	'icon_color' => '',

	'letter_spacing' => '',

	'underline' => 'yes',

	'underline_width' => '',

	'underline_color' => '',

	'midline' => '',

	'midline_width' => '',

	'midline_thickness' => '',

	'midline_color' => '',

	'css' => '',

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => '', 

), $atts ) );



$icon = sm_get_icon_from_atts( $atts, true );



$css_class = array( 'sm-custom-heading' );

if ( $align != '' ) $css_class[] = $align;

$font_style = sm_validate_with_array( $font_style, sm_get_font_weight_array() );

if ( !empty( $font_style ) )

	$css_class[] = $font_style;

if ( 'yes' == $uppercase ) $css_class[] = 'uppercase';

if ( 'yes' == $underline ) $css_class[] = 'sm-underline';

if ( 'yes' == $midline ) $css_class[] = 'sm-midline';



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$id = sm_shortcode_unique_id( "sm-custom-heading" );

$css_gen = new Inline_CSS_Generator( "sm-custom-heading", $id );



if ( !$heading_tag ) {

	$heading_tag = 'h2';

}



$scoped_css = '';

$custom_values = array();



$letter_spacing = sm_validate_with_array( $letter_spacing, sm_get_letter_spacings_array() );

$font_size = sm_validate_with_array( $font_size, sm_get_custom_heading_font_sizes_array() );

if ( $text_color ) {

	$custom_values['color'] = $text_color;

}

if( !empty( $letter_spacing ) ) {

	$custom_values['letter-spacing'] = $letter_spacing;

}

if ( !empty( $font_size ) ) {

	$custom_values['font-size'] = $font_size;

}

if ( 'yes' == $italic ) {

	$custom_values['font-style'] = 'italic';

}



if ( !empty( $custom_values ) ) {

	$scoped_css .= $css_gen->css( '.heading', $custom_values );

}





$midline_css = array();

$underline_css = array();



if ( !empty( $underline_width ) ) {

	$underline_width = sm_validate_length_unit( $underline_width );

	$underline_css['width'] = $underline_width;

}

if ( !empty( $midline_width ) ) {

	$midline_width = sm_validate_length_unit( $midline_width );

	$midline_css['width'] = $midline_width;

}



$icon_html = '';



if ( !empty( $icon ) ) {

	$icon_html = '<i class="' . $icon . '"></i>';

}

if( !empty( $icon_color ) ) {

	$scoped_css .= $css_gen->css( '.heading i', array( 'color' => $icon_color ) );

}

if( !empty( $underline_color ) ) {

	$underline_css['border-color'] = $underline_color;

}

if( !empty( $midline_color ) ) {

	$midline_css['border-color'] = $midline_color;

}



if ( !empty( $underline_thickness ) ) {

	$midline_css['border-width'] = $underline_thickness;

}

if ( !empty( $midline_thickness ) ) {

	$midline_css['border-width'] = $midline_thickness;

}



if ( !empty( $underline_css ) ) {

	$scoped_css .= $css_gen->css( '.heading:after', $underline_css );

}



if ( !empty( $midline_css ) ) {

	$scoped_css .= $css_gen->css( '.heading:before', $midline_css );

}



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

	<?php echo '<' . $heading_tag . ' class="heading">' . $icon_html . sm_do_kses( $content ) .'</' . $heading_tag . '>'; ?>

</div>

