<?php

extract ( shortcode_atts ( 

	array_merge( array (

		'field' => '',

		'value' => '',

		'field_color' => '',

		'value_color_style' => '',

		'value_color' => '',

		'border_color' => '',

		'css_animation' => '',

		'animation_delay' => '',

		'el_class' => '',

	), sm_get_bg_shortcode_atts()

), $atts ) );



$css_class = 'sm-contact-info';

$value_class = array( 'value' );

if ( !empty( $field_color ) ) {

	$field_css = 'color:' . $field_color;

}





$id = sm_shortcode_unique_id( 'sm_contact_info' );

$css_gen = new Inline_CSS_Generator( "sm-contact-info", $id );



$scoped_css = '';



if( !empty( $field_color ) ) {

	$scoped_css .= $css_gen->css( '.field', array( 'color' => $field_color ) );

}



$value_color_style = sm_validate_with_array( $value_color_style, sm_get_contact_info_color_styles_array() );

if ( 'sm-style-solid' == $value_color_style ) {

	if ( !empty( $value_color ) ) {

		$scoped_css .= $css_gen->css( '.value', array( 'color' => $value_color ) );

	}

} else {

	$value_class[] = $value_color_style;

}



if ( !empty( $border_color ) ) {

	$scoped_css .= $css_gen->css_with_self_condition( ':not(:last-child)', '', array( 'border-bottom-color' => $border_color ) );

}



$value_class = implode( ' ', $value_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

	<?php sm_the_scoped_css( $scoped_css ); ?>

	<span class="field"><?php echo sm_do_kses( $field ); ?></span><!--

	--><span class="<?php echo esc_attr( $value_class ); ?>"><?php echo crf_do_kses( $value ); ?></span>

</div>