<?php

extract ( shortcode_atts ( 

	array_merge( array (

		'heading' => esc_html__( 'Heading Text', 'semona-extension' ),

		'sub_heading' => '',

		'btn_style' => '',

		'btn_pos' => '',

		'btn_label' => '',

		'btn_link' => '',

		'uppercase' => '',

		'open_new' => '',

		'css_animation' => '',

		'animation_delay' => '',

		'el_class' => '', 

	), sm_get_bg_shortcode_atts()

), $atts ) );



$bg_url = '';

if ( !empty( $bg_img ) ) {

	$bg_url = wp_get_attachment_image_src( $bg_img, 'full' );

	if ( $bg_url !== false ) $bg_url = $bg_url[0];

}



$id = sm_shortcode_unique_id( "sm-callout" );

$css_class = array( 'sm-callout', 'sm_content_element', 'clearfix' );

$scoped_css = '';



if ( 'sm-style-gradient' == $bg_style ) {

	if ( $grad_color1 != 'custom' ) {

		$custom_grad_color1 = sm_get_color_code_by_name( $grad_color1 );

	}

	if ( $grad_color2 != 'custom' ) {

		$custom_grad_color2 = sm_get_color_code_by_name( $grad_color2 );

	}



	$angle = intval( $angle );



	$scoped_css .= '#' . $id . '.sm-callout{';

	$scoped_css .= sm_get_bg_img_gradient_css( $custom_grad_color1, $custom_grad_color2, $angle, $bg_url);

	$scoped_css .= '}';

} else if ( 'sm-style-def-grad1' == $bg_style || 'sm-style-def-grad2' == $bg_style ) {

	$css_class[] = $bg_style;

} else {

	$css_parts = '';

	if ( $bg_color == 'custom' ) {

		$css_parts .= 'background-color:' . $custom_bg_color .';';

	} else {

		$css_class[] = $bg_color;

	}

	$css_parts .= sm_get_bg_img_css( $bg_url );

	if ( $css_parts != '' ) {

		$scoped_css .= '#' . $id . '.sm-callout{' . $css_parts . '}';

	}

}



$uppercase = ( 'yes' == $uppercase ) ? ' uppercase' : '';

$btn_pos = sm_validate_with_array( $btn_pos, sm_get_callout_btn_pos_array() );

if ( $btn_pos != '' ) $css_class[] = $btn_pos;



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$btn_style = sm_validate_with_array( $btn_style, sm_get_callout_btn_styles_array() );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';



$button_attributes = array();

$button_attributes[] = 'style="' . $btn_style . '"';

$button_attributes[] = 'uppercase="true"';

$button_attributes[] = 'link="'. esc_url( $btn_link ) . '"';

if ( 'sm-style-outline' == $btn_style ) {

	$button_attributes[] = 'color="sm-white"';

	$button_attributes[] = 'border_width="sm-border-thick"';

}

if ( 'true' == $open_new ) $button_attributes[] = 'open_new="true"';

?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

	<div class="container">

		<div class="callout-wrap">

			<div class="callout-content">

				<div class="heading<?php echo esc_attr( $uppercase ); ?>"><?php echo esc_html( $heading ); ?></div>

				<?php if ( $sub_heading != '' ) : ?> <div class="sub-heading<?php echo esc_attr( $uppercase ); ?>"><?php echo esc_html( $sub_heading ); ?></div><?php endif; ?>

			</div>

			<?php if ( $btn_pos != '' ) : ?>

				<div class="callout-button">

					<?php echo do_shortcode('[sm_button ' . implode( ' ', $button_attributes ) . ']' . esc_html( $btn_label ) . '[/sm_button]'); ?>

				</div>

			<?php endif; ?>

		</div>

	</div>

</div>