<?php

extract ( shortcode_atts ( array (

	'link' => '',

	'shape' => '',

	'size' => '',

	'style' => 'sm-style-modern',

	'color' => '',

	'custom_color' => '',

	'grad_color1' => '',

	'custom_grad_color1' => '',

	'grad_color2' => '',

	'custom_grad_color2' => '',

	'text_color' => '',

	'align' => '',

	'open_new' => '',

	'border_width' => 'sm-border-thin',

	'i_align' => 'left',

	'angle' => '0',

	'translucent' => false,

	'uppercase' => false,

	'css_animation' => '',

	'animation_delay' => '',

	'el_class' => ''

), $atts ) );



$icon = sm_get_icon_from_atts( $atts, true );



$css_class = array( 'sm-button' );

$scoped_css = '';

$id = sm_shortcode_unique_id( "sm-button" );

$css_gen = new Inline_CSS_Generator( "sm-button", $id );



$shape = sm_validate_with_array( $shape, sm_get_button_shapes_array() );

if ( !empty( $shape ) ) $css_class[] = $shape;



$size = sm_validate_with_array( $size, sm_get_button_sizes_array() );

if ( !empty ( $size ) ) $css_class[] = $size;



$style = sm_validate_with_array( $style, sm_get_button_styles_array() );



// Validate the preset color values.

$preset_colors = sm_get_preset_colors_array( true );



$color = sm_validate_with_array( $color, $preset_colors );



$css_class[] = $style;

if ( 'sm-style-gradient' == $style ) { // Gradient

	$grad_color1 = sm_validate_with_array( $grad_color1, $preset_colors );

	$grad_color2 = sm_validate_with_array( $grad_color2, $preset_colors );

	if ( $grad_color1 != 'custom' ) {

		$custom_grad_color1 = sm_get_color_code_by_name( $grad_color1 );

	}

	if ( $grad_color2 != 'custom' ) {

		$custom_grad_color2 = sm_get_color_code_by_name( $grad_color2 );

	}



	$angle = intval( $angle );



	$scoped_css .= '#' . $id . '.sm-button{';

	$scoped_css .= sm_get_bg_img_gradient_css( $custom_grad_color1, $custom_grad_color2, $angle);

	$scoped_css .= '}';

} else if ( 'sm-style-def-grad1' == $style || 'sm-style-def-grad2' == $style ) { 

	$css_class[] = $style;

} else { // Modern, Flat, 3d, Outline, Outline with BG

	if ( 'custom' == $color ) {

		if ( 'sm-style-outline' == $style ) { // Outline

			$scoped_css .= $css_gen->css( '', 

				array( 

					'color' => $custom_color,

					'border-color' => $custom_color,

					'background-color' => 'transparent'

				) 

			);



  			if ( '#fff' == $custom_color || '#ffffff' == $custom_color ) {

  				$hover_color = sm_get_color_code_by_name( 'sm-primary' );

  			} else {

  				$hover_color = '#fff';

  			}

  			$scoped_css .= $css_gen->css_with_self_condition( array('.sm-style-outline:hover', '.sm-style-outline:focus' ), '',

  				array(

  					'color' => $hover_color,

  					'border-color' => $custom_color,

  					'background-color' => $custom_color,

  				) 

  			);

  		} else if ( 'sm-style-white' == $style ) { // Outline with BG

  			$scoped_css .= $css_gen->css( '', array( 'color' => $custom_color ) );

  			$scoped_css .= $css_gen->css_with_self_condition( array( '.sm-style-white:hover', '.sm-style-white:focus' ), '', 

  				array( 

  					'background-color' => $custom_color,

  					'border-color' => $custom_color,

  					'color' => '#fff'

  				)

  			);

  		} else { // Flat, Modern, 3d



			$scoped_css .= $css_gen->css( '', 

				array(

					'color' => '#fff',

					'border-color' => $custom_color,

					'background-color' => $custom_color,

				)

			);



			$scoped_css .= $css_gen->css_with_self_condition( array(':hover', ':focus' ), '',

				array(

					'color' => $text_color,

					'border-color' => $custom_color,

					'background-color' => $custom_color,

				)

			);

			if ( 'sm-style-3d' == $style ) {

				$shadow_size = sm_get_button_3d_shadow_size( $size );

				$scoped_css .= $css_gen->css( '', array( 'box-shadow' => '0 ' . $shadow_size . 'px 0 ' . sm_change_hex_hsl( $custom_color, 0, 0, -11 ) ) );

			}

  		}

		$css_class[] = 'sm-custom';

	} else if ( !empty( $color ) ) {

		$css_class[] = $color;

	}



	if ( 'sm-style-outline' == $style ) {

		$border_width = sm_validate_with_array( $border_width, sm_get_button_border_widths_array() );

			$css_class[] = $border_width;

	} else if ( 'sm-style-white' == $style ) {

		if ( $translucent ) {

			$css_class[] = 'sm-translucent';

		}

	}

}

if ( !empty( $text_color ) ) {

	$scoped_css .= $css_gen->css( '', array( 'color' => $text_color ) );

}



$align = sm_validate_with_array( $align, sm_get_button_aligns_array() );



if ( $uppercase ) $css_class[] = 'uppercase';



$content = preg_replace( '/<\/?p\>/', '', $content );

$button_html = esc_html( $content );

if ( !empty( $icon ) ) {

	$css_class[] = 'sm-icon-' . $i_align;

	$icon_html = '<i class="sm-icon ' . esc_attr( $icon ) . '"></i>';



	if ( $i_align == 'right' ) {

		$button_html .= $icon_html;

	} else {

		$button_html = $icon_html . $button_html;

	}

}



if ( 'sm-full' == $align ) $css_class[] = 'sm-block';



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_css_animation( $css_animation );

$css_class .= sm_get_extra_class( $el_class );



$wrapper_attributes = array();



$button_tag = 'a';

if ( empty( $link ) ) {

	$button_tag = 'button';

} else {

	$wrapper_attributes[] = 'href="' . esc_url( $link ) . '"';

}



$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$wrapper_attributes[] = 'title="' . esc_attr( $content ) . '"';

if ( 'true' == $open_new ) $wrapper_attributes[] = 'target="_blank"';

if ( intval( $animation_delay ) > 0 ) {

	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );

}



?>

<?php if ( $align != '' ) : ?>

<div class="sm-button-container <?php echo esc_attr( $align ); ?>">

<?php endif; ?>

<?php sm_the_scoped_css( $scoped_css ); ?>

<<?php echo esc_attr( $button_tag ); ?> <?php echo implode( ' ', $wrapper_attributes ); ?>><?php echo ( $button_html ); ?></<?php echo esc_attr( $button_tag ); ?>>

<?php if ( $align != '' ) : ?>

</div>

<?php endif; ?>

