<?php

wp_enqueue_style( 'wp-mediaelement' );

wp_enqueue_script( 'wp-mediaelement' );



extract( shortcode_atts( array(

	'style' => 'classic',

	'column_count' => '3',

	'per_page' => '',

	'pagination_type' => 'none',

	'categories' => false,

	'disable_bottom_border' => '',

	'el_class' => '',

), $atts ) );



$id = sm_shortcode_unique_id( "sm-sc-blog" );

$css_gen = new Inline_CSS_Generator( "sm-sc-blog", $id );

$classes = array();

$classes[] = 'sm-sc-blog';

$classes[] = 'sm_content_element';



if( $style == 'classic' ) {

	$pagination_type = 'pagination';

}



$query_args = array();

if( $per_page ) {

	$query_args['posts_per_page'] = $per_page;

}

$query_args['post_status'] = array( 'publish', 'private' );

if( $categories ) {

	$query_args['category__in'] = explode( ',', $categories );

}

$query_args['has_password'] = false;

$query_args['ignore_sticky_posts'] = true;

if( $pagination_type && $pagination_type == 'pagination' ) {

	if( is_front_page() || is_home() ) {

		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );

	} else {

		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

	}

	$query_args['paged'] = $paged;

}

$query = new WP_Query( $query_args );



$post_layout = $style;

if( $post_layout == 'masonry' ) {

	$post_layout = 'grid';

}



echo '<div class="' . esc_attr( implode( ' ', $classes ) ) . '" id="' . esc_attr( $id ) . '">';



$scoped_css = '';

if( $disable_bottom_border && $disable_bottom_border == 'yes' ) {

	$scoped_css .= $css_gen->css( '.sm-post', array(

			'border-bottom-style' => 'none',

	) );

}

if( $scoped_css ) {

	echo '<style scoped>';

	echo ( $scoped_css );

	echo '</style>';

}



if( $query->have_posts() ) {

	if ( $style == 'simple' ) {

		echo '<div class="sm-posts sm-posts-simple-style sm-posts-grid clearfix sm-isotope-container" data-selector=".sm-post:not(.sticky)" data-columns="' . esc_attr( $column_count ) . '" data-gutter="30" data-layout="fitRows">';

	}

	else if ( $style == 'simple-list' ) {

		echo '<div class="sm-posts sm-posts-simple-list-style clearfix sm-isotope-container" data-selector=".sm-post:not(.sticky)" data-columns="1" data-gutter="0" data-layout="fitRows">';

	} else if( $style == 'modern' ) {

		echo '<div class="sm-posts sm-posts-modern-style clearfix" data-selector=".sm-post" data-columns="' . esc_attr( $column_count ) . '">';



		// global $post_index;

		// global $post_columns;

	

		// $post_index = 0;

		// $post_columns = $column_count;

	} else if( $style == 'grid' ) {

		echo '<div class="sm-posts sm-posts-grid clearfix sm-isotope-container" data-selector=".sm-post" data-columns="' . esc_attr( $column_count ) . '" data-gutter="30" data-layout="fitRows" data-appear-animation="true">';

	} else if( $style == 'masonry' ) {

		echo '<div class="sm-posts sm-posts-masonry clearfix sm-isotope-container" data-selector=".sm-post" data-columns="' . esc_attr( $column_count ) . '" data-gutter="30" data-layout="masonry" data-appear-animation="true">';

	} else {

		echo '<div class="sm-posts sm-posts-classic clearfix sm-isotope-container" data-selector=".sm-post" data-columns="1" data-gutter="0" data-layout="fitRows">';

	}

	while( $query->have_posts() ): $query->the_post();

		get_template_part( 'templates/blog/' . $post_layout . '/content', get_post_format() );

	endwhile;

	echo '</div>';

	

	if( $pagination_type == 'loadmore' ) {

		sm_ajax_pagination( $query, "templates/blog/{$post_layout}/content", true, false );

	} else if( $pagination_type == 'infinitescroll' ) {

		sm_ajax_pagination( $query, "templates/blog/{$post_layout}/content", true, true );

	} else if( $pagination_type == 'pagination' ) {

		crf_pagination( $query->max_num_pages );

	}

}



echo '</div>';