<?php

if ( ! class_exists( 'Featured_Post' ) ) {

	return;

}



extract( shortcode_atts( array(

	'max' => '5',	

	'categories' => false,

	'el_class' => '',

), $atts ) );



$query_args = array();

if( $max ) {

	$query_args['posts_per_page'] = $max;

}

$query_args['post_status'] = array( 'publish', 'private' );



if( $categories ) {

	$query_args['category__in'] = explode( ',', $categories );

}



$query_args['has_password'] = false;

$query_args['ignore_sticky_posts'] = true;

$query_args['paged'] = 1;

$query_args['featured'] = 'yes';

$query_args['tax_query'] = array(

	array(

		'taxonomy'	=> 'post_format',

		'field'		=> 'slug',

		'terms'		=> array(

			'post-format-video',

			'post-format-audio',

			'post-format-quote',

			'post-format-gallery',

		),

		'operator' => 'NOT IN'

	)

);



$query = new WP_Query( $query_args );



echo '<div class="sm-sc-blog-slider">';

echo '<div class="sm-sc-blog-slider-container sm-carousel" data-prev=".sm-sc-blog-slider-prev" data-next=".sm-sc-blog-slider-next">';



if( $query->have_posts() ) {

	while( $query->have_posts() ): $query->the_post();

		get_template_part( 'templates/blog/blog-slider/content' ); //, get_post_format() );

	endwhile;

}



wp_reset_postdata();

echo '</div>';

echo '<a href="#" class="sm-sc-blog-slider-prev"><i class="fa fa-chevron-left"></i></a><a href="#" class="sm-sc-blog-slider-next"><i class="fa fa-chevron-right"></i></a>';

echo '</div>';