<?php

wp_enqueue_script( 'jquery-ui-accordion' );

$output = $title = $interval = $el_class = $collapsible = $disable_keyboard = $active_tab = '';

//



extract( shortcode_atts( array(

	'title' => '',

	'interval' => 0,

	'el_class' => '',

	'collapsible' => 'no',

	'disable_keyboard' => 'no',

	'active_tab' => '1',

	'shape' => '',

	'style' => '',

	'header_border' => '',

	'content_border' => '',

	'header_bg_color' => 'sm-bg-color2',

	'header_custom_bg_color' => '',

	'header_text_color' => '',

	'active_header_bg_color' => '',

	'active_header_custom_bg_color' => '',

	'active_header_text_color' => '',

	'grad_angle' => '',

	'ctrl_style' => '',

	'ctrl_align' => '',



), $atts ) );



$id = sm_shortcode_unique_id( "sm_accordion" );

$css_gen = new Inline_CSS_Generator( "sm_accordion." . $id );



$css_class = array( 'sm_accordion', 'sm_content_element', 'clearfix', $id );

$scoped_css = '';



// shape

$shape = sm_validate_with_array( $shape, sm_get_accordion_tab_shapes_array() );

// style

$style = sm_validate_with_array( $style, sm_get_accordion_styles_array() );



$css_class[] = $shape;

// color

if ( 'sm-style-def-grad1' == $style || 'sm-style-def-grad2' == $style ) {

	$css_class[] = $style . '-active';

} else {

	$css_class[] = $style;

}

if ( 'sm-style-solid' == $style ) {

	$header_bg_color = sm_validate_with_array( $header_bg_color, sm_get_preset_bg_colors_array( true ) );

	if ( $header_bg_color != 'custom' ) {

		$css_class[] = $header_bg_color;

	} else {

		$scoped_css .= $css_gen->css( '.sm_accordion_header', array( 'background-color' => $header_custom_bg_color ) );

	}



	$active_header_bg_color = sm_validate_with_array( $active_header_bg_color, sm_get_preset_bg_colors_array( true ) );

	if ( $active_header_bg_color != 'custom' ) {

		$css_class[] = $active_header_bg_color . '-active';

	} else {

		$scoped_css .= $css_gen->css( '.sm_accordion_header.ui-state-active', array( 'background-color' => $active_header_custom_bg_color ) );

	}

}

if ( !empty( $header_text_color ) ) {

	$scoped_css .= $css_gen->css( '.sm_accordion_header a', array( 'color' => $header_text_color ) );

	$scoped_css .= $css_gen->css( '.sm_accordion_header .ui-accordion-header-icon', array( 'color' => $header_text_color ) );

	$scoped_css .= $css_gen->css( 

		array(

			'.sm_accordion_header .ui-accordion-header-icon:before', 

			'.sm_accordion_header .ui-accordion-header-icon:after', 

		),

		array( 'background-color' => $header_text_color ) 

	);

}

if ( !empty( $active_header_text_color ) ) {

	$scoped_css .= $css_gen->css( '.sm_accordion_header.ui-state-active a', array( 'color' => $active_header_text_color ) );

	$scoped_css .= $css_gen->css( '.sm_accordion_header.ui-state-active .ui-accordion-header-icon', array( 'color' => $active_header_text_color ) );

	$scoped_css .= $css_gen->css( 

		array(

			'.sm_accordion_header.ui-state-active .ui-accordion-header-icon:before', 

			'.sm_accordion_header.ui-state-active .ui-accordion-header-icon:after', 

		),

		array( 'background-color' => $active_header_text_color ) 

	);

}



if ( 'yes' == $header_border ) {

	$css_class[] = 'sm-header-border';

}

if ( 'yes' == $content_border ) {

	$css_class[] = 'sm-content-border';

}

$ctrl_style = sm_validate_with_array( $ctrl_style, sm_get_accordion_ctrl_styles_array() );

if ( !empty( $ctrl_style ) ) {

	$css_class[] = $ctrl_style;

}



$ctrl_align = sm_validate_with_array( $ctrl_align, sm_get_accordion_ctrl_aligns_array() );

if ( !empty( $ctrl_align ) ) {

	$css_class[] = $ctrl_align;

}



$css_class = implode( ' ', $css_class );

$css_class .= sm_get_extra_class( $el_class );



$wrapper_attributes = array();

$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

//$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$wrapper_attributes[] = 'data-collapsible="' . esc_attr( $collapsible ) . '"';

$wrapper_attributes[] = 'data-sm-disable-keydown="' . esc_attr( ( 'yes' == $disable_keyboard ? 'true' : 'false' ) ) . '"';

$wrapper_attributes[] = 'data-active-tab="' . esc_attr( $active_tab ) . '"';



?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

<?php sm_the_scoped_css( $scoped_css ); ?>

	<div class="sm_wrapper sm_accordion_wrapper ui-accordion">

		<?php 

		echo sm_widget_title( array( 'title' => $title, 'extraclass' => 'sm_accordion_heading' ) );

		echo sm_js_remove_wpautop( $content );

		?>

	</div>

</div>