<?php



/*============================

 * Common Helper Functions 

 *============================

 */





/* Color functions */



function sm_hex2rgb( $hex ) {

	$hex = str_replace( "#", "", $hex );



	if( strlen( $hex ) == 3 ) {

		$r = hexdec( substr( $hex, 0, 1 ).substr($hex, 0, 1 ) );

		$g = hexdec( substr( $hex, 1, 1).substr( $hex, 1, 1 ) );

		$b = hexdec( substr( $hex, 2, 1).substr( $hex, 2, 1 ) );

	} else {

		$r = hexdec( substr( $hex, 0, 2 ) );

		$g = hexdec( substr( $hex, 2, 2 ) ) ;

		$b = hexdec( substr( $hex, 4, 2 ) );

	}



	return array( $r, $g, $b );

}



function sm_color_add( $hex1, $hex2 ) {

	$rgb1 = sm_hex2rgb( $hex1 );

	$rgb2 = sm_hex2rgb( $hex2 );

	$rgb = array();



	for ( $i=0; $i<3; $i++ )

	{

		$rgb[$i] = $rgb1[$i] + $rgb2[$i];

		if ( $rgb[$i] > 255 ) $rgb[$i] = 255;

	}



	return sprintf( '#%02x%02x%02x', $rgb[0], $rgb[1], $rgb[2]);

}



function sm_color_minus( $hex1, $hex2 ) {

	$rgb1 = sm_hex2rgb( $hex1 );

	$rgb2 = sm_hex2rgb( $hex2 );

	$rgb = array();



	for ( $i=0; $i<3; $i++ )

	{

		$rgb[$i] = $rgb1[$i] - $rgb2[$i];

		if ( $rgb[$i] < 0 ) $rgb[$i] = 0;

	}



	return sprintf( '#%02x%02x%02x', $rgb[0], $rgb[1], $rgb[2]);

}



function sm_fadeout( $hex, $decrease ) {

	$percent = 100 - $decrease;

	$percent = ( ( $percent < 0 )? 0 : $percent ) / 100;

	$rgb = sm_hex2rgb( $hex );

	return sprintf( 'rgba(%d,%d,%d,%f)', $rgb[0], $rgb[1], $rgb[2], $percent );

}



function sm_hex2hsl( $HexColor )

{

	$HexColor    = str_replace( '#', '', $HexColor );

	if( strlen( $HexColor ) < 3 ) str_pad( $HexColor, 3 - strlen( $HexColor ), '0' );

	$Add         = strlen( $HexColor ) == 6 ? 2 : 1;

	$AA          = 0;

	$AddOn       = $Add == 1 ? ( $AA = 16 - 1 ) + 1 : 1;

	$Red         = round( ( hexdec( substr( $HexColor, 0, $Add ) ) * $AddOn + $AA ) / 255, 6 );

	$Green       = round( ( hexdec( substr( $HexColor, $Add, $Add ) ) * $AddOn + $AA ) / 255, 6 );

	$Blue        = round( ( hexdec( substr( $HexColor, ( $Add + $Add ) , $Add ) ) * $AddOn + $AA ) / 255, 6 );



	$HSLColor    = array( 'Hue' => 0, 'Saturation' => 0, 'Luminance' => 0 );

	$Minimum     = min( $Red, $Green, $Blue );

	$Maximum     = max( $Red, $Green, $Blue );

	$Chroma      = $Maximum - $Minimum;



	$HSLColor['Luminance'] = ( $Minimum + $Maximum ) / 2;

	if( $Chroma == 0 )

	{

		$HSLColor['Luminance'] = round( $HSLColor['Luminance'] * 100, 0 );

		return $HSLColor;

	}



	$Range = $Chroma * 6;



	$HSLColor['Saturation'] = $HSLColor['Luminance'] <= 0.5 ? $Chroma / ( $HSLColor['Luminance'] * 2 ) : $Chroma / ( 2 - ( $HSLColor['Luminance'] * 2 ) );

	if( $Red <= 0.004 || $Green <= 0.004 || $Blue <= 0.004 )

		$HSLColor['Saturation'] = 1;



	if( $Maximum == $Red )

	{

		$HSLColor['Hue'] = round( ( $Blue > $Green ? 1 - ( abs( $Green - $Blue ) / $Range ) : ( $Green - $Blue ) / $Range ) * 360, 0 );

	}

	else if( $Maximum == $Green )

	{

		$HSLColor['Hue'] = round( ( $Red > $Blue ? abs( 1 - ( 4 / 3 ) + ( abs ( $Blue - $Red ) / $Range ) ) : ( 1 / 3 ) + ( $Blue - $Red ) / $Range ) * 360, 0 );

	}

	else

	{

		$HSLColor['Hue'] = round( ( $Green < $Red ? 1 - 2 / 3 + abs( $Red - $Green ) / $Range : 2 / 3 + ( $Red - $Green ) / $Range ) * 360, 0 );

	}

	$HSLColor['Saturation'] = round( $HSLColor['Saturation'] * 100, 0 );

	$HSLColor['Luminance']  = round( $HSLColor['Luminance'] * 100, 0 );

	return $HSLColor;

}





function sm_hsl2hex( $HSLColor )

{

	$RGBColor    = array( 'Red' => 0, 'Green' => 0, 'Blue' => 0 );

	foreach( $HSLColor as $Name => $Value )

	{

		if( $Name == 'Hue' ) {

			$Value = round( round( (int)str_replace( '%', '', $Value ) / 360, 2 ) * 255, 0 );

		} else {

			$Value = round( round( (int)str_replace( '%', '', $Value ) / 100, 2 ) * 255, 0 );

		}



		$Value    = (int)$Value * 1;

		$Value    = $Value > 255 ? 255 : ( $Value < 0 ? 0 : $Value );

		$ValuePct = round( $Value / 255, 6 );



		$$Name = $ValuePct;

	}

	$RGBColor['Red']   = $Luminance;

	$RGBColor['Green'] = $Luminance;

	$RGBColor['Blue']  = $Luminance;



	$Radial  = $Luminance <= 0.5 ? $Luminance * ( 1.0 + $Saturation ) : $Luminance + $Saturation - ( $Luminance * $Saturation );



	if( $Radial > 0 )

	{

		$Ma   = $Luminance + ( $Luminance - $Radial );

		$Sv   = round( ( $Radial - $Ma ) / $Radial, 6 );

		$Th   = $Hue * 6;

		$Wg   = floor( $Th );

		$Fr   = $Th - $Wg;

		$Vs   = $Radial * $Sv * $Fr;

		$Mb   = $Ma + $Vs;

		$Mc   = $Radial - $Vs;



		// Color is between yellow and green

		if ($Wg == 1)

		{

			$RGBColor['Red']   = $Mc;

			$RGBColor['Green'] = $Radial;

			$RGBColor['Blue']  = $Ma;

		}

		// Color is between green and cyan

		else if( $Wg == 2 )

		{

			$RGBColor['Red']   = $Ma;

			$RGBColor['Green'] = $Radial;

			$RGBColor['Blue']  = $Mb;

		}



		// Color is between cyan and blue

		else if( $Wg == 3 )

		{

			$RGBColor['Red']   = $Ma;

			$RGBColor['Green'] = $Mc;

			$RGBColor['Blue']  = $Radial;

		}



		// Color is between blue and magenta

		else if( $Wg == 4 )

		{

			$RGBColor['Red']   = $Mb;

			$RGBColor['Green'] = $Ma;

			$RGBColor['Blue']  = $Radial;

		}



		// Color is between magenta and red

		else if( $Wg == 5 )

		{

			$RGBColor['Red']   = $Radial;

			$RGBColor['Green'] = $Ma;

			$RGBColor['Blue']  = $Mc;

		}



		// Color is between red and yellow or is black

		else

		{

			$RGBColor['Red']   = $Radial;

			$RGBColor['Green'] = $Mb;

			$RGBColor['Blue']  = $Ma;

		}

	}



	$RGBColor['Red']   = ($C = round( $RGBColor['Red'] * 255, 0 )) < 15 ? '0'.dechex( $C ) : dechex( $C );

	$RGBColor['Green'] = ($C = round( $RGBColor['Green'] * 255, 0 )) < 15 ? '0'.dechex( $C ) : dechex( $C );

	$RGBColor['Blue']  = ($C = round( $RGBColor['Blue'] * 255, 0 )) < 15 ? '0'.dechex( $C ) : dechex( $C );



	return '#' . $RGBColor['Red'].$RGBColor['Green'].$RGBColor['Blue'];

}



function sm_change_hex_hsl( $hex, $h, $s, $l ) {

	$hsl = sm_hex2hsl( $hex );

	$hsl['Hue'] += $h;

	$hsl['Hue'] = ( $hsl['Hue'] < 0 )? 0 : $hsl['Hue'];

	$hsl['Hue'] = ( $hsl['Hue'] > 360 )? 360 : $hsl['Hue'];

	$hsl['Saturation'] += $s;

	$hsl['Saturation'] = ( $hsl['Saturation'] < 0 )? 0 : $hsl['Saturation'];

	$hsl['Saturation'] = ( $hsl['Saturation'] > 100 )? 100 : $hsl['Saturation'];

	$hsl['Luminance'] += $l;

	$hsl['Luminance'] = ( $hsl['Luminance'] < 0 )? 0 : $hsl['Luminance'];

	$hsl['Luminance'] = ( $hsl['Luminance'] > 100 )? 100 : $hsl['Luminance'];

	return sm_hsl2hex( $hsl );

}



/* 

 * Render Template file.

 */

function sm_render_view($template_name, $view_variables = array(), $return = true) {

	extract($view_variables, EXTR_REFS);



	$file_path = SM_SHORTCODE_TEMPLATE_PATH . $template_name . '.php';



	unset($view_variables);



	if ($return) {

		ob_start();



		require $file_path;



		return ob_get_clean();

	} else {

		require $file_path;

	}

}



function sm_css_animation_class( $param_name = 'css_animation', $heading = '' ) {

	if( $heading == '' ) {

		$heading = esc_html__( 'CSS Animation', 'semona-extension' );

	}

	return array (

		'type' => 'dropdown',

		'heading' => $heading,

		'param_name' => $param_name,

		'admin_label' => true,

		'value' => array (

			esc_html__( 'None', 'semona-extension' ) => '',

			esc_html__( 'bounce', 'semona-extension' ) => 'bounce',

			esc_html__( 'flash', 'semona-extension' ) => 'flash',

			esc_html__( 'pulse', 'semona-extension' ) => 'pulse',

			esc_html__( 'rubberBand', 'semona-extension' ) => 'rubberBand',

			esc_html__( 'shake', 'semona-extension' ) => 'shake',

			esc_html__( 'swing', 'semona-extension' ) => 'swing',

			esc_html__( 'tada', 'semona-extension' ) => 'tada',

			esc_html__( 'wobble', 'semona-extension' ) => 'wobble',

			esc_html__( 'jello', 'semona-extension' ) => 'jello',

			esc_html__( 'bounceIn', 'semona-extension' ) => 'bounceIn',

			esc_html__( 'bounceInDown', 'semona-extension' ) => 'bounceInDown',

			esc_html__( 'bounceInLeft', 'semona-extension' ) => 'bounceInLeft',

			esc_html__( 'bounceInRight', 'semona-extension' ) => 'bounceInRight',

			esc_html__( 'bounceInUp', 'semona-extension' ) => 'bounceInUp',

			esc_html__( 'bounceOut', 'semona-extension' ) => 'bounceOut',

			esc_html__( 'bounceOutDown', 'semona-extension' ) => 'bounceOutDown',

			esc_html__( 'bounceOutLeft', 'semona-extension' ) => 'bounceOutLeft',

			esc_html__( 'bounceOutRight', 'semona-extension' ) => 'bounceOutRight',

			esc_html__( 'bounceOutUp', 'semona-extension' ) => 'bounceOutUp',

			esc_html__( 'fadeIn', 'semona-extension' ) => 'fadeIn',

			esc_html__( 'fadeInDown', 'semona-extension' ) => 'fadeInDown',

			esc_html__( 'fadeInDownBig', 'semona-extension' ) => 'fadeInDownBig',

			esc_html__( 'fadeInLeft', 'semona-extension' ) => 'fadeInLeft',

			esc_html__( 'fadeInLeftBig', 'semona-extension' ) => 'fadeInLeftBig',

			esc_html__( 'fadeInRight', 'semona-extension' ) => 'fadeInRight',

			esc_html__( 'fadeInRightBig', 'semona-extension' ) => 'fadeInRightBig',

			esc_html__( 'fadeInUp', 'semona-extension' ) => 'fadeInUp',

			esc_html__( 'fadeInUpBig', 'semona-extension' ) => 'fadeInUpBig',

			esc_html__( 'fadeOut', 'semona-extension' ) => 'fadeOut',

			esc_html__( 'fadeOutDown', 'semona-extension' ) => 'fadeOutDown',

			esc_html__( 'fadeOutDownBig', 'semona-extension' ) => 'fadeOutDownBig',

			esc_html__( 'fadeOutLeft', 'semona-extension' ) => 'fadeOutLeft',

			esc_html__( 'fadeOutLeftBig', 'semona-extension' ) => 'fadeOutLeftBig',

			esc_html__( 'fadeOutRight', 'semona-extension' ) => 'fadeOutRight',

			esc_html__( 'fadeOutRightBig', 'semona-extension' ) => 'fadeOutRightBig',

			esc_html__( 'fadeOutUp', 'semona-extension' ) => 'fadeOutUp',

			esc_html__( 'fadeOutUpBig', 'semona-extension' ) => 'fadeOutUpBig',

			esc_html__( 'flip', 'semona-extension' ) => 'flip',

			esc_html__( 'flipInX', 'semona-extension' ) => 'flipInX',

			esc_html__( 'flipInY', 'semona-extension' ) => 'flipInY',

			esc_html__( 'flipOutX', 'semona-extension' ) => 'flipOutX',

			esc_html__( 'flipOutY', 'semona-extension' ) => 'flipOutY',

			esc_html__( 'lightSpeedIn', 'semona-extension' ) => 'lightSpeedIn',

			esc_html__( 'lightSpeedOut', 'semona-extension' ) => 'lightSpeedOut',

			esc_html__( 'rotateIn', 'semona-extension' ) => 'rotateIn',

			esc_html__( 'rotateInDownLeft', 'semona-extension' ) => 'rotateInDownLeft',

			esc_html__( 'rotateInDownRight', 'semona-extension' ) => 'rotateInDownRight',

			esc_html__( 'rotateInUpLeft', 'semona-extension' ) => 'rotateInUpLeft',

			esc_html__( 'rotateInUpRight', 'semona-extension' ) => 'rotateInUpRight',

			esc_html__( 'rotateOut', 'semona-extension' ) => 'rotateOut',

			esc_html__( 'rotateOutDownLeft', 'semona-extension' ) => 'rotateOutDownLeft',

			esc_html__( 'rotateOutDownRight', 'semona-extension' ) => 'rotateOutDownRight',

			esc_html__( 'rotateOutUpLeft', 'semona-extension' ) => 'rotateOutUpLeft',

			esc_html__( 'rotateOutUpRight', 'semona-extension' ) => 'rotateOutUpRight',

			esc_html__( 'slideInUp', 'semona-extension' ) => 'slideInUp',

			esc_html__( 'slideInDown', 'semona-extension' ) => 'slideInDown',

			esc_html__( 'slideInLeft', 'semona-extension' ) => 'slideInLeft',

			esc_html__( 'slideInRight', 'semona-extension' ) => 'slideInRight',

			esc_html__( 'slideOutUp', 'semona-extension' ) => 'slideOutUp',

			esc_html__( 'slideOutDown', 'semona-extension' ) => 'slideOutDown',

			esc_html__( 'slideOutLeft', 'semona-extension' ) => 'slideOutLeft',

			esc_html__( 'slideOutRight', 'semona-extension' ) => 'slideOutRight',

			esc_html__( 'zoomIn', 'semona-extension' ) => 'zoomIn',

			esc_html__( 'zoomInDown', 'semona-extension' ) => 'zoomInDown',

			esc_html__( 'zoomInLeft', 'semona-extension' ) => 'zoomInLeft',

			esc_html__( 'zoomInRight', 'semona-extension' ) => 'zoomInRight',

			esc_html__( 'zoomInUp', 'semona-extension' ) => 'zoomInUp',

			esc_html__( 'zoomOut', 'semona-extension' ) => 'zoomOut',

			esc_html__( 'zoomOutDown', 'semona-extension' ) => 'zoomOutDown',

			esc_html__( 'zoomOutLeft', 'semona-extension' ) => 'zoomOutLeft',

			esc_html__( 'zoomOutRight', 'semona-extension' ) => 'zoomOutRight',

			esc_html__( 'zoomOutUp', 'semona-extension' ) => 'zoomOutUp',

			esc_html__( 'hinge', 'semona-extension' ) => 'hinge',

			esc_html__( 'rollIn', 'semona-extension' ) => 'rollIn',

			esc_html__( 'rollOut', 'semona-extension' ) => 'rollOut',

		),

		'description' => esc_html__( 'Select type of animation for element to be animated when it \'enters\' the browsers viewport (only in modern browsers).', 'semona-extension' ),

	);

}



function sm_css_animation_delay( $dep_el = 'css_animation', $param_name = 'animation_delay', $heading = '' ) {

	if( $heading == '' ) {

		$heading = esc_html__( 'Animation Delay', 'semona-extension' );

	}



	return array (

		'type' => 'textfield',

		'heading' => $heading,

		'param_name' => $param_name,

		'description' => esc_html__( 'Specify Animation Delay in milliseconds. (Rule of Thumb: Less than 1000 ms)' ),

		'dependency' => array(

			'element' => $dep_el,

			'not_empty' => true,

		)

	);

}



function sm_get_animation_delay_attribute( $animation_delay ) {

	return 'data-wow-delay="' . floatval( $animation_delay ) / 1000 . 's"';

}



function sm_ago( $time ) {

	$periods = array (

			esc_html__( 'second', 'semona-extension' ),

			esc_html__( 'minute', 'semona-extension' ),

			esc_html__( 'hour', 'semona-extension' ),

			esc_html__( 'day', 'semona-extension' ),

			esc_html__( 'week', 'semona-extension' ),

			esc_html__( 'month', 'semona-extension' ),

			esc_html__( 'year', 'semona-extension' ),

			esc_html__( 'decade', 'semona-extension' ) 

	);

	$periods_plural = array (

			esc_html__( 'seconds', 'semona-extension' ),

			esc_html__( 'minutes', 'semona-extension' ),

			esc_html__( 'hours', 'semona-extension' ),

			esc_html__( 'days', 'semona-extension' ),

			esc_html__( 'weeks', 'semona-extension' ),

			esc_html__( 'months', 'semona-extension' ),

			esc_html__( 'years', 'semona-extension' ),

			esc_html__( 'decades', 'semona-extension' ) 

	);

	$lengths = array (

			'60',

			'60',

			'24',

			'7',

			'4.35',

			'12',

			'10' 

	);

	$now = time ();

	$difference = $now - $time;

	$tense = esc_html__( 'ago', 'semona-extension' );

	$prefix = esc_html__( 'about', 'semona-extension' );

	

	for($j = 0; $difference >= $lengths [$j] && $j < count ( $lengths ) - 1; $j ++) {

		$difference /= $lengths [$j];

	}

	

	$difference = round ( $difference );

	

	if ($difference != 1) {

		$periods [$j] = $periods_plural [$j];

	}

	

	return sprintf ( '%s %s %s %s', $prefix, $difference, $periods [$j], $tense );

}



function sm_get_css_animation( $css_animation ) {

	if( $css_animation != '' ) {

		return ' wow ' . $css_animation;

	} else {

		return '';

	}

}



function sm_extra_class( $group = false ) {

	$extra = array (

		'type' => 'textfield',

		'heading' => esc_html__( 'Extra class name', 'semona-extension' ),

		'param_name' => 'el_class',

		'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'semona-extension' )

	);

	if ( $group ) {

		$extra ['group'] = $group;

	}

	return $extra;

}



function sm_get_extra_class( $el_class ) {

	$output = '';

	if ( $el_class != '' ) {

		$output = ' ' . str_replace( '.', '', $el_class );

	}



	return $output;

}



/*

 * Get CSS Editor Box Option

 */

function sm_css_box_option() {

	return array(

		'type' => 'css_editor',

		'heading' => esc_html__( 'CSS box', 'semona-extension' ),

		'param_name' => 'css',

		// 'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'semona-extension' ),

		'group' => esc_html__( 'Design Options', 'semona-extension' )

	);

}



function sm_background_clip_option() {

	return array (

		'type' => 'dropdown',

		'heading' => __( 'Background Clip', 'polar-extension' ),

		'param_name' => 'bg_clip',

		'value' => sm_get_background_clip_values_array(),

		'description' => __( 'Choose background fill area.', 'polar-extension' ),

		'group' => __( 'Design Options', 'js_composer' ) 

	);

}



function sm_get_background_clip_values_array() {

	return array(

		esc_html__( 'Entire Area (Content, Padding, Border)', 'polar-extension' ) => 'sm-border-box',

		esc_html__( 'Content, Padding Area', 'polar-extension' ) => 'sm-padding-box',

		esc_html__( 'Content Area Only', 'polar-extension' ) => 'sm-content-box',

	);

}



function sm_param_group_parse_atts( $atts_string ) {

	$array = json_decode( urldecode( $atts_string ), true );

	return $array;

}



function sm_js_remove_wpautop( $content, $autop = false ) {



	if ( $autop ) {

		$content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );

	}



	return do_shortcode( shortcode_unautop( $content ) );

}

function sm_do_kses( $string ) {

	return wp_kses( $string, array(

		'a' => array(

			'href' => array(),

			'title' => array()

		),

		'p' => array(

			'class' => array(),

			'style' => array(),

		),

		'br' => array(),

		'em' => array(),

		'strong' => array(),

		'i' => array(

			'class' => array(),

		),

		'ul' => array(

			'class' => array(),

		),

		'li' => array(),

		'span' => array(

			'class' => array(),

		),

	) );

}

function sm_shortcode_custom_css_class( $param_value, $prefix = '' ) {

	if ( function_exists( 'vc_shortcode_custom_css_class' ) ) {

		return vc_shortcode_custom_css_class( $param_value, $prefix );

	} else {

		$css_class = preg_match( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', $param_value ) ? $prefix . preg_replace( '/\s*\.([^\{]+)\s*\{\s*([^\}]+)\s*\}\s*/', '$1', $param_value ) : '';

		return $css_class;

	}

}



function sm_widget_title( $params = array( 'title' => '' ) ) {

	if ( $params['title'] == '' ) {

		return '';

	}



	$extraclass = ( isset( $params['extraclass'] ) ) ? ' ' . $params['extraclass'] : '';

	$output = '<h2 class="sm_heading' . $extraclass . '">' . $params['title'] . '</h2>';



	return apply_filters( 'sm_widget_title', $output, $params );

}



function sm_shortcode_unique_id( $shortcode_name ) {

	if (empty ( $GLOBALS ['crf_shortcode_counter'] ))

		$GLOBALS ['crf_shortcode_counter'] = 0;

	$GLOBALS ['crf_shortcode_counter'] ++;

	$id = $shortcode_name . '-' . $GLOBALS ['crf_shortcode_counter'];

	return $id;

}



function sm_the_scoped_css( $scoped_css ) {

	if ( $scoped_css != '' ) 

		echo '<style scoped>' . $scoped_css . '</style>';

}



/*

 * Get basic colors array

 */

function sm_get_basic_colors_array() {

	return array(

		esc_html__( 'Blue', 'semona-extension' ) => 'sm-blue',

		esc_html__( 'Orange', 'semona-extension' ) => 'sm-orange',

		esc_html__( 'Turquoise', 'semona-extension' ) => 'sm-turquoise',

		esc_html__( 'Purple', 'semona-extension' ) => 'sm-purple',

		esc_html__( 'Pink', 'semona-extension' ) => 'sm-pink',

		esc_html__( 'Green', 'semona-extension' ) => 'sm-green',

		esc_html__( 'Red', 'semona-extension' ) => 'sm-red',

		esc_html__( 'Yellow', 'semona-extension' ) => 'sm-yellow',

		esc_html__( 'Grey', 'semona-extension' ) => 'sm-grey',

	);

}

/*

 * Get preset colors array

 */

function sm_get_preset_colors_array( $include_default = true, $include_white = true, $include_custom = true ) {

	$ary = array_merge(

		array( esc_html__( 'Theme Primary Color', 'semona-extension' ) => 'sm-primary' ),

		sm_get_basic_colors_array()

	);

	if ( $include_default ) {

		$ary = array_merge( array( esc_html__( 'Default to Theme', 'semona-extension' ) => '' ), $ary );

	}

	if ( $include_white ) {

		$ary = array_merge( $ary, array( esc_html__( 'White', 'semona-extension' ) => 'sm-white' ) );

	}

	if ( $include_custom ) {

		$ary = array_merge( $ary, array( esc_html__( 'Custom Color', 'semona-extension' ) => 'custom' ) );

	}

	return $ary;

}



/*

 * Get preset background colors array

 */

function sm_get_preset_bg_colors_array( $include_custom = false ) {

	$ary = array_merge( 

		 array(

		 	esc_html__( 'Theme Primary Color', 'semona-extension' ) => 'sm-primary',

			esc_html__( 'Theme Background', 'semona-extension' ) => 'sm-bg-color',

			esc_html__( 'Theme Background 2', 'semona-extension' ) => 'sm-bg-color2'

		),

		sm_get_basic_colors_array()

	);

	if ( $include_custom ) $ary[__( 'Custom Color', 'semona-extension' )] = 'custom';

	return $ary;

}



/*

 * Get preset border colors array

 */

function sm_get_preset_border_colors_array( $include_custom = true ) {

	$ary = array_merge(

		array(

			esc_html__( 'Default Border Color', 'semona-extension' ) => '',

			esc_html__( 'Heading Underline Color', 'semona-extension' ) => 'sm-heading-underline',

			esc_html__( 'Primary Color', 'semona-extension' ) => 'sm-primary',

		),

		sm_get_basic_colors_array(),

		array(

			esc_html__( 'White', 'semona-extension' ) => 'sm-white'

		)

	);

	if ( $include_custom ) $ary[__( 'Custom Color', 'semona-extension' )] = 'custom';

	return $ary;

}



/*

 * Get design box preset background colors array

 */

function sm_get_design_box_preset_bg_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Primary Color', 'semona-extension' ) => 'primary-bg',

		esc_html__( 'Theme Background Color', 'semona-extension' ) => 'bg-color',

		esc_html__( 'Theme Background Color 2', 'semona-extension' ) => 'bg-color2',

	);

}



/*

 * Get design box preset background colors option

 */

function sm_bg_color_preset_option() {

	return array (

		'type' => 'dropdown',

		'heading' => esc_html__( 'Preset Background Color', 'semona-extension' ),

		'param_name' => 'bg_color_preset',

		'value' => sm_get_design_box_preset_bg_array(),

		'description' => esc_html__( 'Select preset background color from theme option values. To use this option, you must clear \'Background Color\' option in this tab.', 'semona-extension' ),

		'group' => esc_html__( 'Design Options', 'js_composer' ) 

	);

}



/*

 * Get light and dark color scheme array

 */

function sm_get_skins_array( $include_default = false ) {

	$ary = array(

		esc_html__( 'Light', 'semona-extension' ) => 'sm-theme-light',

		esc_html__( 'Dark', 'semona-extension' ) => 'sm-theme-dark'

	);

	if ( $include_default ) {

		return array_merge(

			array( esc_html__( 'Default', 'semona-extension' ) => '' ), 

			$ary

		);

	} else {

		return $ary;

	}

}



/*

 * Get Color code from preset name

 */

function sm_get_color_code_by_name( $color_name ) {

	$code_array = array(

		'sm-blue' => '#4396e6',

		'sm-orange' => '#f56048',

		'sm-turquoise' => '#15c0cc',

		'sm-purple' => '#e43dce',

		'sm-pink' => '#e9138c',

		'sm-green' => '#97c200',

		'sm-red' => '#f7383a',

		'sm-grey' => '#4c5866',

		'sm-yellow' => '#e5ae49',

		'sm-white' => '#ffffff',

		'sm-bg-color' => '#ffffff',

		'sm-bg-color2' => '#f8f8f8',

	);

	if ( $color_name == 'sm-primary' ) {

		if (function_exists( 'crf_get_theme_mod_value' ) ) {

			$color = crf_get_theme_mod_value( 'primary-color' );

		} else {

			$color = $code_array['sm-blue'];

		}

		return $color;

	} else if ( $color_name == 'sm-bg-color' || $color_name == 'sm-bg-color2' ) {

		if (function_exists( 'crf_get_theme_mod_value' ) ) {

			$color = crf_get_theme_mod_value( substr( $color_name, 3 ) );

		} else {

			$color = $code_array[$color_name];

		}

		return $color;

	} else if ( array_key_exists( $color_name, $code_array ) ) {

		return $code_array[$color_name];

	} else {

		return $code_array['sm-blue'];

	}

}





/*

 * Get Background CSS with Image and Gradient

 */

function sm_get_bg_img_gradient_css($grad_color1, $grad_color2, $angle = 0, $bg_url = '') {

	$css_style = '';

	if ( !empty( $bg_url ) ) {

		$bg_url = 'url(' . $bg_url . ')';

		$css_style .= 'background-image:' . $bg_url . ';';

		$bg_url .= ', ';

	}

	$angle = intval( $angle );

	$css_style .= 'background-image:' . $bg_url . ' -webkit-linear-gradient(' . ( $angle - 90 ) . 'deg, ' . $grad_color1 . ' 10%, ' . $grad_color2 . ' 90%);';

	$css_style .= 'background-image:' . $bg_url . ' -moz-linear-gradient(' . ( $angle - 90 ) . 'deg, ' . $grad_color1 . ' 10%, ' . $grad_color2 . ' 90%);';

	$css_style .= 'background-image:' . $bg_url . ' -o-linear-gradient(' . ( $angle - 90 ) . 'deg, ' . $grad_color1 . ' 10%, ' . $grad_color2 . ' 90%);';

	$css_style .= 'background-image:' . $bg_url . ' linear-gradient(' . $angle . 'deg, ' . $grad_color1 . ' 10%, ' . $grad_color2 . ' 90%);';

	$css_style .= 'background-position:center;background-repeat:no-repeat;background-size: cover;';

	return $css_style;

}

/*

 * Get Background CSS with Image and Color

 */

function sm_get_bg_img_css($bg_url) {

	$css_style = '';

	if ( !empty( $bg_url ) ) {

		$css_style .= 'background-image:url(' . $bg_url . ');';

		$css_style .= 'background-repeat:no-repeat;';

		$css_style .= 'background-position:center center;';

		$css_style .= 'background-size:cover;';

	}

	return $css_style;

}

/*

 * Checks if $value is in $array and if not, returns the first element.

 */

function sm_validate_with_array( $value, $array ) {

	if ( in_array( $value, $array ) ) {

		return $value;

	} else {

		return reset( $array );

	}

}



/*

 * Checks if $value is valid for measurement unit and corrects them.

 */

function sm_validate_length_unit( $value ) {

	$pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';

	// allowed metrics: http://www.w3schools.com/cssref/css_units.asp

	$regexr = preg_match( $pattern, $value, $matches );

	$retval = isset( $matches[1] ) ? (float) $matches[1] : 0;

	$unit = isset( $matches[2] ) ? $matches[2] : 'px';

	return $retval . $unit;

}



/*

 * Heading Tags Array

 */

function sm_get_heading_tags_array() {

	return array (

		esc_html__( 'Default', 'semona-extension' ) => '',

		esc_html__( 'H1', 'semona-extension' ) => 'h1',

		esc_html__( 'H2', 'semona-extension' ) => 'h2',

		esc_html__( 'H3', 'semona-extension' ) => 'h3',

		esc_html__( 'H4', 'semona-extension' ) => 'h4',

		esc_html__( 'H5', 'semona-extension' ) => 'h5',

		esc_html__( 'H6', 'semona-extension' ) => 'h6',

	);

}



/*

 * Default Alignment Array

 */

function sm_get_default_aligns_array() {

	return array(

		esc_html__( 'Left', 'semona-extension' ) => '',

		esc_html__( 'Center', 'semona-extension' ) => 'sm-center',

		esc_html__( 'Right', 'semona-extension' ) => 'sm-right'

	);

}



/*

 * Letter Spacing Array

 */

function sm_get_letter_spacings_array() {

	return array( 

		esc_html__( 'Default', 'semona-extension' ) => '',

		esc_html__( '1px', 'semona-extension' ) => '1px',

		esc_html__( '2px', 'semona-extension' ) => '2px',

		esc_html__( '3px', 'semona-extension' ) => '3px',

		esc_html__( '4px', 'semona-extension' ) => '4px',

		esc_html__( '5px', 'semona-extension' ) => '5px',

	);

}



/*

 * Supported Icon Types Array

 */

function sm_get_icon_types_array( $include_none = false ) {

	$icon_list = sm_get_icon_list();

	$ary = array();

	if ( $include_none ) {

		$ary[__( 'None', 'semona-extension' )] = '';

	}



	foreach( $icon_list as $value => $icons ) {

		$name = $icons['name'];

		$ary[$name] = $value;

	}

	return $ary;

}



function sm_get_icon_options_array( $group = '', $include_none = false, $dep = array() ) {

	$type_option = array(

		'type' => 'dropdown',

		'heading' => esc_html__( 'Icon Type', 'semona-extension' ),

		'param_name' => 'icon_type',

		'std' => '',

		'value' => sm_get_icon_types_array( $include_none ),

	);

	if ( $group != '' ) $type_option['group'] = $group;

	if ( !empty( $dep ) && is_array( $dep ) ) $type_option['dependency'] = $dep;

	$options_array = array( $type_option );

	$icon_list = sm_get_icon_list();

	foreach ($icon_list as $icon_type_key => $icon_info) {

		$std = '';

		if ( !empty( $icon_info['std'] ) ) $std = $icon_info['std'];

		$options_array[] = array(

			'type' => 'iconpicker',

			'heading' => esc_html__( $icon_info['name'], 'semona-extension' ),

			'param_name' => $icon_info['param_name'],

			'value' => $std,

			'settings' => array(

				'emptyIcon' => false,

				'iconsPerPage' => 200,

				'type' => $icon_type_key,

			),

			'dependency' => array(

				'element' => 'icon_type',

				'value' => $icon_type_key

			),

			'group' => $group

		);

	}

	return $options_array;

}



function sm_get_icon_from_atts( $atts, $include_none = false ) {



	$params_array = array( 'icon_type' => '' );

	extract( shortcode_atts( $params_array, $atts ) );

	$icon_type = sm_validate_with_array( $icon_type, sm_get_icon_types_array( $include_none ) );



	$icon_list = sm_get_icon_list();

	foreach ($icon_list as $icon_info) {

		$std = '';

		if ( !empty( $icon_info['std'] ) ) $std = $icon_info['std'];

		$params_array[ $icon_info['param_name'] ] = $std;

	}

	$params_array = shortcode_atts( $params_array, $atts );

	

	if ( !empty( $icon_type ) ) {

		wp_enqueue_style( $icon_list[$icon_type]['handle'] );

		$param_name = $icon_list[$icon_type]['param_name'];

		return $params_array[$param_name];

	} else {

		return '';

	}

}



/*

 * Default Background Styles Array

 */

function sm_get_background_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Default Gradient 1', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2', 'semona-extension' ) => 'sm-style-def-grad2',

		esc_html__( 'Custom Gradient', 'semona-extension' ) => 'sm-style-gradient',

	);

}



/*

 * Default Background Styles Array

 */

function sm_get_background_options_array( $prefix = '', $group = 'Background' ) {

	$dep_element = $prefix . 'bg_style';

	return array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Style', 'semona-extension' ),

			'description' => esc_html__( 'Select background style.', 'semona-extension' ),

			'param_name' => $dep_element,

			'value' => sm_get_background_styles_array(),

			'group' => esc_html__( $group, 'semona-extension' ),

		),



		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Background Color', 'semona-extension' ),

			'param_name' => $prefix . 'bg_color',

			'description' => esc_html__( 'Select background color.', 'semona-extension' ),

			'param_holder_class' => 'sm-preset-color-dropdown',

			'value' => sm_get_preset_colors_array( true ),

			'dependency' => array(

				'element' => $dep_element,

				'value' => array( 'sm-style-solid' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Background Color', 'semona-extension' ),

			'param_name' => $prefix . 'custom_bg_color',

			'description' => esc_html__( 'Select custom background color.', 'semona-extension' ),

			'dependency' => array(

				'element' => $prefix . 'bg_color',

				'value' => array( 'custom' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),



		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Gradient Color 1', 'semona-extension' ),

			'param_name' => $prefix . 'grad_color1',

			'description' => esc_html__( 'Select background gradient start color for the element.', 'semona-extension' ),

			'param_holder_class' => 'sm-preset-color-dropdown',

			'value' => sm_get_preset_colors_array( true ),

			'dependency' => array(

				'element' => $dep_element,

				'value' => array( 'sm-style-gradient' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Gradient Color 1', 'semona-extension' ),

			'param_name' => $prefix . 'custom_grad_color1',

			'description' => esc_html__( 'Select custom background gradient start color for the element.', 'semona-extension' ),

			'dependency' => array(

				'element' => $prefix . 'grad_color1',

				'value' => array( 'custom' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),



		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Gradient Color 2', 'semona-extension' ),

			'param_name' => $prefix . 'grad_color2',

			'description' => esc_html__( 'Select background gradient end color for the element.', 'semona-extension' ),

			'param_holder_class' => 'sm-preset-color-dropdown',

			'value' => sm_get_preset_colors_array( true ),

			'dependency' => array(

				'element' => $dep_element,

				'value' => array( 'sm-style-gradient' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Gradient Color 2', 'semona-extension' ),

			'param_name' => $prefix . 'custom_grad_color2',

			'description' => esc_html__( 'Select custom background gradient end color for the element', 'semona-extension' ),

			'dependency' => array(

				'element' => $prefix . 'grad_color2',

				'value' => array( 'custom' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Angle', 'semona-extension' ),

			'param_name' => $prefix . 'angle',

			'description' => esc_html__( 'Specify an angle between 0 - 360.', 'semona-extension' ),

			'dependency' => array(

				'element' => $dep_element,

				'value' => array( 'sm-style-gradient' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		),



		array (

			'type' => 'attach_image',

			'heading' => esc_html__( 'Background Image', 'semona-extension' ),

			'param_name' => $prefix . 'bg_img',

			'description' => esc_html__( 'Select a background image.', 'semona-extension' ),

			'dependency' => array(

				'element' => $dep_element,

				'value_not_equal_to' => array( 'sm-style-def-grad1', 'sm-style-def-grad2' )

			),

			'group' => esc_html__( $group, 'semona-extension' ),

		)

	);

}

/* 

 * Shortcode attributes for default background

 */

function sm_get_bg_shortcode_atts() {

	return array(

		'bg_style' => '',

		'bg_color' => '',

		'custom_bg_color' => '',

		'grad_color1' => '',

		'custom_grad_color1' => '',

		'grad_color2' => '',

		'custom_grad_color2' => '',

		'angle' => '',

		'bg_img' => '',

	);

}



/* 

 * Social Links options array

 */

function sm_get_social_links_options_array( $group = 'Social Links' ) {

	$social_links = sm_get_social_links_array();

	$ret = array();

	foreach( $social_links as $key => $item ) {

		$ret[] = array(

			'type' => 'textfield',

			'heading' => $item['name'],

			'param_name' => $key,

			'group' => esc_html__( $group, 'semona-extension' )

		);

	}

	return $ret;

}



/* 

 * Make Social links collection with icon and url.

 */

function sm_make_social_links_collection( $atts ) {

	$social_links = sm_get_social_links_array();

	$ret = array();

	foreach( $social_links as $key => $item ) {

		if ( !empty ( $atts[$key] ) ) {

			$ret[$key] = array(

				'name' => $item['name'],

				'icon' => $item['icon'],

				'url' => $atts[$key]

			);

		}

	}

	return $ret;

}



/* 

 * Get Navigation Bullet Shapes array.

 */

function sm_get_nav_bullet_shapes_array() {

	return array( 

		esc_html__( 'Round', 'semona-extension' ) => 'sm-bullet-shape-round',

		esc_html__( 'Square', 'semona-extension' ) => 'sm-bullet-shape-square',

	);

}



/* 

 * Get Image Slider / Carousel Autoplay Interval Array.

 */

function sm_get_autoplay_intervals_array() {

	return array(

		esc_html__( 'Disabled', 'semona-extension' ) => '',

		esc_html__( '1 seconds', 'semona-extension' ) => '1',

		esc_html__( '2 seconds', 'semona-extension' ) => '2',

		esc_html__( '3 seconds', 'semona-extension' ) => '3',

		esc_html__( '4 seconds', 'semona-extension' ) => '4',

		esc_html__( '5 seconds', 'semona-extension' ) => '5',

		esc_html__( '6 seconds', 'semona-extension' ) => '6',

		esc_html__( '7 seconds', 'semona-extension' ) => '7',

		esc_html__( '8 seconds', 'semona-extension' ) => '8',

		esc_html__( '9 seconds', 'semona-extension' ) => '9',

		esc_html__( '10 seconds', 'semona-extension' ) => '10',

	);

}



/* 

 * Get Font Weight Array.

 */

function sm_get_font_weight_array() {

	return array (

		esc_html__( 'Default', 'semona-extension' ) => '',

		esc_html__( 'Light', 'semona-extension' ) => 'sm-light',

		esc_html__( 'Normal', 'semona-extension' ) => 'sm-normal',

		esc_html__( 'Semi Bold', 'semona-extension' ) => 'sm-semibold',

		esc_html__( 'Bold', 'semona-extension' ) => 'sm-bold',

	);

}



/*======================================

 * Individual Shortcode Helper Functions 

 *======================================

 */



/* vc_row, vc_row_inner Helpers */

function sm_get_row_overlay_colors_array() {

	return array(

		esc_html__( 'Theme Background', 'semona-extension' ) => 'sm-bg-color',

		esc_html__( 'Theme Background 2', 'semona-extension' ) => 'sm-bg-color2',

		esc_html__( 'Theme Primary Color', 'semona-extension' ) => 'sm-primary',

		esc_html__( 'Custom Color', 'semona-extension' ) => 'custom'

	);

}



function sm_get_row_equal_column_valigns_array() {

	return array(

		esc_html__( 'Top', 'semona-extension' ) => '',

		esc_html__( 'Middle', 'semona-extension' ) => 'sm-middle',

		esc_html__( 'Bottom', 'semona-extension' ) => 'sm-bottom',

	);

}



/* Dropcap Helpers */

function sm_get_dropcap_styles_array() {

	return array(

		esc_html__( 'Regular Text', 'semona-extension' ) => 'regular-text',

		esc_html__( 'Bold Text', 'semona-extension' ) => 'bold-text',

		esc_html__( 'Small Text', 'semona-extension' ) => 'small-text',

		esc_html__( 'Light Weight Text', 'semona-extension' ) => 'light-text',

		esc_html__( 'Square Box', 'semona-extension' ) => 'rect',

		esc_html__( 'Rounded Box', 'semona-extension' ) => 'round-rect',

		esc_html__( 'Circle', 'semona-extension' ) => 'circle',

		esc_html__( 'Inverted Arch', 'semona-extension' ) => 'inverted-arch'

	);

}



/* Highlight Helpers */

function sm_get_highlight_styles() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => '',

		esc_html__( 'Gradient', 'semona-extension' ) => 'gradient',

	);

}



/* Logo Helpers */

function sm_get_logo_skins_array() {

	return array(

		esc_html__( 'Light', 'semona-extension' ) => 'lightbg',

		esc_html__( 'Dark', 'semona-extension' ) => 'darkbg'

	);

}



/* Custom Heading Helpers */

function sm_get_custom_heading_border_widths_array() {

	return array(

		esc_html__( 'Default', 'semona-extension' ) => '',

		esc_html__( '1px', 'semona-extension' ) => '1px',

		esc_html__( '2px', 'semona-extension' ) => '2px',

		esc_html__( '3px', 'semona-extension' ) => '3px',

		esc_html__( '4px', 'semona-extension' ) => '4px',

		esc_html__( '5px', 'semona-extension' ) => '5px',

	);

}



function sm_get_custom_heading_font_sizes_array() {

	$ary = array( esc_html__( 'Default', 'semona-extension' ) => '' );

	for ( $i = 14; $i <= 50; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



/* Icon List Item Helpers */

function sm_get_icon_list_item_font_sizes_array() {

	$ary = array( esc_html__( 'Default', 'semona-extension' ) => '' );

	for ( $i = 12; $i <= 40; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



/* Callout Helper Functions */

function sm_get_callout_btn_styles_array() {

	return array (

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Flat', 'semona-extension' ) => 'sm-style-flat',

	);

}



function sm_get_callout_btn_pos_array() {

	return array (

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Right', 'semona-extension' ) => 'right',

		esc_html__( 'Bottom', 'semona-extension' ) => 'bottom',

	);

}



/* Button Helper Functions */

function sm_get_button_sizes_array() {

	return array(

		esc_html__( 'Default to Theme' , 'semona-extension' ) => '',

		esc_html__( 'Tiny' , 'semona-extension' ) => 'sm-size-xs',

		esc_html__( 'Small' , 'semona-extension' ) => 'sm-size-sm',

		esc_html__( 'Medium' , 'semona-extension' ) => 'sm-size-md',

		esc_html__( 'Large' , 'semona-extension' ) => 'sm-size-lg',

		esc_html__( 'Extra Large' , 'semona-extension' ) => 'sm-size-xl',

	);

}



function sm_get_button_styles_array() {

	return array(

		esc_html__( 'Modern', 'semona-extension' ) => 'sm-style-modern',

		esc_html__( 'Flat', 'semona-extension' ) => 'sm-style-flat',

		esc_html__( '3D', 'semona-extension' ) => 'sm-style-3d',

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Outline w/ White Background', 'semona-extension' ) => 'sm-style-white',

		esc_html__( 'Default Gradient 1', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2', 'semona-extension' ) => 'sm-style-def-grad2',

		esc_html__( 'Custom Gradient', 'semona-extension' ) => 'sm-style-gradient',

	);

}



function sm_get_button_shapes_array() {

	return array(

		esc_html__( 'Default to Theme', 'semona-extension' ) => '',

		esc_html__( 'Rounded', 'semona-extension' ) => 'sm-shape-rounded',

		esc_html__( 'Round', 'semona-extension' ) => 'sm-shape-round',

		esc_html__( 'Square', 'semona-extension' ) => 'sm-shape-square',

	);

}



function sm_get_button_aligns_array() {

	return array(

		esc_html__( 'Inline', 'semona-extension' ) => '',

		esc_html__( 'Left', 'semona-extension' ) => 'sm-left',

		esc_html__( 'Right', 'semona-extension' ) => 'sm-right',

		esc_html__( 'Center', 'semona-extension' ) => 'sm-center',

		esc_html__( 'Full', 'semona-extension' ) => 'sm-full'

	);

}



function sm_get_button_border_widths_array() {

	return array(

		esc_html__( 'Thin (Default)', 'semona-extension' ) => 'sm-border-thin',

		esc_html__( 'Thick', 'semona-extension' ) => 'sm-border-thick',

	);

}



function sm_get_button_3d_shadow_size( $key ) {

	$ary = array(

		'sm-size-xs' => 2,

		'sm-size-sm' => 2,

		'sm-size-md' => 3,

		'sm-size-lg' => 4,

		'sm-size-xl' => 5,

	);

	if ( isset( $ary[$key] ) ) {

		return $ary[$key];

	} else if ( empty( $key ) && function_exists( 'crf_get_theme_mod_value' ) ) {

		$size = crf_get_theme_mod_value( 'button-size' );

		return $ary[$size];

	} else return $ary['sm-size-md'];

}



/* Accordion Helpers */

function sm_get_accordion_tab_shapes_array() {

	return array(

		esc_html__( 'Rounded', 'semona-extension' ) => 'sm-shape-rounded',

		esc_html__( 'Square', 'semona-extension' ) => 'sm-shape-square',

	);

}



function sm_get_accordion_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Default Gradient 1', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2', 'semona-extension' ) => 'sm-style-def-grad2',

		esc_html__( 'Outlined', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Underlined', 'semona-extension' ) => 'sm-style-underline',

	);

}



function sm_get_accordion_ctrl_styles_array() {

	return array(

		esc_html__( 'Default', 'semona-extension' ) => '',

		esc_html__( 'With Background', 'semona-extension' ) => 'sm-ctrl-bg',

		esc_html__( 'Icon Font', 'semona-extension' ) => 'sm-ctrl-fa',

	);

}



function sm_get_accordion_ctrl_aligns_array() { 

	return array(

		esc_html__( 'Right', 'semona-extension' ) => 'sm-ctrl-right',

		esc_html__( 'Left', 'semona-extension' ) => 'sm-ctrl-left',

	);

}



/* Tabs Helpers */

function sm_get_tabs_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => '',

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

	);

}

function sm_get_tabs_content_bg_colors_array() {

	return array(

		esc_html__( 'Use Default Background Color', 'semona-extension' ) => '',

		esc_html__( 'Use Active Header Color', 'semona-extension' ) => 'sm-same-bg',

		esc_html__( 'Theme Background', 'semona-extension' ) => 'sm-bg-color-content',

		esc_html__( 'Theme Background 2', 'semona-extension' ) => 'sm-bg-color2-content',

	);

}



function sm_get_tabs_header_styles_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Border Top', 'semona-extension' ) => 'sm-header-border-top',

		esc_html__( 'Border Bottom', 'semona-extension' ) => 'sm-header-border-bottom',

		esc_html__( 'Triangle Left', 'semona-extension' ) => 'sm-header-triangle-left',

		esc_html__( 'Triangle Center', 'semona-extension' ) => 'sm-header-triangle-center',

		esc_html__( 'Triangle Right', 'semona-extension' ) => 'sm-header-triangle-right',

	);

}



/* Vertical Tabs Helpers */

function sm_get_vtabs_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => '',

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

	);

}



function sm_get_vtabs_outline_styles_array() {

	return array(

		esc_html__( 'Full Border (Default)', 'semona-extension' ) => '',

		esc_html__( 'Header with No Border Box', 'semona-extension' ) => 'sm-hdr-no-borderbox',

		esc_html__( 'Header & Content with No Border Box', 'semona-extension' ) => 'sm-no-borderbox',

	);

}



function sm_get_vtabs_content_bg_colors_array() {

	return array_merge( 

		array( esc_html__( 'Active Header Color (Default)', 'semona-extension' ) => '' ),

		sm_get_preset_bg_colors_array( true )

	);

}



/* Message Box Helpers */

function sm_get_message_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

	);

}



function sm_get_message_preset_colors_array() {

	return array(

		esc_html__( 'Standard', 'semona-extension' ) => 'sm-standard',

		esc_html__( 'Information', 'semona-extension' ) => 'sm-info',

		esc_html__( 'Warning', 'semona-extension' ) => 'sm-warning',

		esc_html__( 'Success', 'semona-extension' ) => 'sm-success',

		esc_html__( 'Error', 'semona-extension' ) => 'sm-error',

		esc_html__( 'Dark Error', 'semona-extension' ) => 'sm-error-dark',

	);

}



function sm_get_message_icon_by_type( $type ) {

	switch ( $type ) {

		case 'sm-standard':

			return 'fa fa-bell';

		case 'sm-info':

			return 'fa fa-info-circle';

		case 'sm-warning':

			return 'fa fa-exclamation-triangle';

		case 'sm-success':

			return 'fa fa-check';

		case 'sm-error':

			return 'fa fa-times';

		case 'sm-error-dark':

			return 'fa fa-times';

		default:

			return 'fa fa-bell';

	};

}



function sm_get_message_types_array() {

	return array_merge(

		sm_get_message_preset_colors_array(),

		array( esc_html__( 'Custom', 'semona-extension' ) => 'custom' )

	);

}

function sm_get_message_colors_array() {

	return array_merge( sm_get_message_preset_colors_array(), sm_get_preset_colors_array( false, false, false ) );

}



function sm_get_message_sizes_array() {

	return array(

		esc_html__( 'Normal', 'semona-extension' ) => '',

		esc_html__( 'Small', 'semona-extension' ) => 'sm-size-sm',

	);

}



/* Section Header Helpers */

function sm_get_section_header_styles_array() {

	return array(

		esc_html__( 'Default Border Style', 'semona-extension' ) => '',

		esc_html__( 'Diamond Border Style', 'semona-extension' ) => 'sm-style-diamond',

	);

}



/* Separator Helpers */

function sm_get_separator_styles_array() {

	return array(

		esc_html__( 'Solid Line (Default)', 'semona-extension' ) => '',

		esc_html__( 'Diamond', 'semona-extension' ) => 'sm-style-diamond',

	);

}



function sm_get_preheader_colors_array() {

	return array(

		esc_html__( 'Section Heading Color', 'semona-extension' ) => '',

		esc_html__( 'Theme Heading Color', 'semona-extension' ) => 'sm-heading',

		esc_html__( 'Theme Primary Color', 'semona-extension' ) => 'sm-primary',

	);

}



function sm_get_separator_border_widths_array() {

	return array(

		esc_html__( '1px', 'semona-extension' ) => '',

		esc_html__( '2px', 'semona-extension' ) => '2',

		esc_html__( '3px', 'semona-extension' ) => '3',

		esc_html__( '4px', 'semona-extension' ) => '4',

		esc_html__( '5px', 'semona-extension' ) => '5',

		esc_html__( '6px', 'semona-extension' ) => '6',

		esc_html__( '7px', 'semona-extension' ) => '7',

		esc_html__( '8px', 'semona-extension' ) => '8',

		esc_html__( '9px', 'semona-extension' ) => '9',

		esc_html__( '10px', 'semona-extension' ) => '10',

	);

}



function sm_get_separator_element_widths_array() {

	return array(

		esc_html__( '100%', 'semona-extension' ) => '',

		esc_html__( '90%', 'semona-extension' ) => '90',

		esc_html__( '80%', 'semona-extension' ) => '80',

		esc_html__( '70%', 'semona-extension' ) => '70',

		esc_html__( '60%', 'semona-extension' ) => '60',

		esc_html__( '50%', 'semona-extension' ) => '50',

		esc_html__( '40%', 'semona-extension' ) => '40',

		esc_html__( '30%', 'semona-extension' ) => '30',

		esc_html__( '20%', 'semona-extension' ) => '20',

		esc_html__( '10%', 'semona-extension' ) => '10',

	);

}



/* Quotes Slider Helpers */

function sm_get_quotes_style_array() {

	return array(

		esc_html__( 'Style 1 (With thin border)', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 (Without border)', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 (With thick border)', 'semona-extension' ) => 'sm-style3'

	);

}



function sm_get_quote_font_sizes_array() {

	$ary = array( esc_html__( 'Default to Style', 'semona-extension' ) => '' );

	for ( $i = 14; $i <= 40; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



/* Feature Box Helpers */

function sm_featurebox_icon_sources_array() {

	return array(

		esc_html__( 'Icon Font', 'polar-extension' ) => 'font',

		esc_html__( 'Image', 'polar-extension' ) => 'image'

	);

}



function sm_get_featurebox_icon_pos_array() {

	return array(

		esc_html__( 'Icon at the top', 'semona-extension' ) => 'sm-icon-top',

		esc_html__( 'Icon at the left', 'semona-extension' ) => 'sm-icon-left',

		esc_html__( 'Icon at the left of title', 'semona-extension' ) => 'sm-icon-left-title',

		esc_html__( 'Icon at the right', 'semona-extension' ) => 'sm-icon-right',

	);

}



function sm_get_featurebox_icon_wrap_styles_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Outlined Circle', 'semona-extension' ) => 'sm-wrap-outlined-circle',

		esc_html__( 'Solid Circle', 'semona-extension' ) => 'sm-wrap-solid-circle',

		esc_html__( 'Solid Bordered Circle', 'semona-extension' ) => 'sm-wrap-double-circle',

	);

}



function sm_get_featurebox_icon_sizes_array() {

	$ary = array( esc_html__( 'Default', 'semona-extension' ) => '' );

	for ( $i = 20; $i <= 40; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



function sm_get_featurebox_color_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Default Gradient 1 (Only for Chrome and Safari browsers)', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2 (Only for Chrome and Safari browsers)', 'semona-extension' ) => 'sm-style-def-grad2',

	);

}



function sm_get_featurebox_border_width_array() {

	return array(

		esc_html__( 'Thin', 'semona-extension' ) => 'sm-border-thin',

		esc_html__( 'Medium', 'semona-extension' ) => 'sm-border-medium',

		esc_html__( 'Thick', 'semona-extension' ) => 'sm-border-thick',

	);

}



/* Team Member Helpers */

function sm_get_team_member_styles_array() {

	return array(

		esc_html__( 'Style 1 - Square image showing infos on hover', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 - Vertical, centered layout showing social icons on hover', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 - Vertical, left-aligned layout with extra description', 'semona-extension' ) => 'sm-style3',

		esc_html__( 'Style 4 - Horizontal layout with extra description', 'semona-extension' ) => 'sm-style4',

		esc_html__( 'Style 5 - Members behind bar Style', 'semona-extension' ) => 'sm-style5',

		esc_html__( 'Style 6 - Vertical, centered layout with extra description', 'semona-extension' ) => 'sm-style6',

	);

}



/* Pricing Table Helpers */

function sm_get_pricingtable_columns_array() {

	return array( '1', '2', '3', '4', '5', '6' );

}



function sm_get_pricingtable_styles_array() {

	return array(

		esc_html__( 'Style 1 - Title in 3D box', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 - Pricing in circle', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 - Flat Style', 'semona-extension' ) => 'sm-style3',

	);

}



function sm_get_pricingtable_color_schemes_array() {

	return array(

		esc_html__( 'Default to Theme', 'semona-extension' ) => '',

		esc_html__( 'Light', 'semona-extension' ) => 'sm-theme-light',

		esc_html__( 'Dark', 'semona-extension' ) => 'sm-theme-dark'

	);

}



/* Counter Box Helpers */

function sm_get_counterbox_styles_array() {

	return array (

		esc_html__( 'Boxed Style', 'semona-extension' ) => 'sm-style-boxed',

		esc_html__( 'Round Style', 'semona-extension' ) => 'sm-style-round',

		esc_html__( 'Split Style', 'semona-extension' ) => 'sm-style-split',

		esc_html__( 'Raw Style', 'semona-extension' ) => 'sm-style-raw',

		esc_html__( 'Number-only Style', 'semona-extension' ) => 'sm-style-number',

		esc_html__( 'Flip Counter Style', 'semona-extension' ) => 'sm-style-flip'

	);

}



function sm_get_counterbox_font_sizes_array() {

	$ary = array( esc_html__( 'Default to Style', 'semona-extension' ) => '' );

	for ( $i = 14; $i <= 80; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



/* Progress bar Helpers */

function sm_get_progressbar_shapes_array( $include_default = false ) {

	return array(

		esc_html__( 'Round', 'semona-extension' ) => 'sm-shape-round',

		esc_html__( 'Square', 'semona-extension' ) => 'sm-shape-square'

	);

}

function sm_get_progressbar_styles_array( $include_default = false ) {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Outlined', 'semona-extension' ) => 'sm-style-outline',

	);

}



/* Section Icon Helpers */

function sm_get_section_icon_wrapper_types_array() {

	return array(

		esc_html__( 'Circle', 'semona-extension' ) => 'sm-wrap-circle',

		esc_html__( 'Triangle', 'semona-extension' ) => 'sm-wrap-triangle',

		esc_html__( 'Pentagon', 'semona-extension' ) => 'sm-wrap-pentagon',

		esc_html__( 'Hexagon', 'semona-extension' ) => 'sm-wrap-hexagon',

		esc_html__( 'Custom Shape', 'semona-extension' ) => 'custom',

	);

}



function sm_get_section_icon_color_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Default Gradient 1', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2', 'semona-extension' ) => 'sm-style-def-grad2',

	);

}



function sm_get_section_icon_border_colors_array() {

	return array(

		esc_html__( 'Theme Background', 'semona-extension' ) => 'sm-bg-color',

		esc_html__( 'Theme Background 2', 'semona-extension' ) => 'sm-bg-color2',

	);

}



/* Image Helpers */

function sm_get_image_aligns_array() {

	return array(

		esc_html__( 'Center', 'semona-extension' ) => 'center',

		esc_html__( 'Left', 'semona-extension' ) => 'left',

		esc_html__( 'Right', 'semona-extension' ) => 'right',

		esc_html__( 'Full Width', 'semona-extension' ) => 'full',

		esc_html__( 'Inline', 'semona-extension' ) => 'inline',

	);

}



function sm_get_image_styles_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Rounded', 'semona-extension' ) => 'sm-style-rounded',

		esc_html__( 'Border', 'semona-extension' ) => 'sm-style-border',

		esc_html__( 'Outline', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Shadow', 'semona-extension' ) => 'sm-style-shadow',

		esc_html__( 'Bordered shadow', 'semona-extension' ) => 'sm-style-shadow-border',

		esc_html__( '3D Shadow', 'semona-extension' ) => 'sm-style-shadow-3d',

		esc_html__( 'Round', 'semona-extension' ) => 'sm-style-circle', //new

		esc_html__( 'Round Border', 'semona-extension' ) => 'sm-style-border-circle', //new

		esc_html__( 'Round Outline', 'semona-extension' ) => 'sm-style-outline-circle', //new

		esc_html__( 'Round Shadow', 'semona-extension' ) => 'sm-style-shadow-circle', //new

		esc_html__( 'Round Border Shadow', 'semona-extension' ) => 'sm-style-shadow-border-circle', //new

	);

}



function sm_get_image_border_colors_array() {

	$ary = sm_get_basic_colors_array();

	$ary[__( 'Light Grey', 'semona-extension' )] = 'sm-grey-light';

	$ary[__( 'White', 'semona-extension' )] = 'sm-white';

	return $ary;

}



function sm_get_image_actions_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Show Image within Lightbox', 'semona-extension' ) => 'sm-action-image',

		esc_html__( 'Show Video within Lightbox', 'semona-extension' ) => 'sm-action-video',

		esc_html__( 'Open Custom Link', 'semona-extension' ) => 'sm-action-link',

		esc_html__( 'Magnify Image', 'semona-extension' ) => 'sm-action-magnify',

		esc_html__( 'Show Image Description', 'semona-extension' ) => 'sm-action-text',

	);

}



function sm_get_image_hover_actions_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Show Overlay', 'semona-extension' ) => 'sm-hover-overlay',

		esc_html__( 'Show Hover Image', 'semona-extension' ) => 'sm-hover-image',

		esc_html__( 'Lighten Image', 'semona-extension' ) => 'sm-hover-lighten',

		esc_html__( 'Darken Image', 'semona-extension' ) => 'sm-hover-darken',

	);

}



/* Numbered Thumbnail Helpers */

function sm_get_nt_number_border_colors_array() {

	return array(

		esc_html__( 'Theme Background', 'semona-extension' ) => 'sm-bg-color',

		esc_html__( 'Theme Background 2', 'semona-extension' ) => 'sm-bg-color2',

		esc_html__( 'Custom Color', 'semona-extension' ) => 'custom'

	);

}



/* Team Slider Helpers */

function sm_get_team_slider_styles_array() {

	return array( 

		esc_html__( 'Style 1 - Social Icons in circle', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 - Social Icons with hyphen', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 - Social Icons on hover', 'semona-extension' ) => 'sm-style3',

	);

}

function sm_get_team_slider_items_array() {

	return array( 

		esc_html__( '3 Items', 'semona-extension' ) => '3',

		esc_html__( '4 Items', 'semona-extension' ) => '4',

		esc_html__( '5 Items', 'semona-extension' ) => '5',

		esc_html__( '6 Items', 'semona-extension' ) => '6',

	);

}



/* Testimonial Helpers */

function sm_get_testimonial_styles_array() {

	return array( 

		esc_html__( 'Style 1 - Square bubble with default navigation at right', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 - Square bubble with default navigation at top', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 - Two square bubbles with pictures at bottom', 'semona-extension' ) => 'sm-style3',

		esc_html__( 'Style 4 - Vertical, centered layout', 'semona-extension' ) => 'sm-style4',

		esc_html__( 'Style 5 - Square Box with round avatar on the left', 'semona-extension' ) => 'sm-style5',

	);

}



function sm_get_nav_position_array() {

	return array(

		esc_html__( 'Default to Style', 'semona-extension' ) => '',

		esc_html__( 'Above Slider', 'semona-extension' ) => 'sm-pos-above',

		esc_html__( 'Below Slider', 'semona-extension' ) => 'sm-pos-below',

	);

}



function sm_get_def_nav_positions() {

	return array(

		'sm-style1' => 'sm-pos-right',

		'sm-style2' => 'sm-pos-above',

		'sm-style3' => 'sm-pos-below',

		'sm-style4' => 'sm-pos-below',

	);

}



function sm_get_testimonial_font_sizes_array() {

	$ary = array( esc_html__( 'Default to Style', 'semona-extension' ) => '' );

	for ( $i = 14; $i <= 40; $i ++ ) {

		$ary[$i . 'px'] = $i . 'px';

	}

	return $ary;

}



/* Stretching Container Helpers */

function sm_get_stretch_container_types_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Stretch to Left', 'semona-extension' ) => 'sm-stretch-left',

		esc_html__( 'Stretch to Right', 'semona-extension' ) => 'sm-stretch-right',

	);

}



function sm_get_stretch_container_valigns_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Middle', 'semona-extension' ) => 'sm-middle',

		esc_html__( 'Bottom', 'semona-extension' ) => 'sm-bottom',

	);

}



/* Contact Form 7 Helpers */

function sm_get_contact_form_7_forms_array() {

	$cf7 = get_posts( array(

			'post_type' => 'wpcf7_contact_form',

			'posts_per_page' => '-1',

	) );



	$contact_forms = array();

	if ( $cf7 ) {

		foreach ( $cf7 as $cform ) {

			$contact_forms[ $cform->post_title ] = $cform->ID;

		}

	} else {

		$contact_forms[ esc_html__( 'No contact forms found', 'semona-extension' ) ] = '';

	}

	return $contact_forms;

}



function sm_get_contact_form_input_styles_array() {

	return array(

		esc_html__( 'Outlined', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Translucent', 'semona-extension' ) => 'sm-style-translucent',

		esc_html__( 'Underlined', 'semona-extension' ) => 'sm-style-underline',

		esc_html__( 'Blank', 'semona-extension' ) => 'custom',

	);

}



function sm_get_contact_form_input_shapes_array() {

	return array(

		esc_html__( 'Rounded', 'semona-extension' ) => 'sm-shape-rounded',

		esc_html__( 'Square', 'semona-extension' ) => 'sm-shape-square',

	);

}



function sm_get_contact_form_button_styles_array() {

	return array(

		esc_html__( 'Modern', 'semona-extension' ) => 'sm-style-modern sm-size-lg',

		esc_html__( 'Flat', 'semona-extension' ) => 'sm-style-flat sm-size-lg',

		esc_html__( '3D', 'semona-extension' ) => 'sm-style-3d sm-size-lg',

		esc_html__( 'Thin Outline', 'semona-extension' ) => 'sm-style-outline',

		esc_html__( 'Thick Outline', 'semona-extension' ) => 'sm-style-outline sm-border-thick',

		esc_html__( 'Translucent', 'semona-extension' ) => 'sm-style-white sm-white sm-translucent sm-size-lg',

		esc_html__( 'Underlined', 'semona-extension' ) => 'sm-style-underline',

	);

}



function sm_get_contact_form_button_aligns_array() {

	return array(

		esc_html__( 'Full', 'semona-extension' ) => '',

		esc_html__( 'Left', 'semona-extension' ) => 'sm-left',

		esc_html__( 'Right', 'semona-extension' ) => 'sm-right',

		esc_html__( 'Center', 'semona-extension' ) => 'sm-center',

	);

}



/* Contact Info Field Helpers */

function sm_get_contact_info_color_styles_array() {

	return array(

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Default Gradient 1', 'semona-extension' ) => 'sm-style-def-grad1',

		esc_html__( 'Default Gradient 2', 'semona-extension' ) => 'sm-style-def-grad2',

	);

}



/* Social Links Helpers */

function sm_get_social_links_styles_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Outlined', 'semona-extension' ) => 'sm-style-outline',

	);

}

function sm_get_social_links_shapes_array() {

	return array(

		esc_html__( 'Rounded', 'semona-extension' ) => 'sm-shape-rounded',

		esc_html__( 'Round', 'semona-extension' ) => 'sm-shape-round',

	);

}



/* Coming Soon Helpers */

function sm_get_coming_soon_styles_array() {

	return array(

		esc_html__( 'None', 'semona-extension' ) => '',

		esc_html__( 'Solid', 'semona-extension' ) => 'sm-style-solid',

		esc_html__( 'Outlined', 'semona-extension' ) => 'sm-style-outline',

	);

}



/* Pie Chart Helpers */

function sm_get_pie_chart_styles_array() {

	return array( 

		esc_html__( 'Style 1', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2', 'semona-extension' ) => 'sm-style2',

	);

}



function sm_get_pie_chart_default_value( $style, $key ) {

	$default_values = array(

		'sm-style1' => array(

			'head_color' => '#fff',

			'back_thickness' => 3

		),

		'sm-style2' => array(

			'head_color' => '#2a2214',

			'back_thickness' => 20

		),

	);

	return $default_values[$style][$key];

}

/* Countdown Helpers */

function sm_get_countdown_styles_array() {

	return array(

		esc_html__( 'Style 1 - Circular Countdown', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 - Simple Number', 'semona-extension' ) => 'sm-style2',

		esc_html__( 'Style 3 - Boxed Countdown', 'semona-extension' ) => 'sm-style3',

	);

}



function sm_get_countdown_units_string( $style, $key ) {

	$ary = array(

		'sm-style1' => array(

			'days' => esc_html__( 'days', 'semona-extension' ),

			'hours' => esc_html__( 'hours', 'semona-extension' ),

			'minutes' => esc_html__( 'minutes', 'semona-extension' ),

			'seconds' => esc_html__( 'seconds', 'semona-extension' ),

		),

		'sm-style2' => array(

			'days' => esc_html__( 'days', 'semona-extension' ),

			'hours' => esc_html__( 'hrs', 'semona-extension' ),

			'minutes' => esc_html__( 'mins', 'semona-extension' ),

			'seconds' => esc_html__( 'secs', 'semona-extension' ),

		),

		'sm-style3' => array(

			'days' => esc_html__( 'days', 'semona-extension' ),

			'hours' => esc_html__( 'hours', 'semona-extension' ),

			'minutes' => esc_html__( 'minutes', 'semona-extension' ),

			'seconds' => esc_html__( 'seconds', 'semona-extension' ),

		),

	);

	return $ary[$style][$key];

}



/* Progress Steps Helpers */

function sm_get_progress_steps_type_array() {

	return array(

		esc_html__( 'Type 1 - Horizontal Circles', 'semona-extension' ) => 'sm-type1',

		esc_html__( 'Type 2 - Vertical Zigzags', 'semona-extension' ) => 'sm-type2',

		esc_html__( 'Type 3 - Horizontal Rectangles', 'semona-extension' ) => 'sm-type3',

	);

}



function sm_get_progress_steps_columns_array() {

	return array( '2', '3', '4', '5', '6' );

}



function sm_get_progress_steps_style_array() {

	return array(

		esc_html__( 'Number', 'semona-extension' ) => 'sm-style-number',

		esc_html__( 'Icon', 'semona-extension' ) => 'sm-style-icon',

	);

}



/* Image Slider Helpers */

function sm_get_image_slider_types_array() {

	return array(

		esc_html__( 'Basic Slider', 'semona-extension' ) => 'sm-type-basic',

		esc_html__( 'Slider with Thumbnails', 'semona-extension' ) => 'sm-type-thumb',

	);

}



/* Tweets Helpers */

function sm_get_tweet_types_array() {

	return array(

		esc_html__( 'Type 1 - Large Text with horizontal slider', 'semona-extension' ) => 'sm-type1',

		esc_html__( 'Type 2 - Small Text with vertical slider', 'semona-extension' ) => 'sm-type2',

	);

}

function sm_get_tweet_icon_styles_array() {

	return array(

		esc_html__( 'Icon only', 'semona-extension' ) => '',

		esc_html__( 'Wrap in circle', 'semona-extension' ) => 'sm-wrap-solid-circle',

	);

}



function sm_get_tweet_numbers_array() {

	$ary = array();

	for ( $i = 1; $i <= 5; $i ++ ) {

		$ary[$i] = $i;

	}

	return $ary;

}

function sm_wrap_tweet_links( $text ) {

	$text = preg_replace ( '/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '&nbsp;<a href="http://$1" target="_blank">http://$1</a>&nbsp;', $text );

	$text = preg_replace ( '/https:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '&nbsp;<a href="https://$1" target="_blank">https://$1</a>&nbsp;', $text );

	$text = preg_replace ( '/@([a-z0-9_]+)/i', '&nbsp;<a href="https://twitter.com/$1" target="_blank">@$1</a>&nbsp;', $text );

	return $text;

}



function sm_get_theme_tweet_settings() {

	$settings = array();

	if (function_exists( 'crf_get_theme_mod_value' ) ) {

		$settings['twitter_id'] = crf_get_theme_mod_value( 'latest-tweet-twitter_id' );

		$settings['consumer_key'] = crf_get_theme_mod_value( 'latest-tweet-consumer_key' );

		$settings['consumer_secret'] = crf_get_theme_mod_value( 'latest-tweet-consumer_secret' );

		$settings['access_token'] = crf_get_theme_mod_value( 'latest-tweet-access_token' );

		$settings['access_token_secret'] = crf_get_theme_mod_value( 'latest-tweet-access_token_secret' );

	}

	return $settings;

}



/* Timeline Helpers */

function sm_get_timeline_post_styles_array() {

	return array(

		esc_html__( 'Speech Bubble Style', 'semona-extension' ) => 'sm-style-speech-bubble',

		esc_html__( 'Blog Grid Item Style', 'semona-extension' ) => 'sm-style-grid-item',

	);

}



function sm_get_timeline_group_by_array() {

	return array(

		esc_html__( 'Year', 'semona-extension' ) => 'sm-group-year',

		esc_html__( 'Month', 'semona-extension' ) => 'sm-group-month',

	);

}



function sm_get_timeline_color_schemes_array() {

	return array(

		esc_html__( 'Default to Theme', 'semona-extension' ) => '',

		esc_html__( 'White Color', 'semona-extension' ) => 'sm-white',

	);

}



function sm_get_timeline_data_from_posts( $count = 10, $group_by = 'sm-group-year', $categories = '', $ret_query = false ) {

	$timeline_data = array();



	$query_args = array();

	$query_args['posts_per_page'] = $count;

	$query_args['post_status'] = array( 'publish', 'private' );

	if( $categories ) {

		$query_args['category__in'] = explode( ',', $categories );

	}

	$query_args['ignore_sticky_posts'] = '1';

	$query_args['has_password'] = false;

	$query = new WP_Query( $query_args );



	if ( $ret_query ) return $query;



	add_filter( 'excerpt_length', 'sm_timeline_posts_excerpt', 999 );

	if( $query->have_posts() ) {

		while( $query->have_posts() ) {

			$query->the_post();

			if ( 'sm-group-month' == $group_by) {

				$key = get_the_date( 'Y-m' );

				$label = get_the_date( 'M Y' );

			} else {

				$label = $key = get_the_date( 'Y' );

			}

			if ( empty( $timeline_data[$key] ) ) {

				$timeline_data[$key] = array(

					'group_label' => $label,

					'contents' => array()

				);

			}

			$timeline_data[$key]['contents'][] = array(

				'date' => get_the_date( 'd M Y'),

				'title' => get_the_title(),

				'content' => get_the_excerpt(),

				'url' => get_permalink(),

				'post' => $query->post,

			);

		}

	}

	remove_filter( 'excerpt_length', 'sm_timeline_posts_excerpt', 999 );

	return $timeline_data;

}



function sm_timeline_posts_excerpt( $length ) {

	return 20;

}



/* Read More Link Helpers */

function sm_readmore_styles_array() {

	return array(

		esc_html__( 'Style 1 : Read More --', 'semona-extension' ) => 'sm-style1',

		esc_html__( 'Style 2 : -- Read More --', 'semona-extension' ) => 'sm-style2',

	);

}



/* Slide Image Helpers */

function sm_get_slide_image_types_array() {

	return array(

		esc_html__( 'Vertical', 'semona-extension' ) => 'sm-slide-vertical',

		esc_html__( 'Horizontal', 'semona-extension' ) => 'sm-slide-horizontal',

	);

}



function sm_get_slide_image_frames_array() {

	return array(

		esc_html__( 'Simple Box with Shadow', 'semona-extension' ) => 'sm-style-box',

		esc_html__( 'Browser Frame', 'semona-extension' ) => 'sm-style-browser',

		esc_html__( 'Desktop', 'semona-extension' ) => 'sm-style-desktop',

		esc_html__( 'Laptop', 'semona-extension' ) => 'sm-style-laptop',

	);

}



/* Google Map Helpers */

function sm_get_map_type_array() {

	return array(

		esc_html__( 'Roadmap', 'semona-extension' ) => 'roadmap',

		esc_html__( 'Satellite', 'semona-extension' ) => 'satellite',

		esc_html__( 'Hybrid', 'semona-extension' ) => 'hybrid',

		esc_html__( 'Terrain', 'semona-extension' ) => 'terrain',

	);

}



function sm_get_map_zoom_levels_array() {

	$ary = array();

	for ( $i = 1; $i <= 25; $i ++ ) {

		$ary[$i] = $i;

	}

	return $ary;

}



function sm_get_map_infobox_positions_array() {

	return array(

		esc_html__( 'Above Map Pin', 'polar-extension' ) => 'top',

		esc_html__( 'Below Map Pin', 'polar-extension' ) => 'bottom',

		esc_html__( 'On the Left of Map Pin', 'polar-extension' ) => 'left',

		esc_html__( 'On the Right of Map Pin', 'polar-extension' ) => 'right',

	);

}



function sm_get_map_infobox_styles_array() {

	return array(

		esc_html__( 'Default Google Infobox', 'semona-extension' ) => '',

		esc_html__( 'Custom', 'semona-extension' ) => 'custom',

	);

}

/* 

 * Register Semona Shortcodes to WordPress 

 */

global $sm_vc_shortcodes;



$sm_vc_shortcodes = array();



function sm_register_shortcode( $args ) {

	global $sm_vc_shortcodes;

	$register_handler = 'sm_register_shortcode_handler_' . $args['base'];

	$shortcode_handler = $args['base'] . '_func';

	if ( function_exists( $register_handler ) ) {

		call_user_func( $register_handler );

		$sm_vc_shortcodes[] = $args;

	} else if ( function_exists( $shortcode_handler ) ) {

		add_shortcode( $args['base'], $shortcode_handler );

	} else {

		return;

	}

	crsg_register_shortcode( $args );

}



add_action( 'vc_after_init', 'vc_map_all_shortcodes', 30 );

function vc_map_all_shortcodes() {

	global $sm_vc_shortcodes;

	foreach( $sm_vc_shortcodes as $shortcode ) {

		vc_map( $shortcode );

	}

}