<?php

add_action( 'vc_before_init', 'sm_add_params_vc_row' );

function sm_add_params_vc_row() {

	vc_remove_param( 'vc_row', 'equal_height' );

	vc_remove_param( 'vc_row', 'gap' );

	vc_remove_param( 'vc_row', 'content_placement' );



	vc_add_params( 'vc_row', array(

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Force Equal Column Height', 'semona-extension' ),

			'param_name' => 'equal_col_height',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'description' => esc_html__( 'Put checkmark if you want all the columns in this row to have the equal height.', 'semona-extension' ),

			'dependency' => array(

				'element' => 'full_height',

				'value_not_equal_to' => 'yes'

			)

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Equal Height Column Vertical Align', 'semona-extension' ),

			'param_name' => 'equal_col_valign',

			'value' => sm_get_row_equal_column_valigns_array(),

			'description' => esc_html__( 'Choose vertical alignment for inner columns of equal height.', 'semona-extension' ),

			'dependency' => array(

				'element' => 'equal_col_height',

				'value' => 'yes'

			)

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Force Equal Height Column On Mobile', 'polar-extension' ),

			'param_name' => 'equal_col_mobile',

			'value' => array( esc_html__( 'Yes', 'polar-extension' ) => 'yes' ),

			'description' => esc_html__( 'Choose Yes to force equal height column even on mobile.', 'polar-extension' ),

			'dependency' => array(

				'element' => 'equal_col_height',

				'value' => 'yes'

			)

		),

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Background Position', 'semona-extension' ),

			'param_name' => 'bg_pos',

			'value' => '',

			'description' => esc_html__( 'Enter Background Position, e.g. \'center center\' or \'120px 100px\'.', 'semona-extension' ),

			'group' => esc_html__( 'Design Options', 'js_composer' ),

			'edit_field_class' => 'vc_col-sm-7 vc_column',

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Fixed Background Image', 'semona-extension' ),

			'param_name' => 'fixed_bg_img',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'description' => esc_html__( 'Put checkmark if you want background image stay in fixed position when scroll down the browser.', 'semona-extension' ),

			'group' => esc_html__( 'Design Options', 'js_composer' ),

			'edit_field_class' => 'vc_col-sm-5 vc_column',

		),

		sm_bg_color_preset_option(),

		// Overlay options

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Use Background Overlay', 'semona-extension' ),

			'param_name' => 'use_overlay',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'group' => esc_html__( 'Background Overlay', 'semona-extension' )

		),

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Overlay Opacity (%)', 'semona-extension' ),

			'param_name' => 'overlay_opacity',

			'value' => '',

			'dependency' => array(

				'element' => 'use_overlay',

				'value' => array( 'yes' )

			),

			'group' => esc_html__( 'Background Overlay', 'semona-extension' )

		),

		array (

			'type' => 'dropdown',

			'heading' => esc_html__( 'Overlay Color', 'semona-extension' ),

			'param_name' => 'overlay_color',

			'value' => sm_get_row_overlay_colors_array(),

			'dependency' => array(

				'element' => 'use_overlay',

				'value' => array( 'yes' )

			),

			'group' => esc_html__( 'Background Overlay', 'semona-extension' )

		),

		array (

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Overlay Color', 'semona-extension' ),

			'param_name' => 'overlay_custom_color',

			'dependency' => array(

				'element' => 'overlay_color',

				'value' => array( 'custom' )

			),

			'group' => esc_html__( 'Background Overlay', 'semona-extension' )

		)

	) );



}