<?php

if ( defined( 'WPB_VC_VERSION' ) ) {

	class WPBakeryShortCode_sm_testimonials extends WPBakeryShortCodesContainer {

		function content($atts, $content = null) {

			return sm_testimonials_func( $atts, $content );

		}

	}

} else {

	add_shortcode( 'sm_testimonials', 'sm_testimonials_func' );

}



function sm_testimonials_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'testimonial-slider', $view_params );

}



add_action( 'vc_before_init', 'vc_map_sm_testimonials' );

function vc_map_sm_testimonials() {

	vc_map( array(

		'name' => esc_html__( 'Testimonials Slider', 'semona-extension' ),

		'base' => 'sm_testimonials',

		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

		'description' => esc_html__( 'Testimonials Slider with Avatar', 'semona-extension' ),

		'as_parent' => array( 'only' => 'sm_testimonial_item' ),

		'content_element' => true,

		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-testimonial_slider.png',

		'params' => array(

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Style', 'semona-extension' ),

				'value' => sm_get_testimonial_styles_array(),

				'param_name' => 'style',

				'description' => esc_html__( 'Select style.', 'semona-extension' ),

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Navigation Bullet Shape', 'semona-extension' ),

				'value' => sm_get_nav_bullet_shapes_array(),

				'param_name' => 'bullet_shape',

				'description' => esc_html__( 'Select navigation bullet shape.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Navigation Position', 'semona-extension' ),

				'value' => sm_get_nav_position_array(),

				'param_name' => 'nav_pos',

				'description' => esc_html__( 'Select navigation position.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Content Font Size', 'semona-extension' ),

				'value' => sm_get_testimonial_font_sizes_array(),

				'param_name' => 'content_fontsize',

				'description' => esc_html__( 'Select testimonial content font size.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Background Color', 'semona-extension' ),

				'param_name' => 'bg_color',

				'description' => esc_html__( 'Specify box background color. Leave blank to use default (Secondary background color).', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style5' )

				),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Content Color', 'semona-extension' ),

				'param_name' => 'color',

				'description' => esc_html__( 'Specify main content color. If you leave blank for the colors below, content color will be used for these fields. Leave blank to use default.', 'semona-extension' ),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Name Color', 'semona-extension' ),

				'param_name' => 'name_color',

				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Title Color', 'semona-extension' ),

				'param_name' => 'company_color',

				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Navigation Color', 'semona-extension' ),

				'param_name' => 'nav_color',

				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Navigation Active Color', 'semona-extension' ),

				'param_name' => 'nav_active_color',

				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			sm_extra_class()

		),

		'js_view' => 'VcColumnView',

	) );

}



