<?php



function sm_register_shortcode_handler_sm_team_slider() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_team_slider extends WPBakeryShortCodesContainer {

			function content($atts, $content = null) {

				return sm_team_slider_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_team_slider', 'sm_team_slider_func' );

	}

}



function sm_team_slider_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'team-slider', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Team Slider', 'semona-extension' ),

	'base' => 'sm_team_slider',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Team Members Slider with Avatar', 'semona-extension' ),

	'as_parent' => array( 'only' => 'sm_team_slider_item' ),

	'content_element' => true,

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-team_slider.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Slider Style', 'semona-extension' ),

			'value' => sm_get_team_slider_styles_array(),

			'param_name' => 'style',

			'description' => esc_html__( 'Select team slider style.', 'semona-extension' ),

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Max Items in screen', 'semona-extension' ),

			'value' => sm_get_team_slider_items_array(),

			'param_name' => 'items',

			'description' => esc_html__( 'Select maximum number of items to appear in screen. (Note: Actual number of items will be determined by screen width)', 'semona-extension' ),

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Show Navigation Arrows', 'semona-extension' ),

			'param_name' => 'show_nav',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'std' => 'yes',

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Show Navigation Bullets', 'semona-extension' ),

			'param_name' => 'show_pagination',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Name Color', 'semona-extension' ),

			'param_name' => 'name_color',

			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Title Color', 'semona-extension' ),

			'param_name' => 'title_color',

			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Text Color', 'semona-extension' ),

			'param_name' => 'text_color',

			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Link Color', 'semona-extension' ),

			'param_name' => 'link_color',

			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		sm_extra_class()

	),

	'js_view' => 'VcColumnView',

) );



