<?php

function sm_tabs_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'tabs', $view_params );
}

function sm_register_shortcode_handler_sm_tabs() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tabs.php' );
		class WPBakeryShortCode_sm_tabs extends WPBakeryShortCode_VC_Tabs {
			public function getTabTemplate() {
				return '<div class="wpb_template">' . do_shortcode( '[sm_tab title="Tab" tab_id=""][/sm_tab]' ) . '</div>';
			}
			function content($atts, $content = null) {
				return sm_tabs_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_tabs', 'sm_tabs_func' );
	}
}

$tab_id_1 = 'def' . time() . '-1-' . rand( 0, 100 );
$tab_id_2 = 'def' . time() . '-2-' . rand( 0, 100 );

sm_register_shortcode( array (
	'name' => esc_html__( 'Tabs', 'semona-extension' ),
	'base' => 'sm_tabs',
	'show_settings_on_create' => false,
	'is_container' => true,
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Tabbed content', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-tabs.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'semona-extension' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'semona-extension' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Auto rotate', 'semona-extension' ),
			'param_name' => 'interval',
			'value' => array( esc_html__( 'Disable', 'semona-extension' ) => 0, 3, 5, 10, 15 ),
			'std' => 0,
			'description' => esc_html__( 'Auto rotate tabs each X seconds.', 'semona-extension' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Tab Style', 'semona-extension' ),
			'param_name' => 'style',
			'description' => esc_html__( 'Select Tab Style.', 'semona-extension' ),
			'value' => sm_get_tabs_styles_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Tab Shape', 'semona-extension' ),
			'param_name' => 'shape',
			'description' => esc_html__( 'Select Tab Shape.', 'semona-extension' ),
			'value' => sm_get_accordion_tab_shapes_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Header Color', 'semona-extension' ),
			'param_name' => 'header_color',
			'description' => esc_html__( 'Select header background color.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_bg_colors_array( true ),
			'std' => 'sm-grey',
			'dependency' => array(
				'element' => 'style',
				'value_not_equal_to' => array( 'sm-style-outline' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Header Color', 'semona-extension' ),
			'param_name' => 'custom_header_color',
			'description' => esc_html__( 'Choose inactive header background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'header_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Header Text Color', 'semona-extension' ),
			'param_name' => 'custom_header_text_color',
			'description' => esc_html__( 'Choose inactive header text color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'header_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Active Header Color', 'semona-extension' ),
			'param_name' => 'active_header_color',
			'description' => esc_html__( 'Select active header background color.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_bg_colors_array( true ),
			'dependency' => array(
				'element' => 'style',
				'value_not_equal_to' => array( 'sm-style-outline' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Active Header Color', 'semona-extension' ),
			'param_name' => 'custom_active_header_color',
			'description' => esc_html__( 'Choose active header background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'active_header_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Active Header Text Color', 'semona-extension' ),
			'param_name' => 'custom_active_header_text_color',
			'description' => esc_html__( 'Choose active header text color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'active_header_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Active Header Decoration', 'semona-extension' ),
			'param_name' => 'header_style',
			'description' => esc_html__( 'Select active header style.', 'semona-extension' ),
			'value' => sm_get_tabs_header_styles_array(),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value_not_equal_to' => array( 'sm-style-outline' )
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Active Header Border Color', 'semona-extension' ),
			'param_name' => 'header_border_color',
			'description' => esc_html__( 'Select active header border color.', 'semona-extension' ),
			'value' => sm_get_preset_colors_array( true ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'dependency' => array(
				'element' => 'header_style',
				'value' => array( 'sm-header-border-top', 'sm-header-border-bottom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Active Header Border Color', 'semona-extension' ),
			'param_name' => 'custom_header_border_color',
			'description' => esc_html__( 'Choose active header border color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'header_border_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Content Background Color', 'semona-extension' ),
			'param_name' => 'content_bg',
			'description' => esc_html__( 'Select content background color.', 'semona-extension' ),
			'value' => sm_get_tabs_content_bg_colors_array(),
			'dependency' => array(
				'element' => 'style',
				'value_not_equal_to' => array( 'sm-style-outline' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show Content Border', 'semona-extension' ),
			'param_name' => 'content_border',
			'description' => esc_html__( 'Put checkmark to show content border.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'std' => 'yes',
			'dependency' => array(
				'element' => 'content_bg',
				'value' => array( 'sm-bg-color-content', 'sm-bg-color2-content' )
			),
			'group' => esc_html__( 'Styling', 'semona-extension' ),
		),
		sm_extra_class()
	),
	'custom_markup' => '
<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
<ul class="tabs_controls">
</ul>
%content%
</div>'
,
	'default_content' => '
[sm_tab title="' . esc_html__( 'Tab 1', 'semona-extension' ) . '" tab_id="' . $tab_id_1 . '"][/sm_tab]
[sm_tab title="' . esc_html__( 'Tab 2', 'semona-extension' ) . '" tab_id="' . $tab_id_2 . '"][/sm_tab]
',
	'js_view' => 'SMTabsView'
) );

