<?php



function sm_register_shortcode_handler_sm_stretch_container() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_stretch_container extends WPBakeryShortCodesContainer {

			function content($atts, $content = null) {

				return sm_stretch_container_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_stretch_container', 'sm_stretch_container_func' );

	}

}



function sm_stretch_container_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'stretch-container', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Stretching Container', 'semona-extension' ),

	'base' => 'sm_stretch_container',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	"as_parent" => array('except' => array( 'vc_row', 'vc_row_inner' ) ),

	'description' => esc_html__( 'Stretches inner content to left or right and docks content to vertically middle or bottom', 'semona-extension' ),

	'content_element' => true,

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-stretch_container.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Stretching Type', 'semona-extension' ),

			'value' => sm_get_stretch_container_types_array(),

			'param_name' => 'type',

			'description' => esc_html__( 'Select stretching type of content.', 'semona-extension' ),

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Dock Type', 'semona-extension' ),

			'value' => sm_get_stretch_container_valigns_array(),

			'param_name' => 'dock',

			'description' => esc_html__( 'Select dock type of content.', 'semona-extension' ),

		),

		array(

			'type' => 'attach_image',

			'heading' => esc_html__( 'Background Image', 'semona-extension' ),

			'param_name' => 'bg_image',

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Background Position', 'semona-extension' ),

			'param_name' => 'bg_pos',

			'value' => '',

			'description' => esc_html__( 'Enter Background Position, e.g. \'center center\' or \'120px 100px\'.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Background Color', 'semona-extension' ),

			'param_name' => 'bg_color',

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		sm_extra_class(),

	),

	'js_view' => 'VcColumnView',

) );



