<?php

function sm_readmore_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'readmore', $view_params );

}



function sm_register_shortcode_handler_sm_readmore() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_readmore extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_readmore_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_readmore', 'sm_readmore_func' );

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Read More Link', 'semona-extension' ),

	'base' => 'sm_readmore',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Styled Read More Link', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-readmore.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Style', 'semona-extension' ),

			'param_name' => 'style',

			'value' => sm_readmore_styles_array()

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Read More Link', 'semona-extension' ),

			'param_name' => 'href',

			'description' => esc_html__( 'Enter a link to read more.', 'semona-extension' )

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Read More Text', 'semona-extension' ),

			'param_name' => 'content',

			'description' => esc_html__( 'Enter label for read more. (ex. Read More, Continue Reading, etc.)', 'semona-extension' )

		),

		sm_extra_class()

	),

) );