<?php



if( !function_exists( 'sm_rating_func' ) ) {

	function sm_rating_func( $atts, $content = null ) {

		extract ( shortcode_atts ( array (

			'align' => '',

			'value' => '5', 

		), $atts ) );



		$align = sm_validate_with_array( $align, sm_get_default_aligns_array() );



		$css_class = array( 'sm-rating' );

		if ( !empty( $align) ) $css_class[] = $align;

		$width = $value * 100 / 5;

		$title = sprintf( esc_html__( '%s out of %s', 'semona-extension' ), $value, 5 );

		$output = '';

		$output .= '<div class="' . implode( ' ', $css_class ) . '" title="' . $title . '">';

			$output .= '<div class="align-wrap">';

				$output .= '<div class="grey-stars">';

				for ( $i = 0; $i < 5; $i ++ ) {

					$output .= '<i class="fa fa-star"></i>';

				}

				$output .= '</div>';

				$output .= '<div class="value-stars" style="width:' . $width . '%">';

				for ( $i = 0; $i < 5; $i ++ ) {

					$output .= '<i class="fa fa-star"></i>';

				}

				$output .= '</div>';

			$output .= '</div>';

		$output .= '</div>';

		return $output;

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Rating', 'semona-extension' ),

	'base' => 'sm_rating',

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-rating.png',

	'params' => array(

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Rating Value', 'semona-extension' ),

			'param_name' => 'value',

			'value' => '5'

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Align', 'semona-extension' ),

			'param_name' => 'align',

			'value' => sm_get_default_aligns_array(),

		)

	)

) );