<?php



function sm_register_shortcode_handler_sm_quotes_slider() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_quotes_slider extends WPBakeryShortCodesContainer {

			function content($atts, $content = null) {

				return sm_quotes_slider_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_quotes_slider', 'sm_quotes_slider_func' );

	}

}



function sm_quotes_slider_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'quotes-slider', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Quotes Slider', 'semona-extension' ),

	'base' => 'sm_quotes_slider',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Quotes Slider', 'semona-extension' ),

	'as_parent' => array( 'only' => 'sm_quote' ),

	'content_element' => true,

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-quotes_slider.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Style', 'semona-extension' ),

			'value' => sm_get_quotes_style_array(),

			'param_name' => 'style',

			'description' => esc_html__( 'Select style.', 'semona-extension' ),

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Skin', 'semona-extension' ),

			'value' => sm_get_skins_array( true ),

			'param_name' => 'theme',

			'description' => esc_html__( 'Select theme.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Content Font Size', 'semona-extension' ),

			'value' => sm_get_quote_font_sizes_array(),

			'param_name' => 'content_fontsize',

			'description' => esc_html__( 'Select quote content font size.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		sm_extra_class()

	),

	'js_view' => 'VcColumnView',

) );



