<?php



function sm_register_shortcode_handler_sm_quote() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_quote extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_quote_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_quote', 'sm_quote_func' );

	}

}



function sm_quote_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'quote', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Quote Slider Item', 'semona-extension' ),

	'base' => 'sm_quote',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Quote Item', 'semona-extension' ),

	'as_child' => array( 'only' => 'sm_quotes_slider' ),

	'content_element' => true,

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-quote.png',

	'params' => array(

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Name', 'semona-extension' ),

			'param_name' => 'name',

			'value' => '',

			'admin_label' => true 

		),

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Title', 'semona-extension' ),

			'param_name' => 'company',

			'value' => '',

			'admin_label' => true 

		),

		array (

			'type' => 'textarea',

			'heading' => esc_html__( 'Quote Text', 'semona-extension' ),

			'param_name' => 'content',

			'value' => '',

		),

		sm_extra_class()

	),

) );



