<?php



function sm_register_shortcode_handler_sm_progress_steps() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_progress_steps extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_progress_steps_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_progress_steps', 'sm_progress_steps_func' );

	}

}



function sm_progress_steps_func( $atts, $content = '' ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);



	return sm_render_view( 'progress-steps', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Progress Steps', 'semona-extension' ),

	'base' => 'sm_progress_steps',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-progress_steps.png',

	'params' => array (

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Progress Steps Type', 'semona-extension' ),

			'param_name' => 'type',

			'value' => sm_get_progress_steps_type_array(),

			'admin_label' => true,

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Column Grids', 'semona-extension' ),

			'param_name' => 'columns',

			'value' => sm_get_progress_steps_columns_array(),

			'std' => '4',

			'admin_label' => true,

			'edit_field_class' => 'vc_col-sm-6 vc_column',

			'dependency' => array(

				'element' => 'type',

				'value' => array( 'sm-type1', 'sm-type3' ),

			),

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Color Scheme', 'semona-extension' ),

			'param_name' => 'theme',

			'value' => sm_get_skins_array( true ),

			'admin_label' => true,

			'edit_field_class' => 'vc_col-sm-6 vc_column',

			'dependency' => array(

				'element' => 'type',

				'value' => 'sm-type1',

			),

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Progress Step Style', 'semona-extension' ),

			'param_name' => 'step_style',

			'value' => sm_get_progress_steps_style_array(),

			'admin_label' => true,

			'edit_field_class' => 'vc_col-sm-6 vc_column',

			'description' => esc_html__( 'If you want to show icons you choose below, be sure to choose Icon Style.', 'semona-extension' ),

			'dependency' => array(

				'element' => 'type',

				'value' => 'sm-type1',

			),

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Current Step Number', 'semona-extension' ),

			'param_name' => 'current_step',

			'description' => esc_html__( 'Enter current step number. Leave blank to style all steps unfinished.', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

			'dependency' => array(

				'element' => 'type',

				'value' => array( 'sm-type1', 'sm-type3' ),

			),

		),

		array(

			'type' => 'param_group',

			'heading' => esc_html__( 'Values', 'semona-extension' ),

			'param_name' => 'values',

			'value' => urlencode( json_encode( array(

				array(

					'title' => esc_html__( 'Step One', 'semona-extension' ),

					'text' => 'Enter some text here.',

				),

				array(

					'title' => esc_html__( 'Step Two', 'semona-extension' ),

					'text' => 'Enter some text here.',

				)

			) ) ),

			'params' => array_merge( 

				array(

					array(

						'type' => 'textfield',

						'heading' => esc_html__( 'Title', 'semona-extension' ),

						'param_name' => 'title',

						'description' => esc_html__( 'Enter title here.', 'semona-extension' ),

						'admin_label' => true

					),

					array(

						'type' => 'textarea',

						'heading' => esc_html__( 'Text', 'semona-extension' ),

						'param_name' => 'text',

						'description' => esc_html__( 'Enter some text here.', 'semona-extension' ),

					),

				),

				sm_get_icon_options_array( '', true )

			),

		),

		sm_css_animation_class(),

		sm_css_animation_delay(),

		sm_extra_class () 

	) 

) );

