<?php



function sm_register_shortcode_handler_sm_pricing_table() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_pricing_table extends WPBakeryShortCodesContainer {

			function content($atts, $content = null) {

				return sm_pricing_table_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_pricing_table', 'sm_pricing_table_func' );

	}

}



function sm_pricing_table_func( $atts, $content = '' ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);



	return sm_render_view( 'pricing-table', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Pricing Table', 'semona-extension' ),

	'base' => 'sm_pricing_table',

	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-pricing_table.png',

	'as_parent' => array( 'only' => 'sm_pricing_column' ),

	'content_element' => true,

	'js_view' => 'VcColumnView',

	'show_settings_on_create' => true,

	'params' => array (

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Table Style', 'semona-extension' ),

			'param_name' => 'style',

			'value' => sm_get_pricingtable_styles_array(),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Columns', 'semona-extension' ),

			'param_name' => 'columns',

			'value' => sm_get_pricingtable_columns_array(),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Color Scheme', 'semona-extension' ),

			'param_name' => 'theme',

			'value' => sm_get_pricingtable_color_schemes_array(),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array (

			'type' => 'dropdown',

			'heading' => esc_html__( 'Button Shape', 'semona-extension' ),

			'param_name' => 'button_shape',

			'value' => sm_get_button_shapes_array(),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		

		sm_extra_class()

	) 

) );