<?php



function sm_register_shortcode_handler_sm_portfolio() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_portfolio extends WPBakeryShortCode {

			protected function outputTitle( $title ) {

				return '';

			}

			function content($atts, $content = null) {

				return sm_portfolio_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_portfolio', 'sm_portfolio_func' );

	}

}



function sm_portfolio_func( $atts, $content = '' ) {

	$view_params = array(

			'atts' => $atts,

			'content' => $content

	);

	return sm_render_view( 'portfolio', $view_params );

}



sm_register_shortcode( array (

		'name' => esc_html__( 'Portfolio', 'semona-extension' ),

		'base' => 'sm_portfolio',

		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-portfolio.png',

		'params' => array (

				array (

						'type' => 'dropdown',

						'heading' => esc_html__( 'Portfolio Style', 'semona-extension' ),

						'param_name' => 'style',

						'value' => array (

								esc_html__( 'Masonry v1', 'semona-extension' ) => 'masonry',

								esc_html__( 'Masonry v2', 'semona-extension' ) => 'masonry2',

								esc_html__( 'Masonry v3', 'semona-extension' ) => 'masonry3',

								esc_html__( 'Grid v1', 'semona-extension' ) => 'grid',

								esc_html__( 'Grid v2', 'semona-extension' ) => 'grid2',

								esc_html__( 'Grid v3', 'semona-extension' ) => 'grid3',

								esc_html__( 'Grid v4', 'semona-extension' ) => 'grid4',

						),

						'admin_label' => true,

				),

				array (

						'type' => 'dropdown',

						'heading' => esc_html__( 'Columns', 'semona-extension' ),

						'param_name' => 'column_count',

						'value' => array (

								'1' => '1',

								'2' => '2',

								'3' => '3',

								'4' => '4',

								'5' => '5',

								'6' => '6',

						) 

				),

				array (

						'type' => 'textfield',

						'heading' => esc_html__( 'Posts Per Page', 'semona-extension' ),

						'param_name' => 'per_page',

						'value' => '',

						'description' => esc_html__( 'Leave empty for using default theme option value.', 'semona-extension' ) 

				),

				array (

						'type' => 'dropdown',

						'heading' => esc_html__( 'Show Category Filter', 'semona-extension' ),

						'param_name' => 'show_filter',

						'value' => array (

								esc_html__( 'No', 'semona-extension' ) => 'no',

								esc_html__( 'Yes', 'semona-extension' ) => 'yes',

						) 

				),

				array (

						'type' => 'dropdown',

						'heading' => esc_html__( 'Pagination Type', 'semona-extension' ),

						'param_name' => 'pagination_type',

						'value' => array (

								esc_html__( 'None', 'semona-extension' ) => 'none',

								esc_html__( 'Pagination', 'semona-extension' ) => 'pagination',

								esc_html__( 'Load More Button', 'semona-extension' ) => 'loadmore',

								esc_html__( 'Infinite Scroll', 'semona-extension' ) => 'infinitescroll',

						) 

				),

				array(

						'type' => 'checkbox',

						'heading' => esc_html__( 'Disable padding between items', 'semona-extension' ),

						'param_name' => 'disable_padding',

						'description' => esc_html__( 'Check this box to remove padding between portfolio items.', 'semona-extension' ),

						'dependency' => array(

								'element' => 'style',

								'value' => array( 'masonry', 'masonry2', 'grid', 'grid3' )

						),

				),

				array(

						'type' => 'checkbox',

						'heading' => esc_html__( 'Items Appearing Animation', 'semona-extension' ),

						'param_name' => 'appear_animation',

						'description' => esc_html__( 'Check this box to use appearing animation.', 'semona-extension' ),

						'std' => true,

				),

				array(

						'type' => 'autocomplete',

						'heading' => esc_html__( 'Categories To Display', 'semona-extension' ),

						'param_name' => 'categories',

						'settings' => array(

								'multiple' => true,

								'min_length' => 1,

								'groups' => true,

								'unique_values' => true,

								'display_inline' => true,

								'delay' => 500,

								'auto_focus' => true,

						),

						'param_holder_class' => 'vc_not-for-custom',

						'description' => esc_html__( 'Enter post categories.', 'semona-extension' ),

				),

				sm_extra_class(), 

		) 

) );



add_filter( 'vc_autocomplete_sm_portfolio_categories_render', 'sm_portfolio_categories_vc_autocomplete_render', 10, 1 );

function sm_portfolio_categories_vc_autocomplete_render( $term ) {

	$terms = get_terms(

			array( 'portfolio_category' ),

			array(

					'include' => array( $term['value'] ),

					'hide_empty' => false,

			)

	);

	$data = false;

	if ( is_array( $terms ) && 1 === count( $terms ) ) {

		$term = $terms[0];

		$data = array(

				'label' => $term->name,

				'value' => $term->term_id,

		);

	}



	return $data;

}



add_filter( 'vc_autocomplete_sm_portfolio_categories_callback', 'sm_portfolio_categories_vc_autocomplete_search', 10, 1 );

function sm_portfolio_categories_vc_autocomplete_search( $search_string ) {

	$data = array();

	$terms = get_terms(

			array( 'portfolio_category' ),

			array(

					'search' => $search_string,

					'hide_empty' => false,

			)

	);

	if ( is_array( $terms ) && ! empty( $terms ) ) {

		foreach ( $terms as $t ) {

			if ( is_object( $t ) ) {

				$data[] = array(

						'label' => $t->name,

						'value' => $t->term_id,

				);

			}

		}

	}



	return $data;

}