<?php



function sm_register_shortcode_handler_sm_pie() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_pie extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_pie_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_pie', 'sm_pie_func' );

	}

}



function sm_pie_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);



	return sm_render_view( 'pie', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Progress Circle', 'semona-extension' ),

	'base' => 'sm_pie',

	'class' => '',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Animated pie chart', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-pie.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Style', 'semona-extension' ),

			'param_name' => 'style',

			'value' => sm_get_pie_chart_styles_array(),

			'description' => esc_html__( 'Select pie chart style.', 'semona-extension' ),

			'admin_label' => true,

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Widget title', 'semona-extension' ),

			'param_name' => 'title',

			'description' => esc_html__( 'Enter text used as widget title.', 'semona-extension' ),

			'admin_label' => true

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Value', 'semona-extension' ),

			'param_name' => 'value',

			'description' => esc_html__( 'Enter % value for graph (Note: choose range from 0 to 100).', 'semona-extension' ),

			'value' => '50',

			'admin_label' => true,

			'edit_field_class' => 'vc_col-sm-4 vc_column',

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Label value', 'semona-extension' ),

			'param_name' => 'label_value',

			'description' => esc_html__( 'Enter label for progress circle (Note: leaving empty will set value from "Value" field).', 'semona-extension' ),

			'value' => '',

			'edit_field_class' => 'vc_col-sm-4 vc_column',

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Units', 'semona-extension' ),

			'param_name' => 'units',

			'description' => esc_html__( 'Enter measurement units (Example: %, px, points, etc.).', 'semona-extension' ),

			'edit_field_class' => 'vc_col-sm-4 vc_column',

		),

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Progress Arc Color', 'semona-extension' ),

			'param_name' => 'color',

			'value' => sm_get_preset_colors_array( false, false ),

			'description' => esc_html__( 'Select pie chart color.', 'semona-extension' ),

			'admin_label' => true,

			'param_holder_class' => 'sm-preset-color-dropdown',

			'group' => esc_html__( 'Colors', 'semona-extension' )

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Custom Progress Arc Color', 'semona-extension' ),

			'param_name' => 'custom_color',

			'dependency' => array(

				'element' => 'color',

				'value' => array( 'custom' )

			),

			'group' => esc_html__( 'Colors', 'semona-extension' )

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Text Color', 'semona-extension' ),

			'param_name' => 'text_color',

			'description' => esc_html__( 'Select text color. Leave blank to use default.', 'semona-extension' ),

			'group' => esc_html__( 'Colors', 'semona-extension' )

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Back Circle Color', 'semona-extension' ),

			'param_name' => 'back_color',

			'description' => esc_html__( 'Select background circle color. Leave blank to use default.', 'semona-extension' ),

			'group' => esc_html__( 'Colors', 'semona-extension' )

		),

		array(

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Head Circle Color', 'semona-extension' ),

			'param_name' => 'head_color',

			'description' => esc_html__( 'Select progress arc head color. Leave blank to use default.', 'semona-extension' ),

			'group' => esc_html__( 'Colors', 'semona-extension' )

		),

		sm_css_animation_class(),

		sm_css_animation_delay(),

		sm_extra_class()

	)

) );

