<?php



function sm_register_shortcode_handler_sm_parallax_layers() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_parallax_layers extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_parallax_layers_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_parallax_layers', 'sm_parallax_layers_func' );

	}

}



function sm_parallax_layers_func( $atts, $content = '' ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);



	return sm_render_view( 'parallax-layers', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Parallax Layers', 'semona-extension' ),

	'base' => 'sm_parallax_layers',

	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'allowed_container_element' => 'vc_row',

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-parallax_layers.png',

	'params' => array (

		array(

			'type' => 'attach_images',

			'heading' => esc_html__( 'Layers', 'semona-extension' ),

			'param_name' => 'images'

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Full Screen Height', 'semona-extension' ),

			'param_name' => 'full_screen',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'checkbox',

			'heading' => esc_html__( 'Use Parallax for Content', 'semona-extension' ),

			'param_name' => 'is_parallax_content',

			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			'edit_field_class' => 'vc_col-sm-6 vc_column',

		),

		array(

			'type' => 'textfield',

			'heading' =>  esc_html__( 'Height (px)', 'semona-extension' ),

			'param_name' => 'height',

			'value' => '',

			'dependency' => array(

				'element' => 'full_screen',

				'value_not_equal_to' => 'yes'

			)

		),

		array(

			'type' => 'textarea_html',

			'heading' =>  esc_html__( 'Content', 'semona-extension' ),

			'param_name' => 'content',

			'value' => '',

			'description' => 'This content will be displayed as final (top) layer over all other layers'

		),

		sm_extra_class()

	)

) );